/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.config;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import de.accxia.jira.addon.IUM.cache.AccxiaCachePropertySet;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={DAO.class})
@Named(value="DAO")
public class DAO {
    private static final Logger LOG = LoggerFactory.getLogger(DAO.class);
    public static final String REST_ROUTE = "urlRest";
    public static final String REST_INIT = "initRest";
    public static final String RESERVED_LICENSE = "reservedLicense";
    public static final String INACTIVITY_DURATION = "inactivityDuration";
    public static final String REMOVAL_INACTIVITY_DURATION = "removalInactivityDuration";
    public static final String REPEAT_INTERVAL = "interval";
    public static final String STARTING_AT = "startingAt";
    public static final String STARTING_FROM = "startingFrom";
    public static final String REMOVAL_CRON_EXPRESSION = "removalCronExpression";
    public static final String SIDE_LICENSE_NO = "SIDE_LICENSE_NO";
    public static final String SIDE_LICENSE_END = "SIDE_LICENSE_END";
    public static final String SIDE_LICENSE_BODY = "SIDE_LICENSE_BODY";
    public static final String WORKING_JOB = "workingJob";
    public static final String AUTO_CONNECT = "autoConnect";
    public static final String IUMGroup = "IUMGroup";
    public static final String IUMGroupDIS = "IUMGroupDIS";
    public static final String SYNC_REPEAT_INTERVAL = "syncRepeatInterval";
    public static final String SYNC_STARTING_AT = "syncStartingAt";
    public static final String SYNC_STARTING_FROM = "syncStartingFrom";
    public static final String SYNC_CRON_EXPRESSION = "syncCronExpression";
    public static final String SYNC_SOFTWARE_SRC_GROUP = "syncSoftwareSrcGroup";
    public static final String SYNC_SOFTWARE_TARGET_GROUP = "syncSoftwareTargetGroup";
    public static final String SYNC_SERVICE_DESK_SRC_GROUP = "syncSDeskSrcGroup";
    public static final String SYNC_SERVICE_DESK_TARGET_GROUP = "syncSDeskTargetGroup";
    public static final String WATCHER_REPEAT_INTERVAL = "watcherRepeatInterval";
    public static final String WATCHER_INACTIVITY_DURATION = "watcherInactivityDuration";
    public static final String WATCHER_GROUP_LEVEL = "watcherGroupLevel";
    public static final String WATCHER_REMOVAL_COUNT = "watcherRemovalCount";
    public static final String WATCHER_JOB = "watcherJob";
    public static final String WORKING_SYNC_JOB = "workingSyncJob";
    public static final String DAILY_STARTING_FROM = "dailyStartingFrom";
    public static final String DAILY_REPEAT_INTERVAL = "dailyRepeatInterval";
    public static final String DAILY_CRON_EXPRESSION = "dailyCronExpression";
    public static final String WORKING_DAILY_JOB = "workingDailyJob";
    public static final String LOGGER = "logger";
    public static final String LOGGER_KEY = "de.accxia.jira.addon.IUM";
    private static final String PLUGIN_STORAGE_KEY = "de.accxia.jira.addons.usermanager";
    private static PluginSettingsFactory pluginSettingsFactory = (PluginSettingsFactory)ComponentAccessor.getOSGiComponentInstanceOfType(PluginSettingsFactory.class);
    private static PluginSettings pluginSettings;
    private static AccxiaCachePropertySet accxiaCachePropertySet;

    @Inject
    public DAO(AccxiaCachePropertySet accxiaCachePropertySet) {
        pluginSettings = pluginSettingsFactory.createGlobalSettings();
        DAO.accxiaCachePropertySet = accxiaCachePropertySet;
    }

    public static PluginSettings getPluginSettings() {
        if (pluginSettings == null) {
            pluginSettings = pluginSettingsFactory.createGlobalSettings();
        }
        return pluginSettings;
    }

    private static String emptyValueFromNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public static String getValue(String field) {
        PluginSettings pluginSettings = DAO.getPluginSettings();
        if (accxiaCachePropertySet == null) {
            Object value;
            if (LOG.isDebugEnabled()) {
                LOG.debug("DAO.accxiaCachePropertySet is NULL");
            }
            if ((value = pluginSettings.get("de.accxia.jira.addons.usermanager." + field)) == null || "null".equals(value)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("pluginSettings find field={} value=NULL ==> \"\"", new Object[]{field});
                }
                value = "";
                pluginSettings.put("de.accxia.jira.addons.usermanager." + field, (Object)"");
                return "";
            }
            String res = String.valueOf(value);
            if (LOG.isDebugEnabled()) {
                LOG.debug("from pluginSettings accxiaCachePropertySet=NULL field={} value={}", new Object[]{field, res});
            }
            return DAO.emptyValueFromNull(res);
        }
        if (accxiaCachePropertySet.hasKey(field)) {
            String ourVal = accxiaCachePropertySet.getValue(field);
            if (LOG.isTraceEnabled()) {
                LOG.trace("DAO.accxiaCachePropertySet field={} value={}", new Object[]{field, ourVal});
            }
            return DAO.emptyValueFromNull(ourVal);
        }
        Object value = pluginSettings.get("de.accxia.jira.addons.usermanager." + field);
        if (value == null || "null".equals(value)) {
            return "";
        }
        String res = String.valueOf(value);
        if (LOG.isTraceEnabled()) {
            LOG.trace("from pluginSettings field={} value={}", new Object[]{field, res});
        }
        accxiaCachePropertySet.setValue(field, res);
        return DAO.emptyValueFromNull(res);
    }

    public static void setValue(String field, String value) {
        PluginSettings pluginSettings = DAO.getPluginSettings();
        pluginSettings.put("de.accxia.jira.addons.usermanager." + field, (Object)value);
        if (accxiaCachePropertySet != null) {
            accxiaCachePropertySet.setValue(field, value);
        }
    }

    public static String getValueX(String field) {
        PluginSettings pluginSettings = DAO.getPluginSettings();
        Object value = pluginSettings.get("de.accxia.jira.addons.usermanager." + field);
        if (value == null || "null".equals(value)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("pluginSettings find field={} value=NULL ==> \"\"", new Object[]{field});
            }
            value = "";
            pluginSettings.put("de.accxia.jira.addons.usermanager." + field, (Object)"");
            return "";
        }
        String res = String.valueOf(value);
        if (LOG.isDebugEnabled()) {
            LOG.debug("from pluginSettings accxiaCachePropertySet=NULL field={} value={}", new Object[]{field, res});
        }
        return DAO.emptyValueFromNull(res);
    }

    public static void setValueX(String field, String value) {
        PluginSettings pluginSettings = DAO.getPluginSettings();
        pluginSettings.put("de.accxia.jira.addons.usermanager." + field, (Object)value);
    }

    public static void updateIUMGroup(String value) {
        DAO.setValue(IUMGroup, value);
    }

    public static String getIUMGroups() {
        String value = DAO.getValue(IUMGroup);
        return value;
    }

    public static void updateIUMGroupDisabled(String value) {
        DAO.setValue(IUMGroupDIS, value);
    }

    public static String getIUMGroupsDisabled() {
        String value = DAO.getValue(IUMGroupDIS);
        return value;
    }

    public static String getIUMSoftGroupsDisabled() {
        String groups = DAO.getIUMGroupsDisabled();
        if (StringUtils.isEmpty((CharSequence)groups)) {
            return "";
        }
        String[] group = groups.split(",");
        if (group.length > 0) {
            return group[0];
        }
        return "";
    }

    public static String getIUMSDeskGroupsDisabled() {
        String groups = DAO.getIUMGroupsDisabled();
        if (StringUtils.isEmpty((CharSequence)groups)) {
            return "";
        }
        String[] group = groups.split(",");
        if (group.length > 1) {
            return group[1];
        }
        return "";
    }

    public static String getIUMSoftGroupsEnable() {
        String groups = DAO.getIUMGroups();
        if (StringUtils.isEmpty((CharSequence)groups)) {
            return "";
        }
        String[] group = groups.split(",");
        if (group.length > 0) {
            return group[0];
        }
        return "";
    }

    public static String getIUMSDeskGroupsEnable() {
        String groups = DAO.getIUMGroups();
        if (StringUtils.isEmpty((CharSequence)groups)) {
            return "";
        }
        String[] group = groups.split(",");
        if (group.length > 1) {
            return group[1];
        }
        return "";
    }

    public static void updateDuration(String value) {
        DAO.setValue("duration", value);
    }

    public static String getDuration() {
        String duration = DAO.getValue("duration");
        return duration;
    }

    public static void updateQueueSize(String value) {
        DAO.setValue("queueSize", value);
    }

    public static String getQueueSize() {
        String queueSize = DAO.getValue("queueSize");
        return queueSize;
    }

    public static void updateUrlLogo(String value) {
        DAO.setValue("urlLogo", value);
    }

    public static String getUrlLogo() {
        return DAO.getValue("urlLogo");
    }

    public static void updateHeightLogo(String value) {
        DAO.setValue("heightLogo", value);
    }

    public static String getHeightLogo() {
        return DAO.getValue("heightLogo");
    }

    public static void updateQueueMessage(String value) {
        DAO.setValue("queueMessage", value);
    }

    public static String getQueueMessage() {
        return DAO.getValue("queueMessage");
    }

    public static void updateTempDisconnectMessage(String value) {
        DAO.setValue("tempDisconnect", value);
    }

    public static String getTempDisconnectMessage() {
        return DAO.getValue("tempDisconnect");
    }

    public static void updateUrlRest(String value) {
        DAO.setValue(REST_ROUTE, value);
    }

    public static String getUrlRest() {
        String urlRest = DAO.getValue(REST_ROUTE);
        return urlRest;
    }

    public static void updateSamlIdp(String value) {
        DAO.setValue("samlIdp", value);
    }

    public static String getSamlIdp() {
        String samlIdp = DAO.getValue("samlIdp");
        return samlIdp;
    }

    public static void updateSamlMapping(String value) {
        DAO.setValue("samlMapping", value);
    }

    public static String getSamlMapping() {
        String samlMapping = DAO.getValue("samlMapping");
        return samlMapping;
    }

    public static void updateSamlRegex(String value) {
        DAO.setValue("samlRegex", value);
    }

    public static String getSamlRegex() {
        String samlRegex = DAO.getValue("samlRegex");
        return samlRegex == null ? "" : samlRegex;
    }

    public static String getReservedLicense() {
        String reservedLicense = DAO.getValue(RESERVED_LICENSE);
        if (reservedLicense == null || "".equals(reservedLicense)) {
            reservedLicense = String.valueOf(3);
            DAO.updateReservedLicense(reservedLicense);
        }
        return reservedLicense;
    }

    public static void updateReservedLicense(String value) {
        DAO.setValue(RESERVED_LICENSE, value);
    }

    public static void updateSideLicense(String value) {
        DAO.setValue("sideLicense", value);
    }

    public static String getSideLicense() {
        String sideLicense = DAO.getValue("sideLicense");
        return sideLicense == null ? "" : sideLicense;
    }

    public static String getInactivityDuration() {
        String inactivityDuration = DAO.getValue(INACTIVITY_DURATION);
        if (inactivityDuration == null || "".equals(inactivityDuration)) {
            inactivityDuration = "5";
            DAO.updateInactivityDuration(inactivityDuration);
        }
        return inactivityDuration;
    }

    public static void updateInactivityDuration(String value) {
        DAO.setValue(INACTIVITY_DURATION, value);
    }

    public static String getRepeatInterval() {
        String repeatInterval = DAO.getValue(REPEAT_INTERVAL);
        return repeatInterval;
    }

    public static void updateRepeatInterval(String value) {
        DAO.setValue(REPEAT_INTERVAL, value);
    }

    public static void updateStartingAt(String value) {
        DAO.setValue(STARTING_AT, value);
    }

    public static String getStartingAt() {
        return DAO.getValue(STARTING_AT);
    }

    public static void updateStartingFrom(String value) {
        DAO.setValue(STARTING_FROM, value);
    }

    public static String getStartingFrom() {
        return DAO.getValue(STARTING_FROM);
    }

    public static String getRemovalInactivityDuration() {
        String removalInactivityDuration = DAO.getValue(REMOVAL_INACTIVITY_DURATION);
        if (removalInactivityDuration == null || "".equals(removalInactivityDuration)) {
            removalInactivityDuration = "5";
            DAO.updateRemovalInactivityDuration(removalInactivityDuration);
        }
        return removalInactivityDuration;
    }

    public static void updateRemovalInactivityDuration(String value) {
        DAO.setValue(REMOVAL_INACTIVITY_DURATION, value);
    }

    public static void updateRemovalCronExpression(String value) {
        DAO.setValue(REMOVAL_CRON_EXPRESSION, value);
    }

    public static String getRemovalCronExpression() {
        return DAO.getValue(REMOVAL_CRON_EXPRESSION);
    }

    public static void updateWorkingJob(String value) {
        DAO.setValue(WORKING_JOB, value);
    }

    public static String getWorkingJob() {
        return DAO.getValue(WORKING_JOB);
    }

    public static void updateSyncSoftwareSrcGoups(String value) {
        DAO.setValue(SYNC_SOFTWARE_SRC_GROUP, value);
    }

    public static String getSyncSoftwareSrcGoups() {
        String group = DAO.getValue(SYNC_SOFTWARE_SRC_GROUP);
        return group;
    }

    public static void updateSyncSoftwareTargetGoups(String value) {
        DAO.setValue(SYNC_SOFTWARE_TARGET_GROUP, value);
    }

    public static String getSyncSoftwareTargetGoups() {
        String group = DAO.getValue(SYNC_SOFTWARE_TARGET_GROUP);
        return group;
    }

    public static void updateSyncSDeskSrcGoups(String value) {
        DAO.setValue(SYNC_SERVICE_DESK_SRC_GROUP, value);
    }

    public static String getSyncSDeskSrcGoups() {
        String group = DAO.getValue(SYNC_SERVICE_DESK_SRC_GROUP);
        return group;
    }

    public static void updateSyncSDeskTargetGoups(String value) {
        DAO.setValue(SYNC_SERVICE_DESK_TARGET_GROUP, value);
    }

    public static String getSyncSDeskTargetGoups() {
        String group = DAO.getValue(SYNC_SERVICE_DESK_TARGET_GROUP);
        return group;
    }

    public static String getSyncRepeatInterval() {
        String repeatInterval = DAO.getValue(SYNC_REPEAT_INTERVAL);
        return repeatInterval;
    }

    public static void updateSyncRepeatInterval(String value) {
        DAO.setValue(SYNC_REPEAT_INTERVAL, value);
    }

    public static void updateSyncStartingAt(String value) {
        DAO.setValue(SYNC_STARTING_AT, value);
    }

    public static String getSyncStartingAt() {
        return DAO.getValue(SYNC_STARTING_AT);
    }

    public static void updateSyncStartingFrom(String value) {
        DAO.setValue(SYNC_STARTING_FROM, value);
    }

    public static String getSyncStartingFrom() {
        return DAO.getValue(SYNC_STARTING_FROM);
    }

    public static void updateSyncCronExpression(String value) {
        DAO.setValue(SYNC_CRON_EXPRESSION, value);
    }

    public static String getSyncCronExpression() {
        return DAO.getValue(SYNC_CRON_EXPRESSION);
    }

    public static void updateSyncWorkingJob(String value) {
        DAO.setValue(WORKING_SYNC_JOB, value);
    }

    public static String getSyncWorkingJob() {
        return DAO.getValue(WORKING_SYNC_JOB);
    }

    public static String getWatcherInactivityDuration() {
        String watcherInactivityDuration = DAO.getValue(WATCHER_INACTIVITY_DURATION);
        return watcherInactivityDuration;
    }

    public static void updateWatcherInactivityDuration(String value) {
        DAO.setValue(WATCHER_INACTIVITY_DURATION, value);
    }

    public static String getWatcherGroupLevel() {
        String watcherGroupLevel = DAO.getValue(WATCHER_GROUP_LEVEL);
        return watcherGroupLevel;
    }

    public static void updateWatcherGroupLevel(String value) {
        DAO.setValue(WATCHER_GROUP_LEVEL, value);
    }

    public static String getWatcherRemovalCount() {
        String watcherGroupLevel = DAO.getValue(WATCHER_REMOVAL_COUNT);
        return watcherGroupLevel;
    }

    public static void updateWatcherRemovalCount(String value) {
        DAO.setValue(WATCHER_REMOVAL_COUNT, value);
    }

    public static String getWatcherJob() {
        String watcherJob = DAO.getValue(WATCHER_JOB);
        return watcherJob;
    }

    public static void updateWatcherJob(String value) {
        DAO.setValue(WATCHER_JOB, value);
    }

    public static String getAutoConnect() {
        String autoConnect = DAO.getValue(AUTO_CONNECT);
        return autoConnect;
    }

    public static boolean getAutoConnectAsBool() {
        String autoConnect = DAO.getValue(AUTO_CONNECT);
        return "on".equals(autoConnect);
    }

    public static void updateAutoConnect(String value) {
        DAO.setValue(AUTO_CONNECT, value);
    }

    public static String getDailyRepeatInterval() {
        String repeatInterval = DAO.getValue(DAILY_REPEAT_INTERVAL);
        return repeatInterval;
    }

    public static void updateDailyRepeatInterval(String value) {
        DAO.setValue(DAILY_REPEAT_INTERVAL, value);
    }

    public static String getDailyStartingFrom() {
        String repeatInterval = DAO.getValue(DAILY_STARTING_FROM);
        return repeatInterval;
    }

    public static void updateDailyStartingFrom(String value) {
        DAO.setValue(DAILY_STARTING_FROM, value);
    }

    public static String getDailyCronExpression() {
        String dailyCronExpression = DAO.getValue(DAILY_CRON_EXPRESSION);
        return dailyCronExpression;
    }

    public static void updateDailyCronExpression(String value) {
        DAO.setValue(DAILY_CRON_EXPRESSION, value);
    }

    public static void updateDailyWorkingJob(String value) {
        DAO.setValue(WORKING_DAILY_JOB, value);
    }

    public static Boolean getLoggerLevel() {
        String logger = DAO.getValue(LOGGER);
        return logger != null ? Boolean.valueOf(logger) : Boolean.FALSE;
    }

    public static void updateLoggerLevel(boolean value) {
        DAO.setValue(LOGGER, String.valueOf(value));
    }

    public static Map<String, String> getValues() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("IUMGroups", DAO.getIUMGroups());
        map.put("IUMGroupsDisabled", DAO.getIUMGroupsDisabled());
        map.put("duration", DAO.getDuration());
        map.put("queueSize", DAO.getQueueSize());
        map.put("urlLogo", DAO.getUrlLogo());
        map.put("queueMessage", DAO.getQueueMessage());
        map.put(REST_ROUTE, DAO.getUrlRest());
        map.put("samlIdp", DAO.getSamlIdp());
        map.put("samlMapping", DAO.getSamlMapping());
        map.put("sideLicense", DAO.getSideLicense());
        map.put(INACTIVITY_DURATION, DAO.getInactivityDuration());
        map.put("repeatInterval", DAO.getRepeatInterval());
        map.put(STARTING_AT, DAO.getStartingAt());
        map.put(STARTING_FROM, DAO.getStartingFrom());
        map.put(WORKING_JOB, DAO.getWorkingJob());
        map.put("loggerLevel", String.valueOf(DAO.getLoggerLevel()));
        return map;
    }

    public static void cleanPluginSettings() {
        DAO.setValue(STARTING_FROM, null);
        DAO.setValue("samlIdp", null);
        DAO.setValue("samlMapping", null);
        DAO.setValue("togroup", null);
        DAO.setValue("noof", null);
        DAO.setValue(REST_ROUTE, null);
        DAO.setValue("filtergroup", null);
        DAO.setValue(REST_INIT, null);
        DAO.setValue(REPEAT_INTERVAL, null);
        DAO.setValue("userMap", null);
        DAO.setValue("inactivity", null);
        DAO.setValue("fromgroup", null);
        DAO.setValue(STARTING_AT, null);
        DAO.setValue(INACTIVITY_DURATION, null);
        DAO.setValue("urlLogo", null);
        DAO.setValue(WORKING_JOB, null);
        DAO.setValue(IUMGroup, null);
        DAO.setValue(IUMGroupDIS, null);
        DAO.setValue(LOGGER, null);
        DAO.setValue("queueSize", null);
        DAO.setValue("duration", null);
        DAO.setValue("queueMessage", null);
        DAO.setValue("sideLicense", null);
        if (accxiaCachePropertySet != null) {
            accxiaCachePropertySet.clean();
        }
    }

    public static void loadSettings(PluginSettings settings) {
        pluginSettings = settings;
        DAO.getValue("sideLicense");
        DAO.getValue(IUMGroup);
        DAO.getValue(IUMGroupDIS);
        DAO.getValue("duration");
        DAO.getValue("queueSize");
        DAO.getValue("samlIdp");
        DAO.getValue("samlMapping");
        DAO.getValue("samlRegex");
        DAO.getValue("fromGroup");
        DAO.getValue("toGroup");
        DAO.getValue(WATCHER_REPEAT_INTERVAL);
        DAO.getValue(WATCHER_GROUP_LEVEL);
        DAO.getValue(WATCHER_REMOVAL_COUNT);
        DAO.getValue(WATCHER_JOB);
        DAO.getValue(SYNC_CRON_EXPRESSION);
        DAO.getValue(DAILY_STARTING_FROM);
        DAO.getValue(DAILY_REPEAT_INTERVAL);
        DAO.getValue(DAILY_CRON_EXPRESSION);
        DAO.getValue(WORKING_DAILY_JOB);
    }
}

