/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.mailaddresshandler;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.mau.MauEventService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.mail.MailThreadManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugins.mail.MailUtility;
import com.atlassian.jira.plugins.mail.handlers.CreateIssueHandler;
import com.atlassian.jira.plugins.mail.handlers.CreateOrCommentHandler;
import com.atlassian.jira.plugins.mail.handlers.FullCommentHandler;
import com.atlassian.jira.plugins.mail.handlers.NonQuotedCommentHandler;
import com.atlassian.jira.plugins.mail.handlers.factory.MessageHandlerFactory;
import com.atlassian.jira.plugins.mail.handlers.fingerprint.DefaultFingerprintChecker;
import com.atlassian.jira.plugins.mail.handlers.fingerprint.FingerprintChecker;
import com.atlassian.jira.plugins.mail.handlers.issue.IssueFinder;
import com.atlassian.jira.plugins.mail.internal.MailLoopDetectionService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerErrorCollector;
import com.atlassian.jira.service.util.handler.MessageHandlerExecutionMonitor;
import com.atlassian.jira.service.util.handler.MessageUserProcessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMCreateOrCommentHandler
extends CreateOrCommentHandler {
    private static final Logger LOG = LoggerFactory.getLogger(IUMCreateOrCommentHandler.class);
    private final ApplicationProperties applicationProperties;
    private final ConstantsManager constantsManager;
    private final CustomFieldManager customFieldManager;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final FingerprintChecker fingerprintChecker;
    private final I18nHelper i18nHelper;
    private final I18nHelper.BeanFactory i18nHelperFactory;
    private final IssueFactory issueFactory;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final MailLoggingManager mailLoggingManager;
    private final MailLoopDetectionService mailLoopDetectionService;
    private final MailThreadManager mailThreadManager;
    private final MailUtility mailUtility;
    private final MauEventService mauEventService;
    private final MessageUserProcessor messageUserProcessor;
    private final PermissionManager permissionManager;
    private final PrioritySchemeManager prioritySchemeManager;
    private final ProjectManager projectManager;
    private final UserManager userManager;
    private final UserKeyService userKeyService;
    private final WatcherManager watcherManager;
    private final IssueFinder issueFinder;
    private final IssueCreationHelperBean issueCreationHelperBean;
    private final IssueUpdater issueUpdater;
    private MessageHandlerFactory messageHandlerFactory = null;

    @Inject
    public IUMCreateOrCommentHandler() {
        super(ComponentAccessor.getUserManager(), ComponentAccessor.getApplicationProperties(), (MailLoggingManager)ComponentAccessor.getComponent(MailLoggingManager.class), (MessageUserProcessor)ComponentAccessor.getComponent(MessageUserProcessor.class), ComponentAccessor.getPermissionManager(), ComponentAccessor.getUserKeyService(), (MauEventService)ComponentAccessor.getComponent(MauEventService.class), (MailLoopDetectionService)ComponentAccessor.getOSGiComponentInstanceOfType(MailLoopDetectionService.class), ComponentAccessor.getMailThreadManager(), ComponentAccessor.getJiraAuthenticationContext().getI18nHelper(), new MessageHandlerFactory(){

            public NonQuotedCommentHandler newNonQuotedCommentHandler() {
                return null;
            }

            public FullCommentHandler newFullCommentHandler() {
                return null;
            }

            public CreateIssueHandler newCreateIssueHandler() {
                return null;
            }
        }, DefaultFingerprintChecker.getInstance(), new IssueFinder(), new MailUtility());
        LOG.info("IUMCreateOrCommentHandler");
        this.userManager = ComponentAccessor.getUserManager();
        this.applicationProperties = ComponentAccessor.getApplicationProperties();
        this.userKeyService = ComponentAccessor.getUserKeyService();
        this.mailLoggingManager = (MailLoggingManager)ComponentAccessor.getComponent(MailLoggingManager.class);
        this.messageUserProcessor = (MessageUserProcessor)ComponentAccessor.getComponent(MessageUserProcessor.class);
        this.permissionManager = ComponentAccessor.getPermissionManager();
        this.mauEventService = (MauEventService)ComponentAccessor.getComponent(MauEventService.class);
        this.mailLoopDetectionService = (MailLoopDetectionService)ComponentAccessor.getOSGiComponentInstanceOfType(MailLoopDetectionService.class);
        this.mailThreadManager = ComponentAccessor.getMailThreadManager();
        this.i18nHelper = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
        this.fingerprintChecker = DefaultFingerprintChecker.getInstance();
        this.mailUtility = new MailUtility();
        this.issueFinder = new IssueFinder();
        this.issueFactory = ComponentAccessor.getIssueFactory();
        this.issueSecurityLevelManager = ComponentAccessor.getIssueSecurityLevelManager();
        this.i18nHelperFactory = ComponentAccessor.getI18nHelperFactory();
        this.issueUpdater = (IssueUpdater)ComponentAccessor.getComponent(IssueUpdater.class);
        this.issueCreationHelperBean = (IssueCreationHelperBean)ComponentAccessor.getComponent(IssueCreationHelperBean.class);
        this.constantsManager = ComponentAccessor.getConstantsManager();
        this.customFieldManager = ComponentAccessor.getCustomFieldManager();
        this.fieldVisibilityManager = (FieldVisibilityManager)ComponentAccessor.getComponent(FieldVisibilityManager.class);
        this.prioritySchemeManager = (PrioritySchemeManager)ComponentAccessor.getComponent(PrioritySchemeManager.class);
        this.projectManager = ComponentAccessor.getProjectManager();
        this.watcherManager = ComponentAccessor.getWatcherManager();
        this.mailLoggingManager.setIncomingMailLoggingLevel(Level.DEBUG);
    }

    public void init(Map<String, String> params, MessageHandlerErrorCollector errorCollector) {
        super.init(params, errorCollector);
        LOG.info("IUMCreateOrCommentHandler init " + params.toString());
    }

    protected boolean canHandleMessage(Message message, MessageHandlerExecutionMonitor monitor) throws MessagingException {
        boolean canHandle = super.canHandleMessage(message, monitor);
        LOG.debug("IUMCreateOrCommentHandler canHandleMessage");
        return canHandle;
    }

    public boolean handleMessage(Message message, MessageHandlerContext context) throws MessagingException {
        LOG.info("handleMessage " + message.getSubject());
        ApplicationUser reporter = this.getReporter(message, context);
        if (reporter != null && IntelligentUserManagerHelper.isUserInGroups(reporter, DAO.getIUMGroupsDisabled()) && !IntelligentUserManagerHelper.isUserInGroups(reporter, DAO.getIUMGroups())) {
            IntelligentUserManagerHelper.simulateUserToEnabledGroup(reporter);
        }
        if (this.log.isDebugEnabled()) {
            Project project = this.projectManager.getProjectObjByKey(this.projectKey.toUpperCase(Locale.getDefault()));
            this.log.debug((Object)("Project= " + project));
            this.log.debug((Object)("reporter= " + reporter));
            this.log.debug((Object)("permissionManager= " + this.permissionManager.hasPermission(ProjectPermissions.CREATE_ISSUES, project, reporter, true)));
        }
        String subject = message.getSubject();
        if (!this.canHandleMessage(message, context.getMonitor())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cannot handle message '" + subject + "'."));
            }
            return this.deleteEmail;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Looking for Issue Key in subject '" + subject + "'."));
        }
        Issue issue = this.issueFinder.findIssueObjectInString(subject).orElseGet(() -> {
            this.log.debug((Object)("Issue Key not found in subject '" + subject + "'. Inspecting the in-reply-to message ID."));
            return this.getAssociatedIssue(message);
        });
        MessageHandler delegateHandler = this.getDelegateHandler(issue, subject);
        delegateHandler.init(this.params, (MessageHandlerErrorCollector)context.getMonitor());
        boolean retVal = delegateHandler.handleMessage(message, context);
        if (this.log.isDebugEnabled()) {
            this.log.warn((Object)("Processing  message with retVal=." + retVal));
            this.log.warn((Object)("Processing  message with Subject=." + message.getSubject()));
        }
        return retVal;
    }

    private MessageHandler getDelegateHandler(@Nullable Issue issue, String subject) {
        if (issue == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("No Issue found for email '" + subject + "' - creating a new Issue."));
            }
            return this.getMessageHandlerFactory().newCreateIssueHandler();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Issue '" + issue.getKey() + "' found for email '" + subject + "'."));
        }
        return this.stripquotes != null && !"false".equalsIgnoreCase(this.stripquotes) ? this.getMessageHandlerFactory().newNonQuotedCommentHandler() : this.getMessageHandlerFactory().newFullCommentHandler();
    }

    private MessageHandlerFactory getMessageHandlerFactory() {
        if (this.messageHandlerFactory == null) {
            this.messageHandlerFactory = new MessageHandlerFactory(){

                @Nonnull
                public CreateIssueHandler newCreateIssueHandler() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("MessageHandlerFactory newCreateIssueHandler ");
                    }
                    return new CreateIssueHandler(IUMCreateOrCommentHandler.this.permissionManager, IUMCreateOrCommentHandler.this.userManager, IUMCreateOrCommentHandler.this.applicationProperties, IUMCreateOrCommentHandler.this.mailLoggingManager, IUMCreateOrCommentHandler.this.messageUserProcessor, IUMCreateOrCommentHandler.this.userKeyService, IUMCreateOrCommentHandler.this.mauEventService, IUMCreateOrCommentHandler.this.mailLoopDetectionService, IUMCreateOrCommentHandler.this.mailThreadManager, IUMCreateOrCommentHandler.this.i18nHelper, IUMCreateOrCommentHandler.this.customFieldManager, IUMCreateOrCommentHandler.this.issueCreationHelperBean, IUMCreateOrCommentHandler.this.fieldVisibilityManager, IUMCreateOrCommentHandler.this.issueFactory, IUMCreateOrCommentHandler.this.watcherManager, IUMCreateOrCommentHandler.this.projectManager, IUMCreateOrCommentHandler.this.constantsManager, IUMCreateOrCommentHandler.this.prioritySchemeManager, IUMCreateOrCommentHandler.this.issueSecurityLevelManager, IUMCreateOrCommentHandler.this.i18nHelperFactory, IUMCreateOrCommentHandler.this.fingerprintChecker, IUMCreateOrCommentHandler.this.mailUtility);
                }

                @Nonnull
                public FullCommentHandler newFullCommentHandler() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("MessageHandlerFactory newFullCommentHandler ");
                    }
                    return new FullCommentHandler(IUMCreateOrCommentHandler.this.permissionManager, IUMCreateOrCommentHandler.this.issueUpdater, IUMCreateOrCommentHandler.this.userManager, IUMCreateOrCommentHandler.this.applicationProperties, IUMCreateOrCommentHandler.this.mailLoggingManager, IUMCreateOrCommentHandler.this.messageUserProcessor, IUMCreateOrCommentHandler.this.issueCreationHelperBean, IUMCreateOrCommentHandler.this.userKeyService, IUMCreateOrCommentHandler.this.mauEventService, IUMCreateOrCommentHandler.this.mailThreadManager, IUMCreateOrCommentHandler.this.i18nHelper, IUMCreateOrCommentHandler.this.fingerprintChecker, IUMCreateOrCommentHandler.this.mailLoopDetectionService, IUMCreateOrCommentHandler.this.mailUtility);
                }

                @Nonnull
                public NonQuotedCommentHandler newNonQuotedCommentHandler() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("MessageHandlerFactory newNonQuotedCommentHandler ");
                    }
                    return new NonQuotedCommentHandler(IUMCreateOrCommentHandler.this.permissionManager, IUMCreateOrCommentHandler.this.issueUpdater, IUMCreateOrCommentHandler.this.userManager, IUMCreateOrCommentHandler.this.applicationProperties, IUMCreateOrCommentHandler.this.mailLoggingManager, IUMCreateOrCommentHandler.this.messageUserProcessor, IUMCreateOrCommentHandler.this.issueCreationHelperBean, IUMCreateOrCommentHandler.this.userKeyService, IUMCreateOrCommentHandler.this.mauEventService, IUMCreateOrCommentHandler.this.mailLoopDetectionService, IUMCreateOrCommentHandler.this.mailThreadManager, IUMCreateOrCommentHandler.this.i18nHelper, IUMCreateOrCommentHandler.this.fingerprintChecker, IUMCreateOrCommentHandler.this.mailUtility);
                }
            };
        }
        return this.messageHandlerFactory;
    }
}

