/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Pagination<T>
implements Serializable {
    List<T> data;
    int pageCount;
    int pageSize;
    int pageCurrent;

    public Pagination() {
    }

    public Pagination(List<T> data, int pageCurrent, int pageSize, int pageCount) {
        this.data = data;
        this.pageCount = pageCount;
        this.pageSize = pageSize;
        this.pageCurrent = pageCurrent;
    }

    public List<Integer> getPageNumbers() {
        int totalPages = this.pageCount;
        if (totalPages > 0) {
            int _currentPage = this.pageCurrent;
            int lpage = Math.max(1, _currentPage - 5);
            int rpage = Math.min(lpage + 10, totalPages);
            List<Integer> pageNumbers = IntStream.rangeClosed(lpage, rpage).boxed().collect(Collectors.toList());
            return pageNumbers;
        }
        return Collections.EMPTY_LIST;
    }

    public List<T> getData() {
        return this.data;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageCurrent() {
        return this.pageCurrent;
    }

    public void setPageCurrent(int pageCurrent) {
        this.pageCurrent = pageCurrent;
    }
}

