/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.config;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleAdminService;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.cluster.logging.LoggingManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.config.EffectiveCoverageLevelMock;
import de.accxia.jira.addon.IUM.config.RestRoute;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.job.JobClusterService;
import de.accxia.jira.addon.IUM.job.JobSyncService;
import de.accxia.jira.addon.IUM.job.ProcessResult;
import de.accxia.jira.addon.IUM.job.RunDetailsBean;
import de.accxia.jira.addon.IUM.listener.IUMListener;
import de.accxia.jira.addon.IUM.model.AlertType;
import de.accxia.jira.addon.IUM.model.FreeProcessingFactory;
import de.accxia.jira.addon.IUM.model.JobResultDTO;
import de.accxia.jira.addon.IUM.servlet.HelperTrialProcessing;
import de.accxia.jira.addon.IUM.servlet.ServletHelper;
import de.accxia.jira.addon.IUM.servlet.filter.XSSHttpServletRequestWrapper;
import de.accxia.jira.addon.IUM.utils.Constants;
import de.accxia.jira.addon.IUM.utils.ParseUtil;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@WebSudoRequired
@Component
public class IntelligentUserManagerConfigServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(IntelligentUserManagerConfigServlet.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final String ORIGIN = "origin";
    private static final long serialVersionUID = -5623574103725530973L;
    public static final String AUDIT_USER_MANAGEMENT = "com.atlassian.audit.plugin:audit-config:coverage:user_management";
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final LoginUriProvider loginUriProvider;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final WebSudoManager webSudoManager;
    @ComponentImport
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @ComponentImport
    private final PluginSettingsFactory pluginSettingsFactory;
    @ComponentImport
    private final ApplicationProperties applicationProperties;
    @ComponentImport
    private final ApplicationRoleAdminService applicationRoleAdminService;
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final LoggingManager loggingManager;
    @ComponentImport
    private final JiraLicenseManager jiraLicenseManager;
    private final IUMListener iumListener;
    private final HelperTrialProcessing helperTrialProcessing;
    private final JobClusterService jobClusterService;
    private final JobSyncService jobSyncService;
    private final I18nHelper i18nHelper;
    private final BuildUtilsInfo buildUtilsInfo;
    private static UserUtil userUtil = ComponentAccessor.getUserUtil();

    @Inject
    public IntelligentUserManagerConfigServlet(JobClusterService jobClusterService, JobSyncService jobSyncService, UserManager userManager, GroupManager groupManager, LoginUriProvider loginUriProvider, TemplateRenderer renderer, ApplicationRoleAdminService applicationRoleAdminService, JiraLicenseManager jiraLicenseManager, IUMListener iumListener, LoggingManager loggingManager, WebSudoManager webSudoManager, JiraAuthenticationContext jiraAuthenticationContext, PluginSettingsFactory pluginSettingsFactory, ApplicationProperties applicationProperties, HelperTrialProcessing helperTrialProcessing) {
        this.jobClusterService = jobClusterService;
        this.jobSyncService = jobSyncService;
        this.groupManager = groupManager;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.applicationRoleAdminService = applicationRoleAdminService;
        this.jiraLicenseManager = jiraLicenseManager;
        this.webSudoManager = webSudoManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.applicationProperties = applicationProperties;
        this.iumListener = iumListener;
        this.loggingManager = loggingManager;
        this.helperTrialProcessing = helperTrialProcessing;
        this.i18nHelper = (I18nHelper)ComponentAccessor.getComponent(I18nHelper.class);
        this.buildUtilsInfo = (BuildUtilsInfo)ComponentAccessor.getComponent(BuildUtilsInfo.class);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            boolean showSideLicense;
            XSSHttpServletRequestWrapper xssRequest = new XSSHttpServletRequestWrapper(request);
            if (!ServletHelper.doCheckOriginAndReferrer(this.applicationProperties.getBaseUrl(), request, response)) {
                this.forceToLogin(request, response);
                return;
            }
            UserKey userKey = this.userManager.getRemoteUserKey();
            if (userKey == null || !this.userManager.isAdmin(userKey)) {
                this.redirectToLogin((HttpServletRequest)xssRequest, response);
                return;
            }
            if (!ServletHelper.doValidateInput(request, response)) {
                this.redirectToLogin(request, response);
                return;
            }
            this.webSudoManager.willExecuteWebSudoRequest((HttpServletRequest)xssRequest);
            String pageId = xssRequest.getParameter("page");
            Page page = Page.getPage(pageId);
            if (page == Page.PageLicense) {
                try {
                    String sideLicense = request.getParameter("sideLicense");
                    if (sideLicense == null || "".equals(sideLicense)) {
                        ConditionEvaluatorImpl.deleteSideLicense();
                    }
                    DAO.updateSideLicense(sideLicense);
                    ConditionEvaluatorImpl.setSideLicense();
                    if (ConditionEvaluatorImpl.isFreeVersion()) {
                        List<ProcessResult> processResults = this.helperTrialProcessing.adjustStatus4FreeVersion(this.jiraAuthenticationContext.getLoggedInUser().getUsername());
                        int usersCount = 0;
                        int adjustSeatsCount = 0;
                        ArrayList<String> groups = new ArrayList<String>();
                        for (ProcessResult processResult : processResults) {
                            if (processResult.getUsers().size() > 0) {
                                usersCount += processResult.getUsers().size();
                                groups.add(processResult.getSourceGroups());
                            }
                            adjustSeatsCount += processResult.getAdjustSeats();
                        }
                        if (usersCount > 0) {
                            this.helperTrialProcessing.markMembershipChanges(AlertType.ALERT_JOBS_MEMBERSHIP, this.jiraAuthenticationContext.getLoggedInUser().getUsername(), true, processResults);
                        }
                        if (adjustSeatsCount > 0) {
                            this.helperTrialProcessing.markGroupSizeAdjust(AlertType.ALERT_JOBS_QUEUE, this.jiraAuthenticationContext.getLoggedInUser().getUsername(), true);
                        }
                    }
                    this.renderSideLicenseVM(response, this.i18nHelper.getText("de.accxia.apps.jira.IUM.save.license"), null);
                }
                catch (Exception e) {
                    LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                    this.renderSideLicenseVM(response, null, e.getMessage());
                }
                return;
            }
            boolean bl = showSideLicense = !"".equals(DAO.getSideLicense());
            if (!ConditionEvaluatorImpl.isLicenseValid()) {
                this.renderLicenseErrorVM(response, showSideLicense);
                return;
            }
            String action = xssRequest.getParameter("action");
            if ("remove".equals(action)) {
                String successMessage = IntelligentUserManagerHelper.disableAllUsersFromTheEnabledGroups(xssRequest.getParameter("groupName"));
                this.renderAdminVM(response, successMessage, null, Page.PageUserManagement, showSideLicense);
                return;
            }
            switch (page) {
                case PageSAMLSSO: {
                    try {
                        String samlIdp = "";
                        if (xssRequest.getParameterValues("samlIdp") != null) {
                            samlIdp = xssRequest.getParameter("samlIdp");
                        }
                        this.setValue("samlIdp", samlIdp);
                        String samlMapping = "";
                        if (xssRequest.getParameterValues("samlMapping") != null) {
                            samlMapping = xssRequest.getParameter("samlMapping");
                        }
                        this.setValue("samlMapping", samlMapping);
                        this.renderSamlVM(response, this.i18nHelper.getText("de.accxia.apps.jira.IUM.save.saml"), null);
                    }
                    catch (Exception e) {
                        LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                        this.renderSamlVM(response, null, e.getMessage());
                    }
                    return;
                }
                case PageGroupSettings: {
                    try {
                        String IUMGroupSoftware = xssRequest.getParameter("IUMGroupSoftware");
                        String IUMGroupDisableSoftware = xssRequest.getParameter("IUMGroupDisableSoftware");
                        String queueSizeSoftware = xssRequest.getParameter("queueSizeSoftware");
                        if (StringUtils.isEmpty((CharSequence)IUMGroupSoftware)) {
                            queueSizeSoftware = "";
                            IUMGroupDisableSoftware = "";
                        }
                        String IUMGroupServiceDesk = xssRequest.getParameter("IUMGroupServiceDesk");
                        String IUMGroupDisableServiceDesk = xssRequest.getParameter("IUMGroupDisableServiceDesk");
                        String queueSizeServiceDesk = xssRequest.getParameter("queueSizeServiceDesk");
                        if (StringUtils.isEmpty((CharSequence)IUMGroupServiceDesk)) {
                            queueSizeServiceDesk = "";
                            IUMGroupDisableServiceDesk = "";
                        }
                        String IUMGroupCore = xssRequest.getParameter("IUMGroupCore");
                        String IUMGroupDisableCore = xssRequest.getParameter("IUMGroupDisableCore");
                        String queueSizeCore = xssRequest.getParameter("queueSizeCore");
                        if (StringUtils.isEmpty((CharSequence)IUMGroupCore)) {
                            queueSizeCore = "";
                            IUMGroupDisableCore = "";
                        }
                        String IUMGroup2 = (IUMGroupSoftware != null ? IUMGroupSoftware : "") + "," + (IUMGroupServiceDesk != null ? IUMGroupServiceDesk : "") + "," + (IUMGroupCore != null ? IUMGroupCore : "");
                        String IUMGroupDIS = (IUMGroupDisableSoftware != null ? IUMGroupDisableSoftware : "") + "," + (IUMGroupDisableServiceDesk != null ? IUMGroupDisableServiceDesk : "") + "," + (IUMGroupDisableCore != null ? IUMGroupDisableCore : "");
                        Object queueSize = (queueSizeSoftware != null ? queueSizeSoftware : "") + "," + (queueSizeServiceDesk != null ? queueSizeServiceDesk : "") + "," + (queueSizeCore != null ? queueSizeCore : "");
                        if (FreeProcessingFactory.createFreeProcessing().isFree()) {
                            queueSize = this.reducedQueueSize(queueSizeSoftware, queueSizeServiceDesk, queueSizeCore);
                        }
                        this.setValue("IUMGroup", IUMGroup2);
                        this.setValue("IUMGroupDIS", IUMGroupDIS);
                        this.setValue("queueSize", (String)queueSize);
                        this.patchGroupsForSyncJob(IUMGroupDIS);
                        String duration = xssRequest.getParameter("duration");
                        this.setValue("duration", duration);
                        String inactivityDuration = request.getParameter("inactivityDuration");
                        DAO.updateInactivityDuration(inactivityDuration);
                        this.renderAdminVM(response, this.i18nHelper.getText("de.accxia.apps.jira.IUM.save.group"), null, page, showSideLicense);
                    }
                    catch (Exception e) {
                        LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                        this.renderAdminVM(response, null, e.getMessage(), page, showSideLicense);
                    }
                    return;
                }
                case PageRest: {
                    try {
                        String urlRest = xssRequest.getParameter("urlRest");
                        this.setValue("urlRest", urlRest);
                        RestRoute.getInstance().updateRestRoute(urlRest);
                        this.renderAdminVM(response, this.i18nHelper.getText("de.accxia.apps.jira.IUM.save.rest"), null, page, showSideLicense);
                    }
                    catch (Exception e) {
                        LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                        this.renderAdminVM(response, null, e.getMessage(), page, showSideLicense);
                    }
                    return;
                }
                case PageJob: {
                    try {
                        String workingJob;
                        String removalCronExpression;
                        boolean shouldRestart = false;
                        String autoConnect = request.getParameter("autoConnect");
                        if (autoConnect == null || "off".equalsIgnoreCase(autoConnect)) {
                            DAO.updateAutoConnect("off");
                        } else {
                            DAO.updateAutoConnect("on");
                        }
                        String removalInactivityDuration = xssRequest.getParameter("removalInactivityDuration");
                        if (removalInactivityDuration != null && removalInactivityDuration != null && !removalInactivityDuration.equalsIgnoreCase(DAO.getRemovalInactivityDuration())) {
                            try {
                                Long.parseLong(removalInactivityDuration);
                                DAO.updateRemovalInactivityDuration(removalInactivityDuration);
                            }
                            catch (Exception e) {
                                removalInactivityDuration = null;
                                LOG.error("Exception " + e.getMessage(), (Throwable)e);
                            }
                            shouldRestart = true;
                        }
                        if ((removalCronExpression = request.getParameter("removalCronExpression")) != null && !removalCronExpression.equalsIgnoreCase(DAO.getRemovalCronExpression())) {
                            try {
                                DAO.updateRemovalCronExpression(removalCronExpression);
                            }
                            catch (Exception e) {
                                removalCronExpression = null;
                                LOG.error("Exception " + e.getMessage(), (Throwable)e);
                            }
                            shouldRestart = true;
                        }
                        if ((workingJob = xssRequest.getParameter("workingJob")) != null && "on".equalsIgnoreCase(workingJob)) {
                            DAO.updateWorkingJob(workingJob);
                            if (shouldRestart || !this.jobClusterService.isWorking()) {
                                LOG.warn("Start JobClusterService " + new Date());
                                this.jobClusterService.start();
                                this.iumListener.publishJobNotification(true);
                            }
                        } else if (workingJob == null || "off".equalsIgnoreCase(workingJob)) {
                            DAO.updateWorkingJob("off");
                            if (this.jobClusterService.isWorking()) {
                                LOG.warn("Stop JobClusterService " + new Date());
                                this.jobClusterService.stop();
                                this.iumListener.publishJobNotification(false);
                            }
                        }
                        this.renderAdminVM(response, this.i18nHelper.getText("de.accxia.apps.jira.IUM.save.job"), null, page, showSideLicense);
                    }
                    catch (Exception e) {
                        LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                        this.renderAdminVM(response, null, e.getMessage(), page, showSideLicense);
                    }
                    return;
                }
                case PageSync: {
                    try {
                        String workingJob;
                        String syncCronExpression;
                        String syncSoftwareSrcGroup = xssRequest.getParameter("syncSoftwareSrcGroup-groups");
                        String syncSoftwareTargetGroup = xssRequest.getParameter("syncSoftwareTargetGroup-groups");
                        String syncSDeskSrcGroup = xssRequest.getParameter("syncSDeskSrcGroup-groups");
                        String syncSDeskTargetGroup = xssRequest.getParameter("syncSDeskTargetGroup-groups");
                        if (syncSoftwareSrcGroup != null) {
                            syncSoftwareSrcGroup = syncSoftwareSrcGroup.replaceAll(",", ";");
                        }
                        if (syncSDeskSrcGroup != null) {
                            syncSDeskSrcGroup = syncSDeskSrcGroup.replaceAll(",", ";");
                        }
                        boolean shouldRestart = false;
                        if (!DAO.getSyncSoftwareSrcGoups().equals(syncSoftwareSrcGroup)) {
                            DAO.updateSyncSoftwareSrcGoups(syncSoftwareSrcGroup);
                            shouldRestart = true;
                        }
                        if (!DAO.getSyncSoftwareTargetGoups().equals(syncSoftwareTargetGroup)) {
                            DAO.updateSyncSoftwareTargetGoups(syncSoftwareTargetGroup);
                            shouldRestart = true;
                        }
                        if (!DAO.getSyncSDeskSrcGoups().equals(syncSDeskSrcGroup)) {
                            DAO.updateSyncSDeskSrcGoups(syncSDeskSrcGroup);
                            shouldRestart = true;
                        }
                        if (!DAO.getSyncSDeskTargetGoups().equals(syncSDeskTargetGroup)) {
                            DAO.updateSyncSDeskTargetGoups(syncSDeskTargetGroup);
                            shouldRestart = true;
                        }
                        if ((syncCronExpression = request.getParameter("syncCronExpression")) != null && !syncCronExpression.equalsIgnoreCase(DAO.getSyncCronExpression())) {
                            try {
                                DAO.updateSyncCronExpression(syncCronExpression);
                            }
                            catch (Exception e) {
                                syncCronExpression = null;
                                LOG.error("Exception " + e.getMessage(), (Throwable)e);
                            }
                            shouldRestart = true;
                        }
                        if ((workingJob = xssRequest.getParameter("workingSyncJob")) != null && "on".equalsIgnoreCase(workingJob)) {
                            DAO.updateSyncWorkingJob(workingJob);
                            if (shouldRestart || !this.jobSyncService.isWorking()) {
                                LOG.warn("Start JobClusterService " + new Date());
                                this.jobSyncService.start();
                                this.iumListener.publishSyncJobNotification(true);
                            }
                        } else if (workingJob == null || "off".equalsIgnoreCase(workingJob)) {
                            DAO.updateSyncWorkingJob("off");
                            if (this.jobSyncService.isWorking()) {
                                LOG.warn("Stop JobClusterService " + new Date());
                                this.jobSyncService.stop();
                                this.iumListener.publishSyncJobNotification(false);
                            }
                        }
                        this.renderAdminVM(response, this.i18nHelper.getText("de.accxia.apps.jira.IUM.save.sync"), null, page, showSideLicense);
                    }
                    catch (Exception e) {
                        LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                        this.renderAdminVM(response, null, e.getMessage(), page, showSideLicense);
                    }
                    return;
                }
                case PageDesign: {
                    try {
                        String urlLogo = xssRequest.getParameter("urlLogo");
                        DAO.updateUrlLogo(urlLogo);
                        String heightLogo = xssRequest.getParameter("heightLogo");
                        DAO.updateHeightLogo(heightLogo);
                        String queueMessage = xssRequest.getParameter("queueMessage");
                        if (StringUtils.isEmpty((CharSequence)queueMessage)) {
                            queueMessage = this.i18nHelper.getText("IUM-queueMessage.default");
                        }
                        DAO.updateQueueMessage(queueMessage);
                        String tempDisconnect = request.getParameter("tempDisconnect");
                        if (StringUtils.isEmpty((CharSequence)tempDisconnect)) {
                            tempDisconnect = this.i18nHelper.getText("IUM-temp-disconnect.default");
                        }
                        DAO.updateTempDisconnectMessage(tempDisconnect);
                        this.renderAdminVM(response, this.i18nHelper.getText("de.accxia.apps.jira.IUM.save.design"), null, page, showSideLicense);
                    }
                    catch (Exception e) {
                        LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                        this.renderAdminVM(response, null, e.getMessage(), page, showSideLicense);
                    }
                    return;
                }
                case PageLogging: {
                    try {
                        String logger;
                        if (this.isJira8x()) {
                            String audit = xssRequest.getParameter("audit");
                            if (audit != null && "on".equalsIgnoreCase(audit)) {
                                this.setAuditUserManagement(EffectiveCoverageLevelMock.BASE());
                            } else {
                                this.setAuditUserManagement(EffectiveCoverageLevelMock.OFF());
                            }
                        }
                        if ((logger = xssRequest.getParameter("logger")) != null && "on".equalsIgnoreCase(logger)) {
                            this.setDebugLogger(true);
                        } else {
                            this.setDebugLogger(false);
                        }
                        this.renderAdminVM(response, this.i18nHelper.getText("de.accxia.apps.jira.IUM.save.logging"), null, page, showSideLicense);
                    }
                    catch (Exception e) {
                        LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                        this.renderAdminVM(response, null, e.getMessage(), page, showSideLicense);
                    }
                    return;
                }
            }
            this.renderAdminVM(response, null, null, page, showSideLicense);
        }
        catch (WebSudoSessionException wes) {
            LOG.error("Exception:" + wes.getMessage(), (Throwable)wes);
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    private String reducedQueueSize(String queueSizeSoftware, String queueSizeServiceDesk, String queueSizeCore) {
        int qSoftware = ParseUtil.safeParseInt(queueSizeSoftware);
        int qServiceDesk = ParseUtil.safeParseInt(queueSizeServiceDesk);
        int qJiraCode = ParseUtil.safeParseInt(queueSizeCore);
        boolean adjust = false;
        if (qSoftware > 5) {
            qSoftware = 5;
            adjust = true;
        }
        if (qServiceDesk > 5) {
            qServiceDesk = 5;
            adjust = true;
        }
        if (qJiraCode > 5) {
            qJiraCode = 5;
            adjust = true;
        }
        if (adjust) {
            this.helperTrialProcessing.markGroupQueueSizeAdjust(AlertType.ALERT_JOBS_QUEUE, this.jiraAuthenticationContext.getLoggedInUser().getUsername());
        }
        String queueSize = (qSoftware > 0 ? String.valueOf(qSoftware) : "0") + "," + (qServiceDesk > 0 ? String.valueOf(qServiceDesk) : "0") + "," + (qJiraCode > 0 ? String.valueOf(qJiraCode) : "0");
        return queueSize;
    }

    private void patchGroupsForSyncJob(String iumDisableGroups) {
        if (iumDisableGroups == null || iumDisableGroups.length() == 1) {
            return;
        }
        boolean shouldRestart = false;
        String[] disableGroups = iumDisableGroups.split(",");
        if (!this.containsNonEmptyGroup(disableGroups, DAO.getSyncSoftwareTargetGoups())) {
            DAO.updateSyncSoftwareTargetGoups("");
            shouldRestart = true;
        }
        if (!this.containsNonEmptyGroup(disableGroups, DAO.getSyncSDeskTargetGoups())) {
            DAO.updateSyncSDeskTargetGoups("");
            shouldRestart = true;
        }
        if (shouldRestart && this.jobSyncService.isWorking()) {
            this.jobSyncService.start();
        }
    }

    private boolean containsNonEmptyGroup(String[] arrays, String value) {
        if (value == null || value.length() == 0) {
            return true;
        }
        for (int i = 0; i < arrays.length; ++i) {
            if (!value.equalsIgnoreCase(arrays[i])) continue;
            return true;
        }
        return false;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            boolean showSideLicense;
            XSSHttpServletRequestWrapper xssRequest = new XSSHttpServletRequestWrapper(request);
            UserKey userKey = this.userManager.getRemoteUserKey();
            if (userKey == null || !this.userManager.isAdmin(userKey)) {
                this.redirectToLogin((HttpServletRequest)xssRequest, response);
                return;
            }
            this.webSudoManager.willExecuteWebSudoRequest((HttpServletRequest)xssRequest);
            String pageId = xssRequest.getParameter("page");
            Page page = Page.getPage(pageId);
            if (page == Page.PageLicense) {
                this.renderSideLicenseVM(response);
                return;
            }
            boolean bl = showSideLicense = !"".equals(DAO.getSideLicense());
            if (!ConditionEvaluatorImpl.isLicenseValid()) {
                this.renderLicenseErrorVM(response, showSideLicense);
                return;
            }
            switch (page) {
                case PageGroupSettings: 
                case PageRest: 
                case PageDesign: 
                case PageLicense: {
                    this.renderAdminVM(response, page, showSideLicense);
                    return;
                }
                case PageSAMLSSO: {
                    this.renderSamlVM(response);
                    return;
                }
                case PagePreview: {
                    this.renderPreviewVM(response, null, null);
                    return;
                }
            }
            this.renderAdminVM(response, page, showSideLicense);
        }
        catch (WebSudoSessionException wes) {
            LOG.error("Exception:" + wes.getMessage(), (Throwable)wes);
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    private void renderLicenseErrorVM(HttpServletResponse response, boolean showSideLicense) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("showSideLicense", showSideLicense);
        context.put("baseurl", this.applicationProperties.getBaseUrl());
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/checklicense_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderAdminVM(HttpServletResponse response, Page page, boolean showSideLicense) throws IOException {
        this.renderAdminVM(response, null, null, page, showSideLicense);
    }

    private void renderAdminVM(HttpServletResponse response, String successMessage, String errorMessages, Page page, boolean showSideLicense) throws IOException {
        int softwareSeats;
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("successMessage", successMessage);
        context.put("showSideLicense", showSideLicense);
        String[] iumGroup = DAO.getIUMGroups() != null ? DAO.getIUMGroups().split(",") : new String[]{};
        int softwareLicenseCount = this.helperTrialProcessing.getSeats(ApplicationKeys.SOFTWARE);
        int serviceLicenseCount = this.helperTrialProcessing.getSeats(ApplicationKeys.SERVICE_DESK);
        int n = softwareLicenseCount == 0 ? 0 : (softwareSeats = this.helperTrialProcessing.getUsersWithGenericAccessExceptGroup(ApplicationKeys.SOFTWARE, iumGroup.length > 1 ? iumGroup[0] : "").size());
        int serviceDeskSeats = serviceLicenseCount == 0 ? 0 : this.helperTrialProcessing.getUsersWithGenericAccessExceptGroup(ApplicationKeys.SERVICE_DESK, iumGroup.length > 2 ? iumGroup[1] : "").size();
        boolean isTrial = ConditionEvaluatorImpl.isFreeVersion();
        context.put("softwareSeats", softwareLicenseCount == 0 ? 0 : softwareLicenseCount - softwareSeats - (isTrial ? 1 : 3));
        context.put("serviceDeskSeats", serviceLicenseCount == 0 ? 0 : serviceLicenseCount - serviceDeskSeats - (isTrial ? 1 : 3));
        if (page == Page.PageGroupSettings) {
            this.addGroupSettings(context, isTrial);
        }
        context.put("testing", Constants.TESTING);
        context.put("isTrial", isTrial);
        if (ConditionEvaluatorImpl.getSideLicense() != null) {
            context.put("enhanced", ConditionEvaluatorImpl.getSideLicense().getAppKey().contains("Enhanced"));
        }
        context.put("isJira8", this.isJira8x());
        if (this.isJira8x()) {
            context.put("audit", EffectiveCoverageLevelMock.OFF().equalsIgnoreCase(this.getAuditUserManagement()) ? Boolean.FALSE : Boolean.TRUE);
        }
        if (page == Page.PageDesign) {
            String urlLogo = DAO.getValue("urlLogo");
            String heightLogo = DAO.getValue("heightLogo");
            String queueMessage = DAO.getValue("queueMessage");
            String tempDisconnect = DAO.getValue("tempDisconnect");
            context.put("urlLogo", urlLogo.isEmpty() ? "" : urlLogo);
            context.put("heightLogo", heightLogo.isEmpty() ? "300" : heightLogo);
            if (StringUtils.isEmpty((CharSequence)queueMessage)) {
                queueMessage = this.i18nHelper.getText("IUM-queueMessage.default");
                DAO.updateQueueMessage(queueMessage);
            }
            context.put("queueMessage", queueMessage);
            if (StringUtils.isEmpty((CharSequence)tempDisconnect)) {
                tempDisconnect = this.i18nHelper.getText("IUM-temp-disconnect.default");
                DAO.updateQueueMessage(tempDisconnect);
            }
            context.put("tempDisconnect", tempDisconnect);
        }
        if (page == Page.PageRest) {
            String urlRest = DAO.getValue("urlRest");
            if (!StringUtils.isEmpty((CharSequence)urlRest)) {
                urlRest = RestRoute.removeDefaultRoute(urlRest);
            }
            context.put("urlRest", StringUtils.isEmpty((CharSequence)urlRest) ? "" : urlRest);
        }
        if (page == Page.PageJob) {
            context.put("repeatInterval", DAO.getRepeatInterval());
            context.put("removalInactivityDuration", DAO.getRemovalInactivityDuration());
            context.put("removalCronExpression", DAO.getRemovalCronExpression());
            context.put("startingFrom", DAO.getStartingFrom());
            context.put("autoConnect", DAO.getAutoConnectAsBool());
            context.put("serverTime", SDF.format(new Date()));
            context.put("cronRemoval", true);
            context.put("workingJob", this.jobClusterService.isWorking());
            if (this.jobClusterService.getNextRunDate() != null) {
                context.put("nextRunDate", SDF.format(this.jobClusterService.getNextRunDate()));
            }
            if (this.jobClusterService.getLastSuccessfulRunForJob() != null) {
                context.put("runDetails", new RunDetailsBean(this.jobClusterService.getLastSuccessfulRunForJob()));
            }
            this.addLatestJobClusterResults(context);
        }
        if (page == Page.PageSync) {
            context.put("syncRepeatInterval", DAO.getSyncRepeatInterval());
            context.put("syncStartingFrom", DAO.getSyncStartingFrom());
            context.put("syncCronExpression", DAO.getSyncCronExpression());
            context.put("serverTime", SDF.format(new Date()));
            context.put("maxRules", DAO.getIUMGroups() != null ? DAO.getIUMGroups().split(",").length : 1);
            context.put("cronSync", true);
            context.put("workingSyncJob", this.jobSyncService.isWorking());
            if (this.jobSyncService.getNextRunDate() != null) {
                context.put("nextRunDate", SDF.format(this.jobSyncService.getNextRunDate()));
            }
            if (this.jobSyncService.getLastSuccessfulRunForJob() != null) {
                context.put("runDetails", new RunDetailsBean(this.jobSyncService.getLastSuccessfulRunForJob()));
                context.put("lastSuccessfulRunDate", SDF.format(this.jobSyncService.getLastSuccessfulRunForJob().getStartTime()));
            }
            this.addSyncGroups(context);
            this.addLatestSyncResults(context);
        }
        if (page == Page.PageLogging) {
            context.put("logger", IntelligentUserManagerConfigServlet.getDebugLogger());
        }
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/" + page.pageName, context, (Writer)response.getWriter());
    }

    @WebSudoRequired
    private void addGroupSettings(Map<String, Object> context, boolean isTrial) {
        String wvg = DAO.getIUMGroups();
        String[] iumGroups = StringUtils.isEmpty((CharSequence)wvg) ? new String[]{} : wvg.split(",", -1);
        wvg = DAO.getIUMGroupsDisabled();
        String[] iumGroupDISs = StringUtils.isEmpty((CharSequence)wvg) ? new String[]{} : wvg.split(",", -1);
        wvg = DAO.getValue("queueSize");
        String[] queueSizes = StringUtils.isEmpty((CharSequence)wvg) ? new String[]{} : wvg.split(",", -1);
        String duration = DAO.getValue("duration");
        context.put("duration", StringUtils.isEmpty((CharSequence)duration) ? "24" : duration);
        context.put("inactivityDuration", DAO.getInactivityDuration());
        ServiceOutcome applicationRoleOutcome = null;
        try {
            applicationRoleOutcome = this.applicationRoleAdminService.getRole(ApplicationKeys.SOFTWARE);
            if (applicationRoleOutcome.isValid()) {
                context.put("hasSoftware", Boolean.TRUE);
                context.put("groupsSoftware", IntelligentUserManagerConfigServlet.convertGroupToListOfString(((ApplicationRole)applicationRoleOutcome.get()).getGroups()));
                if (isTrial) {
                    context.put("groupsSoftwareSeats", 5);
                } else {
                    context.put("groupsSoftwareSeats", ((ApplicationRole)applicationRoleOutcome.get()).getNumberOfSeats() == -1 ? Constants.SOFTWARE_SEATS.intValue() : ((ApplicationRole)applicationRoleOutcome.get()).getNumberOfSeats());
                }
                context.put("IUMGroupSoftware", iumGroups.length > 0 ? iumGroups[0] : "");
                context.put("IUMGroupDisableSoftware", iumGroupDISs.length > 0 ? iumGroupDISs[0] : "");
                context.put("queueSizeSoftware", queueSizes.length > 0 ? queueSizes[0] : "");
            }
            if ((applicationRoleOutcome = this.applicationRoleAdminService.getRole(ApplicationKeys.SERVICE_DESK)).isValid()) {
                context.put("hasServiceDesk", Boolean.TRUE);
                context.put("groupsServiceDesk", IntelligentUserManagerConfigServlet.convertGroupToListOfString(((ApplicationRole)applicationRoleOutcome.get()).getGroups()));
                if (isTrial) {
                    context.put("groupsServiceDeskSeats", 5);
                } else {
                    context.put("groupsServiceDeskSeats", ((ApplicationRole)applicationRoleOutcome.get()).getNumberOfSeats() == -1 ? Constants.SERVICE_SEATS.intValue() : ((ApplicationRole)applicationRoleOutcome.get()).getNumberOfSeats());
                }
                context.put("IUMGroupServiceDesk", iumGroups.length > 1 ? iumGroups[1] : "");
                context.put("IUMGroupDisableServiceDesk", iumGroupDISs.length > 1 ? iumGroupDISs[1] : "");
                context.put("queueSizeServiceDesk", queueSizes.length > 1 ? queueSizes[1] : "");
            }
            if ((applicationRoleOutcome = this.applicationRoleAdminService.getRole(ApplicationKeys.CORE)).isValid()) {
                context.put("hasCore", Boolean.TRUE);
                context.put("groupsCore", IntelligentUserManagerConfigServlet.convertGroupToListOfString(((ApplicationRole)applicationRoleOutcome.get()).getGroups()));
                if (isTrial) {
                    context.put("groupsCoreSeats", 5);
                } else {
                    context.put("groupsCoreSeats", ((ApplicationRole)applicationRoleOutcome.get()).getNumberOfSeats());
                }
                context.put("IUMGroupCore", iumGroups.length > 2 ? iumGroups[2] : "");
                context.put("IUMGroupDisableCore", iumGroupDISs.length > 2 ? iumGroupDISs[2] : "");
                context.put("queueSizeCore", queueSizes.length > 2 ? queueSizes[2] : "");
            }
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    @WebSudoRequired
    private void addSyncGroups(Map<String, Object> context) {
        try {
            String[] iumGroupDISs;
            ServiceOutcome applicationSoftwareRoleOutcome = this.applicationRoleAdminService.getRole(ApplicationKeys.SOFTWARE);
            ServiceOutcome applicationSDeskRoleOutcome = this.applicationRoleAdminService.getRole(ApplicationKeys.SERVICE_DESK);
            String wvg = DAO.getIUMGroupsDisabled();
            String[] stringArray = iumGroupDISs = StringUtils.isEmpty((CharSequence)wvg) ? new String[]{} : wvg.split(",", -1);
            if (applicationSoftwareRoleOutcome.isValid()) {
                context.put("hasSoftware", Boolean.TRUE);
                String syncSoftwareSrcGroups = DAO.getSyncSoftwareSrcGoups();
                String syncSoftwareTargetGroups = DAO.getSyncSoftwareTargetGoups();
                context.put("syncSoftwareSrcGroup", syncSoftwareSrcGroups != null ? syncSoftwareSrcGroups.replaceAll(";", ",") : "");
                context.put("syncSoftwareTargetGroup", syncSoftwareTargetGroups);
                context.put("validSyncTargetSoftwareGroups", iumGroupDISs.length > 0 ? iumGroupDISs[0] : "");
            } else {
                context.put("hasSoftware", Boolean.FALSE);
            }
            if (applicationSDeskRoleOutcome.isValid()) {
                context.put("hasServiceDesk", Boolean.TRUE);
                String syncSDeskSrcGoups = DAO.getSyncSDeskSrcGoups();
                String syncSDeskTargetGoups = DAO.getSyncSDeskTargetGoups();
                context.put("syncSDeskSrcGroup", syncSDeskSrcGoups != null ? syncSDeskSrcGoups.replaceAll(";", ",") : "");
                context.put("syncSDeskTargetGroup", syncSDeskTargetGoups);
                context.put("validSyncTargetSDeskGroups", iumGroupDISs.length > 1 ? iumGroupDISs[1] : "");
            } else {
                context.put("hasServiceDesk", Boolean.FALSE);
            }
            context.put("hasCore", Boolean.FALSE);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    private void addLatestJobClusterResults(Map<String, Object> context) {
        List<JobResultDTO> jobResultDTOList = this.jobClusterService.findLatest(0, 10);
        this.customProcessJobResult(jobResultDTOList);
        context.put("jobResults", jobResultDTOList);
    }

    private void addLatestSyncResults(Map<String, Object> context) {
        List<JobResultDTO> jobResultDTOList = this.jobSyncService.findLatest(0, 10);
        this.customProcessJobResult(jobResultDTOList);
        context.put("jobResults", jobResultDTOList);
    }

    private void customProcessJobResult(List<JobResultDTO> jobResultDTOList) {
        for (JobResultDTO jobResult : jobResultDTOList) {
            if (jobResult.getSourceGroups() != null) {
                String[] tmpSourceGroups = jobResult.getSourceGroups().split(";");
                jobResult.setShortSourceGroups(tmpSourceGroups.length > 0 ? tmpSourceGroups[0] : "");
                jobResult.setSourceGroups(jobResult.getSourceGroups().replaceAll(";", ", "));
            }
            if (jobResult.getTargetGroup() == null) continue;
            String[] tmpTargetGroup = jobResult.getTargetGroup().split(";");
            jobResult.setShortTargetGroup(tmpTargetGroup.length > 0 ? tmpTargetGroup[0] : "");
            jobResult.setTargetGroup(jobResult.getTargetGroup().replaceAll(";", ", "));
        }
    }

    private static List<String> convertGroupToListOfString(Set<Group> groups) {
        if (groups == null) {
            return Collections.EMPTY_LIST;
        }
        List<String> retVal = groups.stream().map(Group::getName).collect(Collectors.toList());
        retVal.add(0, "");
        return retVal;
    }

    private static String convertGroupToString(Set<Group> groups) {
        if (groups == null) {
            return "";
        }
        String retVal = groups.stream().map(Group::getName).collect(Collectors.joining(","));
        return retVal;
    }

    private void renderSamlVM(HttpServletResponse response) throws IOException {
        this.renderSamlVM(response, null, null);
    }

    private void renderSamlVM(HttpServletResponse response, String successMessage, String errorMessages) throws IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("samlIdp", DAO.getSamlIdp());
        context.put("samlMapping", DAO.getSamlMapping());
        context.put("successMessage", successMessage);
        context.put("errorMessages", errorMessages);
        this.renderer.render("templates/SAML_IUM.vm", context, (Writer)response.getWriter());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private void forceToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        URI origin = this.getUri(request);
        request.getSession().invalidate();
        response.sendRedirect(this.loginUriProvider.getLoginUri(origin).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void renderSideLicenseVM(HttpServletResponse response) throws IOException {
        this.renderSideLicenseVM(response, null, null);
    }

    private void renderSideLicenseVM(HttpServletResponse response, String successMessage, String errorMessages) throws IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("sideLicense", this.getSideLicense());
        context.put("successMessage", successMessage);
        context.put("errorMessages", errorMessages);
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/sidelicense_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderPreviewVM(HttpServletResponse response, String successMessage, String errorMessages) throws IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        String baseurl = this.applicationProperties.getBaseUrl();
        context.put("baseurl", baseurl);
        context.put(ORIGIN, "");
        context.put("fake", "true");
        context.put("urlLogo", DAO.getUrlLogo());
        context.put("heightLogo", DAO.getHeightLogo());
        context.put("duration", DAO.getDuration());
        context.put("inactivityDuration", DAO.getInactivityDuration());
        context.put("removalInactivityDuration", DAO.getRemovalInactivityDuration());
        context.put("redirUrl", DAO.getSamlIdp());
        context.put("queueMessage", DAO.getQueueMessage());
        context.put("tempDisconnect", DAO.getTempDisconnectMessage());
        context.put("urlRest", DAO.getUrlRest());
        context.put("successMessage", successMessage);
        context.put("errorMessages", errorMessages);
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }

    public String setValue(String key, String value) {
        if (value == null) {
            value = "";
        }
        DAO.setValue(key, value);
        return value;
    }

    private static int safeParseInt(String value, int defValue) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            return defValue;
        }
    }

    private boolean isEmpty(String contextPath) {
        return contextPath == null || contextPath.isEmpty();
    }

    public String getSideLicense() {
        String sideLicense = DAO.getSideLicense();
        if (LOG.isDebugEnabled()) {
            LOG.debug("sideLicense= " + sideLicense);
        }
        return sideLicense;
    }

    public void setSideLicense(String sideLicense) {
        DAO.updateSideLicense(sideLicense);
    }

    public void deleteSideLicense() {
        DAO.updateSideLicense(null);
    }

    private String getAuditUserManagement() {
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        return (String)settings.get(AUDIT_USER_MANAGEMENT);
    }

    private void setAuditUserManagement(String key) {
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        settings.put(AUDIT_USER_MANAGEMENT, (Object)key);
    }

    private void setDebugLogger(boolean b) {
        DAO.updateLoggerLevel(b);
        this.loggingManager.setLogLevel("de.accxia.jira.addon.IUM", b ? "DEBUG" : "INFO");
    }

    private static boolean getDebugLogger() {
        org.apache.log4j.Logger logger = IntelligentUserManagerConfigServlet.getLogger("de.accxia.jira.addon.IUM");
        if (LOG.isWarnEnabled()) {
            LOG.warn("IntelligentUserManagerConfigServlet=" + (logger != null && logger.getLevel() != null ? logger.getLevel().toString() : "NULL"));
        }
        if (logger == null || logger.getLevel() == null) {
            return false;
        }
        return logger.getLevel() == Level.DEBUG;
    }

    private static org.apache.log4j.Logger getLogger(String loggerName) {
        return "root".equals(loggerName) ? org.apache.log4j.Logger.getRootLogger() : org.apache.log4j.Logger.getLogger((String)loggerName);
    }

    private boolean isJira8x() {
        int[] versions = this.buildUtilsInfo.getVersionNumbers();
        return versions != null && versions.length > 0 && versions[0] > 7;
    }

    private int computeQueueSize(String queueSize) {
        int retVal = 0;
        if (StringUtils.isEmpty((CharSequence)queueSize)) {
            return retVal;
        }
        return Arrays.stream(queueSize.split(",")).map(Integer::parseInt).reduce(retVal, Integer::sum);
    }

    static enum Page {
        None("", "empty.vm"),
        PageGroupSettings("group", "admin_group_IUM.vm"),
        PageDesign("design", "admin_design_IUM.vm"),
        PagePreview("preview", "admin_preview_IUM.vm"),
        PageRest("rest", "admin_rest_IUM.vm"),
        PageLogging("logging", "admin_logging_IUM.vm"),
        PageUserManagement("user", "user_IUM.vm"),
        PageJob("job", "admin_job_IUM.vm"),
        PageSync("sync", "admin_sync_IUM.vm"),
        PageLicense("sl", "sidelicense_IUM.vm"),
        PageSAMLSSO("saml", "SAML_IUM.vm");

        String pageId;
        String pageName;

        private Page(String pageId, String pageName) {
            this.pageId = pageId;
            this.pageName = pageName;
        }

        public static Page getPage(String pageId) {
            if (pageId == null) {
                return PageGroupSettings;
            }
            for (Page p : Page.values()) {
                if (!p.pageId.equals(pageId)) continue;
                return p;
            }
            return None;
        }
    }
}

