/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.CurrentUser;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.saml.SAMLHelper;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SAMLServlet
extends HttpServlet {
    private static final long serialVersionUID = -1585035763724104775L;
    private static final Logger log = LoggerFactory.getLogger(SAMLServlet.class);
    @ComponentImport
    private final com.atlassian.sal.api.user.UserManager userManager;
    @ComponentImport
    private final LoginUriProvider loginUriProvider;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private ApplicationProperties applicationProperties;
    private static UserManager userManagerJira = ComponentAccessor.getUserManager();
    @ComponentImport
    private final PluginController pluginController;

    @Inject
    public SAMLServlet(PluginController pluginController, com.atlassian.sal.api.user.UserManager userManager, LoginUriProvider loginUriProvider, TemplateRenderer renderer, PluginLicenseManager pluginLicenseManager, ApplicationProperties applicationProperties) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.pluginLicenseManager = pluginLicenseManager;
        this.pluginController = pluginController;
        this.applicationProperties = applicationProperties;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = request;
        String samlPar = req.getParameter("SAMLResponse");
        String user = SAMLHelper.getSAMLUserFromSAMLResponse(samlPar);
        if (user == null) {
            response.sendRedirect(DAO.getSamlIdp());
            return;
        }
        ApplicationUser applicationUser = userManagerJira.getUserByName(user);
        if ("".equals(DAO.getSamlIdp())) {
            response.sendRedirect("/");
            return;
        }
        if (IntelligentUserManagerHelper.isUserInGroups(applicationUser, DAO.getIUMGroups())) {
            response.sendRedirect(DAO.getSamlIdp());
            return;
        }
        if (!IntelligentUserManagerHelper.isUserInGroups(applicationUser, DAO.getIUMGroupsDisabled())) {
            response.sendRedirect(DAO.getSamlIdp());
            return;
        }
        CurrentUser currentUser = IntelligentUserManagerHelper.enableUserFromGroup(user, req);
        if (currentUser != null) {
            ApplicationUser theUser = currentUser.user;
            if (theUser != null) {
                request.getSession().setAttribute("IUMUSER", (Object)theUser.getUsername());
                response.sendRedirect(DAO.getSamlIdp());
                return;
            }
            this.renderQueueVM(currentUser.noOfUsers, request, response);
            return;
        }
    }

    private void renderQueueVM(int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("duration", DAO.getDuration());
        context.put("queueSize", noOfUsers);
        context.put("redirUrl", DAO.getSamlIdp());
        context.put("urlLogo", DAO.getUrlLogo());
        context.put("queueMessage", DAO.getQueueMessage());
        context.put("urlRest", DAO.getUrlRest());
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }
}

