/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.annotations.security.UnlicensedSiteAccess;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@UnlicensedSiteAccess
public class FakeLogFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(FakeLogFilter.class);
    @ComponentImport
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Inject
    public FakeLogFilter(JiraAuthenticationContext jiraAuthenticationContext) {
        LOG.info("FakeLogFilter constructor.");
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("FakeLogFilter initialized.");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
            if (LOG.isDebugEnabled()) {
                LOG.debug("FakeLogFilter doFilter " + (user != null ? user.getName() : "N/A") + ", requestURI =" + (httpServletRequest.getRequestURI() != null ? httpServletRequest.getRequestURI() : "N/A") + ", servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "N/A") + ", pathInfo=" + (httpServletRequest.getPathInfo() != null ? httpServletRequest.getPathInfo() : "N/A") + ", user=" + (httpServletRequest.getRemoteUser() != null ? httpServletRequest.getRemoteUser() : "N/A"));
            }
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
    }
}

