/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.side;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarUrls;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserResource;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.component.ComponentLocator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Deprecated
@Component
@Path(value="/search")
public class SearchService {
    private static final Logger LOG = LoggerFactory.getLogger(SearchService.class);
    public static final int LIMIT = 100;
    private final UserSearchService userSearchService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @ComponentImport
    private final ApplicationProperties applicationProperties;
    @ComponentImport
    private final EmailFormatter emailFormatter;
    @ComponentImport
    private final I18nHelper.BeanFactory beanFactory;
    private final UserManager userManager;

    public SearchService(JiraAuthenticationContext jiraAuthenticationContext, ApplicationProperties applicationProperties, EmailFormatter emailFormatter, I18nHelper.BeanFactory beanFactory) {
        this.applicationProperties = applicationProperties;
        this.emailFormatter = emailFormatter;
        this.beanFactory = beanFactory;
        this.userManager = ComponentAccessor.getUserManager();
        this.userSearchService = (UserSearchService)ComponentLocator.getComponent(UserSearchService.class);
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    JiraServiceContext getContext() {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        return new JiraServiceContextImpl(user, (ErrorCollection)errorCollection);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/user")
    public Response searchUser(@QueryParam(value="username") String username, @QueryParam(value="projectKeys") String projectKeys, @QueryParam(value="actionDescriptorId") int actionDescriptorId, @QueryParam(value="maxResults") int maxResults) {
        try {
            Object userFilter = null;
            UserSearchParams userSearchParams = UserSearchParams.builder().includeActive(true).includeInactive(false).allowEmptyQuery(true).maxResults(Integer.valueOf(maxResults)).build();
            List users = this.userSearchService.findUsers(this.getContext(), username, userSearchParams);
            return Response.ok(this.convertUsersToUserBeans(Locale.getDefault(), users)).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    private List<UserBean> convertUsersToUserBeans(Locale aDefault, Collection<ApplicationUser> users) throws URISyntaxException {
        ArrayList<UserBean> userBeanList = new ArrayList<UserBean>();
        for (ApplicationUser user : users) {
            userBeanList.add(new UserBean(this.createSelfLink(user), user.getKey(), user.getName(), user.getDisplayName(), true, user.getEmailAddress(), null, SearchService.getAvatarURLs(user), null));
        }
        return userBeanList;
    }

    private static Map<String, URI> getAvatarURLs(ApplicationUser forUser) {
        Avatar avatar = ComponentAccessor.getAvatarService().getAvatar(forUser, forUser);
        return avatar != null ? AvatarUrls.getAvatarURLs((ApplicationUser)forUser, (Avatar)avatar) : null;
    }

    private URI createSelfLink(ApplicationUser forUser) {
        UriBuilder urlBuilder = UriBuilder.fromPath((String)this.applicationProperties.getBaseUrl()).path("rest").path(UserResource.class).queryParam("username", new Object[]{"{0}"});
        return urlBuilder.build(new Object[]{forUser.getUsername()});
    }
}

