/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.authorisation;

import com.atlassian.jira.security.auth.Authorisation;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Sets;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class IUMReferenceAuthorisation
implements Authorisation {
    public Authorisation.Decision authoriseForLogin(@Nonnull ApplicationUser applicationUser, HttpServletRequest httpServletRequest) {
        if (IntelligentUserManagerHelper.isUserInGroups(applicationUser, DAO.getIUMGroupsDisabled())) {
            return Authorisation.Decision.GRANTED;
        }
        return Authorisation.Decision.ABSTAIN;
    }

    public Set<String> getRequiredRoles(HttpServletRequest httpServletRequest) {
        HashSet requiredRoles = Sets.newHashSet();
        return requiredRoles;
    }

    public Authorisation.Decision authoriseForRole(@Nullable ApplicationUser applicationUser, HttpServletRequest httpServletRequest, String role) {
        return Authorisation.Decision.ABSTAIN;
    }
}

