/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.cache;

import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.opensymphony.module.propertyset.PropertySet;
import de.accxia.jira.addon.IUM.cache.AccxiaCacheComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AccxiaCachePropertySet {
    private static final Logger LOG = LoggerFactory.getLogger(AccxiaCacheComponent.class);
    private static final String PLUGIN_STORAGE_KEY = "de.accxia.jira.addons.usermanager";
    private static final String PLUGIN = "IUM4J";
    private static final Long PLUGIN_ID = 1001L;
    private Map<String, PropertySet> cacheMap;
    private JiraPropertySetFactory jiraPropertySetFactory;

    @Inject
    public AccxiaCachePropertySet(@ComponentImport JiraPropertySetFactory jiraPropertySetFactory) {
        this.jiraPropertySetFactory = jiraPropertySetFactory;
        this.cacheMap = new HashMap<String, PropertySet>();
    }

    public boolean hasKey(String field) {
        boolean containsKey = this.cacheMap.containsKey(field);
        if (LOG.isTraceEnabled()) {
            LOG.trace("AccxiaCachePropertySet.hasKey " + field + " " + containsKey);
        }
        return containsKey;
    }

    public String getValue(String field) {
        if (this.cacheMap.containsKey(field)) {
            String value = this.cacheMap.get(field).getString(field);
            if (LOG.isTraceEnabled()) {
                LOG.trace("AccxiaCachePropertySet.getValue from cache " + field + "   " + (value == null ? "NULL" : value.toString()));
            }
            return value;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("AccxiaCachePropertySet.getValue not found in cache" + field);
        }
        return "";
    }

    public void setValue(String field, String value) {
        if (this.cacheMap.containsKey(field)) {
            String olderValue = this.cacheMap.get(field).getString(field);
            if (!(value == null && olderValue == null || value != null && value.equals(olderValue))) {
                if (value != null && value.length() > 255) {
                    this.cacheMap.get(field).setText(field, value);
                } else {
                    this.cacheMap.get(field).setString(field, value);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("AccxiaCachePropertySet.setValue  field={} value={}", new Object[]{field, value});
                }
            }
        } else {
            PropertySet propertySet = this.jiraPropertySetFactory.buildCachingPropertySet(field, PLUGIN_ID);
            if (value != null && value.length() > 255) {
                propertySet.setText(field, value);
            } else {
                propertySet.setString(field, value);
            }
            this.cacheMap.put(field, propertySet);
        }
    }

    public void clean() {
        for (String key : this.cacheMap.keySet()) {
            PropertySet propertySet = this.cacheMap.get(key);
            propertySet.remove();
        }
        this.cacheMap.clear();
    }

    public Set<String> getKeys() {
        return this.cacheMap.keySet();
    }
}

