/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.config;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.jira.addon.IUM.config.DbInfo;
import de.accxia.jira.addon.IUM.config.ResultOperation;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DBEngine {
    private static final Logger LOG = LoggerFactory.getLogger(DBEngine.class);
    public static final String CREATE_MYSQL_INDEXES = "/sql/create/mysql_indexes.sql";
    public static final String CREATE_SQLSERVER_INDEXES = "/sql/create/sqlserver_indexes.sql";
    public static final String CREATE_ORACLE_INDEXES = "/sql/create/oracle_indexes.sql";
    public static final String CREATE_POSTGRESQL_INDEXES = "/sql/create/postgresql_indexes.sql";
    public static final String CREATE_UNKNOWN_INDEXES = "/sql/create/unknown_indexes.sql";
    public static final String DROP_MYSQL_INDEXES = "/sql/drop/mysql_indexes.sql";
    public static final String DROP_SQLSERVER_INDEXES = "/drop/create/sqlserver_indexes.sql";
    public static final String DROP_ORACLE_INDEXES = "/sql/drop/oracle_indexes.sql";
    public static final String DROP_POSTGRESQL_INDEXES = "/sql/drop/postgresql_indexes.sql";
    public static final String DROP_UNKNOWN_INDEXES = "/sql/drop/unknown_indexes.sql";
    public static final String SELECT_MYSQL_INDEXES = "/sql/select/mysql_indexes.sql";
    public static final String SELECT_SQLSERVER_INDEXES = "/sql/select/sqlserver_indexes.sql";
    public static final String SELECT_ORACLE_INDEXES = "/sql/select/oracle_indexes.sql";
    public static final String SELECT_POSTGRESQL_INDEXES = "/sql/select/postgresql_indexes.sql";
    public static final String SELECT_UNKNOWN_INDEXES = "/sql/select/unknown_indexes.sql";
    @ComponentImport
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @ComponentImport
    private final ActiveObjects activeObjects;
    private DbInfo dbInfo = null;
    private DatabaseType databaseType = null;
    private String currentSchema = null;
    private String currentDatabase = null;
    private final DefaultOfBizConnectionFactory connectionFactory = DefaultOfBizConnectionFactory.getInstance();
    private static String CURRENT_SCHEMA_PostgreSQL = "SELECT current_schema()";
    private static String CURRENT_SCHEMA_Oracle = "SELECT SYS_CONTEXT('USERENV','CURRENT_SCHEMA') FROM dual";
    private static String CURRENT_SCHEMA_SQL_Server = "SELECT SCHEMA_NAME()";
    private static String CURRENT_SCHEMA_MySQL = "SELECT DATABASE()";
    private static String CURRENT_DATABASE_PostgreSQL = "SELECT current_database()";
    private static String CURRENT_DATABASE_MySQL = "SELECT DATABASE()";
    private static String CURRENT_DATABASE_SQL_Server = "SELECT DB_NAME()";
    private static String CURRENT_DATABASE_Oracle = "SELECT ora_database_name FROM dual";

    public DBEngine(JiraAuthenticationContext jiraAuthenticationContext, ActiveObjects activeObjects) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.activeObjects = activeObjects;
    }

    public DatabaseType getDatabaseType() {
        if (this.databaseType != null) {
            return this.databaseType;
        }
        this.databaseType = this.activeObjects.moduleMetaData().getDatabaseType();
        return this.databaseType;
    }

    public ResultOperation createIndexes() throws SQLException {
        try {
            DatabaseType dbType = this.getDatabaseType();
            List<String> sql = null;
            sql = DBEngine.isMySQL(dbType) ? DBEngine.loadResourceAsList(CREATE_MYSQL_INDEXES) : (DBEngine.isPostgres(dbType) ? DBEngine.loadResourceAsList(CREATE_POSTGRESQL_INDEXES) : (DBEngine.isSqlserver(dbType) ? DBEngine.loadResourceAsList(CREATE_SQLSERVER_INDEXES) : (DBEngine.isOracle(dbType) ? DBEngine.loadResourceAsList(CREATE_ORACLE_INDEXES) : DBEngine.loadResourceAsList(CREATE_UNKNOWN_INDEXES))));
            return this.runner(sql);
        }
        catch (Exception e) {
            LOG.error("Error creating indexes: " + e.getMessage(), (Throwable)e);
            throw new SQLException("Error creating indexes: " + e.getMessage(), e);
        }
    }

    public ResultOperation dropIndexes() throws SQLException {
        try {
            DatabaseType dbType = this.getDatabaseType();
            List<String> sql = null;
            sql = DBEngine.isMySQL(dbType) ? DBEngine.loadResourceAsList(DROP_MYSQL_INDEXES) : (DBEngine.isPostgres(dbType) ? DBEngine.loadResourceAsList(DROP_POSTGRESQL_INDEXES) : (DBEngine.isSqlserver(dbType) ? DBEngine.loadResourceAsList(DROP_SQLSERVER_INDEXES) : (DBEngine.isOracle(dbType) ? DBEngine.loadResourceAsList(DROP_ORACLE_INDEXES) : DBEngine.loadResourceAsList(DROP_UNKNOWN_INDEXES))));
            return this.runner(sql);
        }
        catch (Exception e) {
            LOG.error("Error creating indexes: " + e.getMessage(), (Throwable)e);
            throw new SQLException("Error creating indexes: " + e.getMessage(), e);
        }
    }

    public ResultOperation checkIndexes() throws SQLException {
        try {
            DatabaseType dbType = this.getDatabaseType();
            List<String> sql = null;
            sql = DBEngine.isMySQL(dbType) ? DBEngine.loadResourceAsList(SELECT_MYSQL_INDEXES) : (DBEngine.isPostgres(dbType) ? DBEngine.loadResourceAsList(SELECT_POSTGRESQL_INDEXES) : (DBEngine.isSqlserver(dbType) ? DBEngine.loadResourceAsList(SELECT_SQLSERVER_INDEXES) : (DBEngine.isOracle(dbType) ? DBEngine.loadResourceAsList(SELECT_ORACLE_INDEXES) : DBEngine.loadResourceAsList(SELECT_UNKNOWN_INDEXES))));
            return this.runnerWithResult(sql);
        }
        catch (Exception e) {
            LOG.error("Error checking indexes: " + e.getMessage(), (Throwable)e);
            throw new SQLException("Error checking indexes: " + e.getMessage(), e);
        }
    }

    public DbInfo getDatabaseInfo() throws SQLException {
        if (this.dbInfo != null) {
            return this.dbInfo;
        }
        try {
            Connection conn = this.getConnection();
            DatabaseType dbType = this.getDatabaseType();
            DbInfo dbInfo = new DbInfo();
            try {
                String currentSchema = dbType == DatabaseType.ORACLE ? conn.getMetaData().getUserName() : this.getCurrentSchema();
                dbInfo.setCatalog(conn.getCatalog());
                dbInfo.setSchema(this.getCurrentSchema());
                dbInfo.setName(this.getCurrentDatabase());
                dbInfo.setType(dbType.name());
                this.dbInfo = dbInfo;
            }
            catch (Throwable e) {
                if (conn != null) {
                    try {
                        conn.close();
                        conn = null;
                    }
                    catch (Throwable ex) {
                        LOG.error("Error closing connection" + ex.getMessage(), ex);
                        e.addSuppressed(ex);
                    }
                }
                throw new SQLException(e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable ex) {
                        LOG.error("Error closing connection" + ex.getMessage(), ex);
                    }
                }
            }
            return dbInfo;
        }
        catch (DataAccessException | SQLException e) {
            throw new SQLException("Error obtaining tables ", e);
        }
    }

    public ResultOperation runner(List<String> sqls) throws SQLException {
        StringBuffer sb = new StringBuffer();
        ResultOperation resultOperation = new ResultOperation();
        String currentSchema = this.getCurrentSchema();
        String currentDatabase = this.getCurrentDatabase();
        if (null == sqls || sqls.isEmpty()) {
            resultOperation.setStatus(false);
            resultOperation.setMessage("No SQL found ");
            return resultOperation;
        }
        Connection connection = null;
        try {
            resultOperation.setStatus(true);
            connection = this.connectionFactory.getConnection();
            for (String sql : sqls) {
                if (StringUtils.isEmpty((CharSequence)sql) || sql.startsWith("--")) continue;
                LOG.debug("SQL - " + sql);
                try {
                    Statement stmt = connection.createStatement();
                    try {
                        sql = sql.replace("{schema}", currentSchema);
                        sql = sql.replace("{database}", currentDatabase);
                        stmt.execute(sql);
                        sb.append("Successful executing sql ").append(sql);
                    }
                    finally {
                        if (stmt == null) continue;
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    resultOperation.setStatus(false);
                    LOG.error("Error executing sql " + sql + " " + e.getMessage(), (Throwable)e);
                    sb.append("Error executing sql ").append(sql).append(" ").append(e.getMessage());
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error executing sql " + e.getMessage(), (Throwable)e);
            throw new SQLException("Error executing sql " + e.getMessage(), e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                resultOperation.setStatus(false);
                LOG.error("Error closing connection" + e.getMessage(), (Throwable)e);
            }
        }
        resultOperation.setMessage(sb.toString());
        return resultOperation;
    }

    public ResultOperation runnerWithResult(List<String> sqls) throws SQLException {
        StringBuffer sb = new StringBuffer();
        ResultOperation resultOperation = new ResultOperation();
        String currentSchema = this.getCurrentSchema();
        String currentDatabase = this.getCurrentDatabase();
        if (null == sqls || sqls.isEmpty()) {
            resultOperation.setStatus(false);
            resultOperation.setMessage("No SQL found ");
            return resultOperation;
        }
        Connection connection = null;
        try {
            resultOperation.setStatus(true);
            connection = this.connectionFactory.getConnection();
            for (String sql : sqls) {
                if (StringUtils.isEmpty((CharSequence)sql) || sql.startsWith("--")) continue;
                LOG.debug("SQL - " + sql);
                try {
                    Statement stmt = connection.createStatement();
                    try {
                        sql = sql.replace("{schema}", currentSchema);
                        sql = sql.replace("{database}", currentDatabase);
                        boolean retVal = stmt.execute(sql);
                        if (!retVal) {
                            resultOperation.setStatus(stmt.getUpdateCount() >= 1);
                        } else {
                            try (ResultSet resultSet = stmt.getResultSet();){
                                resultOperation.setStatus(resultSet.next());
                            }
                        }
                        sb.append("Successful executing sql ").append(sql);
                    }
                    finally {
                        if (stmt == null) continue;
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    resultOperation.setStatus(false);
                    LOG.error("Error executing sql " + sql + " " + e.getMessage(), (Throwable)e);
                    sb.append("Error executing sql ").append(sql).append(" ").append(e.getMessage());
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error executing sql " + e.getMessage(), (Throwable)e);
            throw new SQLException("Error executing sql " + e.getMessage(), e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                resultOperation.setStatus(false);
                LOG.error("Error closing connection" + e.getMessage(), (Throwable)e);
            }
        }
        resultOperation.setMessage(sb.toString());
        return resultOperation;
    }

    protected Connection getConnection() throws SQLException {
        try {
            return this.connectionFactory.getConnection();
        }
        catch (Exception e) {
            throw new SQLException("Error obtaining new connection to database: ", e);
        }
    }

    private String getCatalog(DatabaseMetaData metadata) throws SQLException {
        String catalog = null;
        DatabaseType databaseType = this.getDatabaseType();
        if (!DBEngine.isMySQL(databaseType)) {
            ResultSet catalogs = metadata.getCatalogs();
            while (catalogs.next()) {
                catalog = catalogs.getString(1);
            }
        }
        return catalog;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCurrentSchema() {
        if (this.currentSchema != null) {
            return this.currentSchema;
        }
        DatabaseType databaseType = this.getDatabaseType();
        String sql = null;
        switch (databaseType) {
            case POSTGRESQL: {
                sql = CURRENT_SCHEMA_PostgreSQL;
                break;
            }
            case ORACLE: {
                sql = CURRENT_SCHEMA_Oracle;
                break;
            }
            case MS_SQL: {
                sql = CURRENT_SCHEMA_SQL_Server;
                break;
            }
            case MYSQL: {
                sql = CURRENT_SCHEMA_MySQL;
                break;
            }
            default: {
                sql = CURRENT_SCHEMA_PostgreSQL;
            }
        }
        try (Connection conn = this.connectionFactory.getConnection();
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            if (!rs.next()) return null;
            String string = this.currentSchema = rs.getString(1);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCurrentDatabase() {
        if (this.currentDatabase != null) {
            return this.currentDatabase;
        }
        DatabaseType databaseType = this.getDatabaseType();
        String sql = null;
        switch (databaseType) {
            case POSTGRESQL: {
                sql = CURRENT_DATABASE_PostgreSQL;
                break;
            }
            case ORACLE: {
                sql = CURRENT_DATABASE_Oracle;
                break;
            }
            case MS_SQL: {
                sql = CURRENT_DATABASE_SQL_Server;
                break;
            }
            case MYSQL: {
                sql = CURRENT_DATABASE_MySQL;
                break;
            }
            default: {
                sql = CURRENT_DATABASE_PostgreSQL;
            }
        }
        try (Connection conn = this.connectionFactory.getConnection();
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            if (!rs.next()) return null;
            String string = this.currentDatabase = rs.getString(1);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isOracle(DatabaseType dbType) {
        return DatabaseType.ORACLE == dbType;
    }

    public static boolean isPostgres(DatabaseType dbType) {
        return DatabaseType.POSTGRESQL == dbType;
    }

    public static boolean isMySQL(DatabaseType dbType) {
        return DatabaseType.MYSQL == dbType;
    }

    public static boolean isSqlserver(DatabaseType dbType) {
        return DatabaseType.MS_SQL == dbType;
    }

    public static StringBuffer loadResourceName(String resourceName) {
        StringBuffer stringBuffer = new StringBuffer();
        try (InputStream in = DBEngine.class.getResourceAsStream(resourceName);
             BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            reader.lines().forEach(line -> {
                stringBuffer.append((String)line);
                stringBuffer.append("\n");
            });
        }
        catch (Exception e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ResourceName: {} value {}", new Object[]{resourceName, stringBuffer.toString()});
        }
        return stringBuffer;
    }

    private static List<String> loadResourceAsList(String resourceName) {
        ArrayList<String> lines = new ArrayList<String>();
        try (InputStream in = DBEngine.class.getResourceAsStream(resourceName);
             BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            reader.lines().forEach(line -> lines.add((String)line));
        }
        catch (Exception e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ResourceName: {} value {}", new Object[]{resourceName, String.join((CharSequence)",", lines)});
        }
        return lines;
    }
}

