/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.job;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;
import de.accxia.jira.addon.IUM.job.IUMClusterJob;
import de.accxia.jira.addon.IUM.job.JobData;
import de.accxia.jira.addon.IUM.job.JobDataUtils;
import de.accxia.jira.addon.IUM.job.MonitorJobRunner;
import de.accxia.jira.addon.IUM.model.JobResult;
import de.accxia.jira.addon.IUM.model.JobResultDTO;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={JobClusterService.class})
@Named(value="jobClusterService")
public class JobClusterService {
    private Logger LOG = LoggerFactory.getLogger(JobClusterService.class);
    private final MonitorJobRunner monitorJobRunner;
    private final JobResultRepository jobResultRepository;

    @Inject
    public JobClusterService(MonitorJobRunner monitorJobRunner, JobResultRepository jobResultRepository) {
        this.monitorJobRunner = monitorJobRunner;
        this.jobResultRepository = jobResultRepository;
    }

    public boolean start() {
        try {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("JobClusterService call start");
            }
            this.monitorJobRunner.doUnSchedule(IUMClusterJob.class);
            this.monitorJobRunner.doSchedule(JobDataUtils.createIUMJobData(), IUMClusterJob.getInstance());
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            this.LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean restart() {
        try {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("JobSyncService call restart");
            }
            this.monitorJobRunner.doUnSchedule(IUMClusterJob.class);
            JobData jobData = JobDataUtils.createIUMJobData();
            jobData.getParameters().put("restart", Boolean.TRUE);
            this.monitorJobRunner.doSchedule(jobData, IUMClusterJob.getInstance());
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            this.LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean stop() {
        try {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("JobClusterService doStop");
            }
            this.monitorJobRunner.doUnSchedule(IUMClusterJob.class);
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            this.LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean isWorking() {
        return this.monitorJobRunner.isWorking(IUMClusterJob.class);
    }

    public JobDetails getJobDetails() {
        return this.monitorJobRunner.getJobDetails(IUMClusterJob.class);
    }

    public Date getNextRunDate() {
        return this.monitorJobRunner.getNextRunDate(IUMClusterJob.class);
    }

    public RunDetails getLastSuccessfulRunForJob() {
        return this.monitorJobRunner.getLastSuccessfulRunForJob(IUMClusterJob.class);
    }

    public List<JobResultDTO> findLatest(int idx, int ctx) {
        JobResult[] jobResults = this.jobResultRepository.findWithUserRemovedAll(new String[]{"CleanJob"}, idx, ctx);
        List<JobResultDTO> jobResultDTOList = Arrays.stream(jobResults).map(jobResult -> JobResultDTO.fromAO(jobResult)).collect(Collectors.toList());
        return jobResultDTOList;
    }
}

