/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.config.RestRoute;
import de.accxia.jira.addon.IUM.impl.CurrentUser;
import de.accxia.jira.addon.IUM.impl.IUMHelperCacheService;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.impl.Quota;
import de.accxia.jira.addon.IUM.servlet.filter.XSSHttpServletRequestWrapper;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@UnrestrictedAccess
public class IntelligentUserManagerCerberosFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(IntelligentUserManagerCerberosFilter.class);
    public static final String ORIGIN = "origin";
    public static final String URI_RESTORE = "secure/restore";
    public static final String URI_DISABLE = "secure/disable";
    @ComponentImport
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @ComponentImport
    private final ApplicationProperties applicationProperties;
    @ComponentImport
    private final ApplicationAuthorizationService applicationAuthorizationService;
    @ComponentImport
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final IssueManager issueManager;
    @ComponentImport
    private final ProjectManager projectManager;
    @ComponentImport
    private PageBuilderService pageBuilderService;
    @ComponentImport
    private final TemplateRenderer renderer;
    private static final String ISSUE_KEY_PATTERN = ".*/browse/([\\w\\-\\d]+)$";
    private static final String ISSUE_KEY_PATTERN_2 = ".*/projects/([\\w\\-\\d]+)/issues/([\\w\\-\\d]+)";
    private static final Pattern ISSUE_PATTERN = Pattern.compile(".*/browse/([\\w\\-\\d]+)$");
    private static final Pattern ISSUE_PATTERN_2 = Pattern.compile(".*/browse/([\\w\\-\\d]+)$");
    private static final String PROJECTS_KEY_PATTERN = ".*/projects/([\\w\\-\\d]+)/queues/(.*)/([\\w\\-\\d]+)$";
    private static final Pattern PROJECTS_PATTERN = Pattern.compile(".*/projects/([\\w\\-\\d]+)/queues/(.*)/([\\w\\-\\d]+)$");

    @Inject
    public IntelligentUserManagerCerberosFilter(TemplateRenderer renderer, PageBuilderService pageBuilderService, IssueSecurityLevelManager issueSecurityLevelManager, IssueManager issueManager, ApplicationAuthorizationService applicationAuthorizationService, JiraAuthenticationContext jiraAuthenticationContext, ApplicationProperties applicationProperties, PermissionManager permissionManager, ProjectManager projectManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.renderer = renderer;
        this.applicationProperties = applicationProperties;
        this.pageBuilderService = pageBuilderService;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.issueManager = issueManager;
        this.applicationAuthorizationService = applicationAuthorizationService;
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        CurrentUser currentUser;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (log.isDebugEnabled()) {
            log.debug("IntelligentUserManagerCerberosFilter doFilter requestURI =" + (httpServletRequest.getRequestURI() != null ? httpServletRequest.getRequestURI() : "N/A") + ", servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "N/A") + ", pathInfo=" + (httpServletRequest.getPathInfo() != null ? httpServletRequest.getPathInfo() : "N/A") + ", user=" + (httpServletRequest.getRemoteUser() != null ? httpServletRequest.getRemoteUser() : "N/A"));
        }
        if (!this.jiraAuthenticationContext.isLoggedInUser()) {
            chain.doFilter(request, response);
            return;
        }
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        if (user == null || !user.isActive()) {
            chain.doFilter(request, response);
            return;
        }
        if (httpServletRequest.getRequestURI() != null && (httpServletRequest.getRequestURI().contains("/rest/IUM/latest/apps") || httpServletRequest.getRequestURI().contains("/rest/IUM/latest/check") || httpServletRequest.getRequestURI().contains("/rest/IUM/latest/retry") || httpServletRequest.getRequestURI().contains("/rest/lastlog") || httpServletRequest.getRequestURI().contains("/rest/projects") || httpServletRequest.getRequestURI().contains("/rest/plugins/") || httpServletRequest.getRequestURI().contains("/rest/wrm") || httpServletRequest.getRequestURI().contains("/rest/bamboo") || httpServletRequest.getRequestURI().contains("/rest/analytics") || httpServletRequest.getRequestURI().contains("/rest/gadget/1.0/login"))) {
            if (log.isDebugEnabled()) {
                log.debug("NonWatchedRestRequest=" + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
            }
            chain.doFilter(request, response);
            return;
        }
        if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains("/secure/viewavatar")) {
            if (log.isDebugEnabled()) {
                log.debug("NonWatchedRestRequest=" + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
            }
            chain.doFilter(request, response);
            return;
        }
        if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains("/rest/") && !this.shouldInterceptRestRequest(httpServletRequest)) {
            if (log.isDebugEnabled()) {
                log.debug("NonWatchedRestRequest=" + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
            }
            chain.doFilter(request, response);
            return;
        }
        if (!ConditionEvaluatorImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains("/login.jsp")) {
            chain.doFilter(request, response);
            return;
        }
        if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains("/logout.action")) {
            chain.doFilter(request, response);
            return;
        }
        if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains("/secure/Logout")) {
            chain.doFilter(request, response);
            return;
        }
        if (!IntelligentUserManagerHelper.isUserInGroups(user, DAO.getIUMGroupsDisabled())) {
            if (log.isDebugEnabled()) {
                log.debug("IntelligentUserManagerCerberosFilter " + user.getName() + " is not belong to IUM Disable :" + DAO.getIUMGroupsDisabled() + "  ==> forward doFilter ");
            }
            chain.doFilter(request, response);
            return;
        }
        if (httpServletRequest.getServletPath() != null && httpServletRequest.getServletPath().contains("/servicedesk") && "POST".equalsIgnoreCase(httpServletRequest.getMethod())) {
            if (log.isDebugEnabled()) {
                log.debug("special case for servletPath/xhr request for ServiceDesk " + httpServletRequest.getServletPath());
            }
            chain.doFilter((ServletRequest)httpServletRequest, response);
            return;
        }
        if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains(URI_DISABLE)) {
            String username;
            if (log.isDebugEnabled()) {
                log.debug("Received disable url=secure/disable " + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
            }
            if ((username = request.getParameter("username")) == null || username.length() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Empty username for secure/disable redirect '/' ");
                }
                ((HttpServletResponse)response).sendRedirect(httpServletRequest.getContextPath() + "/");
                return;
            }
            if (username != null && username.length() > 0 && IntelligentUserManagerHelper.isUserInGroups(username, DAO.getIUMGroups())) {
                if (log.isDebugEnabled()) {
                    log.debug("Redirect to the saved url | referrer | base url " + this.applicationProperties.getBaseUrl());
                }
                IUMHelperCacheService.getInstance().removeUserFromRemovalCache(user.getName());
                this.doGlobalRedirect(httpServletRequest, (HttpServletResponse)response);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Redirect user " + username + " to the queue ");
            }
            this.renderQueueVM(username, IntelligentUserManagerHelper.getQuotaForGroupOfUsername(username), httpServletRequest, (HttpServletResponse)response);
            return;
        }
        if (IntelligentUserManagerHelper.isUserInGroups(user, DAO.getIUMGroups())) {
            httpServletRequest.getSession().setAttribute("IUMREDIRECT", null);
            if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains(URI_RESTORE)) {
                if (log.isDebugEnabled()) {
                    log.debug("Received restore url=secure/restore  " + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
                }
                IUMHelperCacheService.getInstance().removeUserFromRemovalCache(user.getName());
                this.doGlobalRedirect(httpServletRequest, (HttpServletResponse)response);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("IntelligentUserManagerCerberosFilter user " + user.getName() + " belong to IUM Enable :" + DAO.getIUMGroups() + "  ==> forward doFilter ");
            }
            chain.doFilter(request, response);
            return;
        }
        XSSHttpServletRequestWrapper xssRequest = new XSSHttpServletRequestWrapper((HttpServletRequest)request);
        if (this.shouldInterceptRestRequest((HttpServletRequest)xssRequest)) {
            if (log.isDebugEnabled()) {
                log.debug("InterceptRestRequest=" + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
            }
            IntelligentUserManagerHelper.simulateUserToEnabledGroup(user);
            chain.doFilter((ServletRequest)xssRequest, response);
            return;
        }
        if (xssRequest.getRequestURI() != null && xssRequest.getRequestURI().contains("/rest/")) {
            if (log.isDebugEnabled()) {
                log.debug("RestRequest=" + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
            }
            chain.doFilter(request, response);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Attempt to enable route=" + xssRequest.getRequestURI() + " for user " + user.getUsername());
        }
        if ((currentUser = IntelligentUserManagerHelper.enableUserFromGroup(user, (HttpServletRequest)xssRequest)) != null && currentUser.user != null) {
            IntelligentUserManagerHelper.simulateUserToEnabledGroup(user);
            xssRequest.getSession().setAttribute("IUMUSER", (Object)user.getUsername());
            String issueKey = this.getIssueLinkWithoutPermission(httpServletRequest, (HttpServletResponse)response);
            if (issueKey != null && (httpServletRequest.getSession().getAttribute("IUMREDIRECT") == null || !((Boolean)httpServletRequest.getSession().getAttribute("IUMREDIRECT")).booleanValue()) && this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, (Issue)this.issueManager.getIssueByCurrentKey(issueKey), user)) {
                if (log.isDebugEnabled()) {
                    log.debug("Redirect=" + xssRequest.getRequestURI() + " for user " + user.getUsername() + " ASK BROWSE_PROJECTS");
                }
                xssRequest.getSession().setAttribute("IUMREDIRECT", (Object)Boolean.TRUE);
                ((HttpServletResponse)response).setStatus(302);
                ((HttpServletResponse)response).setHeader("Location", httpServletRequest.getRequestURI());
                ((HttpServletResponse)response).sendRedirect(httpServletRequest.getRequestURI());
                ((HttpServletResponse)response).flushBuffer();
                return;
            }
            String projectKey = this.getProjectLinkWithoutPermission(httpServletRequest, (HttpServletResponse)response);
            if (projectKey != null && (httpServletRequest.getSession().getAttribute("IUMREDIRECT") == null || !((Boolean)httpServletRequest.getSession().getAttribute("IUMREDIRECT")).booleanValue()) && this.permissionManager.hasPermission(10, this.projectManager.getProjectObjByKey(projectKey), user)) {
                xssRequest.getSession().setAttribute("IUMREDIRECT", (Object)Boolean.TRUE);
                ((HttpServletResponse)response).setStatus(302);
                ((HttpServletResponse)response).setHeader("Location", httpServletRequest.getRequestURI());
                ((HttpServletResponse)response).sendRedirect(httpServletRequest.getRequestURI());
                ((HttpServletResponse)response).flushBuffer();
                return;
            }
            httpServletRequest.getSession().setAttribute("IUMREDIRECT", null);
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            if (!StringUtils.isEmpty((CharSequence)currentUser.warningMessage)) {
                IntelligentUserManagerCerberosFilter.addWarnMessage2Response(httpServletRequest, httpServletResponse, "login_info_cookie", currentUser.warningMessage);
            } else {
                this.removeWarnMessage2Response(httpServletRequest, httpServletResponse, "login_info_cookie", currentUser.warningMessage);
            }
            if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains(URI_RESTORE) && httpServletRequest.getMethod().equalsIgnoreCase("POST")) {
                if (log.isDebugEnabled()) {
                    log.debug("Received restore secure/restore " + httpServletRequest.getRequestURI() + " ,servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "NULL"));
                }
                this.doGlobalRedirect(httpServletRequest, (HttpServletResponse)response);
                return;
            }
            chain.doFilter((ServletRequest)xssRequest, response);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Unable to enabled route  " + xssRequest.getRequestURI() + " for user " + user.getUsername());
        }
        if (httpServletRequest.getRequestURI() != null && httpServletRequest.getRequestURI().contains(URI_RESTORE)) {
            if (log.isDebugEnabled()) {
                log.debug("Redirect to waiting page secure/restore");
            }
            this.renderQueueVM(user.getUsername(), currentUser != null ? currentUser.noOfUsers : 0, (HttpServletRequest)xssRequest, (HttpServletResponse)response);
            return;
        }
        if (xssRequest.getServletPath() != null && xssRequest.getServletPath().contains("/servicedesk") && "POST".equalsIgnoreCase(xssRequest.getMethod())) {
            chain.doFilter((ServletRequest)xssRequest, response);
        } else {
            this.renderQueueVM(user.getUsername(), currentUser != null ? currentUser.noOfUsers : 0, (HttpServletRequest)xssRequest, (HttpServletResponse)response);
        }
    }

    private String getIssueLinkWithoutPermission(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String strURI = httpServletRequest.getRequestURI();
        Matcher matcher = ISSUE_PATTERN.matcher(strURI);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        Matcher matcher2 = ISSUE_PATTERN_2.matcher(strURI);
        if (matcher2.matches() && matcher2.groupCount() > 1) {
            return matcher2.group(2);
        }
        return null;
    }

    private String getProjectLinkWithoutPermission(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String strURI = httpServletRequest.getRequestURI();
        Matcher matcher = PROJECTS_PATTERN.matcher(strURI);
        if (matcher.matches() && matcher.groupCount() > 2) {
            return matcher.group(3);
        }
        return null;
    }

    private void doGlobalRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String referrer;
        String origin = httpServletRequest.getParameter(ORIGIN);
        if (origin != null && origin.length() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("doGlobalRedirect  ==> " + origin + " , baseUrl=" + this.applicationProperties.getBaseUrl() + " , referer=" + (httpServletRequest.getHeader("referer") != null ? httpServletRequest.getHeader("referer") : "N/A"));
            }
            if (origin.toLowerCase().startsWith("http") && !origin.toLowerCase().startsWith(this.applicationProperties.getBaseUrl().toLowerCase())) {
                String referer = httpServletRequest.getHeader("referer");
                if (log.isDebugEnabled()) {
                    log.debug("doGlobalRedirect auth ==> " + this.applicationProperties.getBaseUrl() + " , referer=" + (referer != null ? referer : "N/A"));
                }
                if (referer != null && referer.toLowerCase().startsWith("http") && referer.toLowerCase().startsWith(this.applicationProperties.getBaseUrl().toLowerCase())) {
                    httpServletResponse.sendRedirect(referer);
                    return;
                }
                httpServletResponse.sendRedirect(this.applicationProperties.getBaseUrl());
                return;
            }
            httpServletResponse.sendRedirect(origin);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("IntelligentUserManagerCerberosFilter doGlobalRedirect requestURI =" + (httpServletRequest.getRequestURI() != null ? httpServletRequest.getRequestURI() : "N/A") + ", servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "N/A") + ", pathInfo=" + (httpServletRequest.getPathInfo() != null ? httpServletRequest.getPathInfo() : "N/A") + ", referer=" + (httpServletRequest.getHeader("referer") != null ? httpServletRequest.getHeader("referer") : "N/A") + ", user=" + (httpServletRequest.getRemoteUser() != null ? httpServletRequest.getRemoteUser() : "N/A"));
            this.doDebugRequestData((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        if (!((referrer = httpServletRequest.getHeader("referer")) == null || referrer.length() <= 0 || httpServletRequest.getRequestURI() == null || !httpServletRequest.getRequestURI().contains(URI_DISABLE) && !httpServletRequest.getRequestURI().contains(URI_RESTORE) || referrer.contains(URI_DISABLE) && referrer.contains(URI_RESTORE))) {
            if (log.isDebugEnabled()) {
                log.debug("doGlobalRedirect  ==> referrer " + referrer);
            }
            httpServletResponse.sendRedirect(referrer);
            return;
        }
        if (log.isWarnEnabled()) {
            log.warn("doGlobalRedirect  ==> /");
        }
        httpServletResponse.sendRedirect(httpServletRequest.getContextPath() + "/");
    }

    public static Cookie addWarnMessage2Response(HttpServletRequest request, HttpServletResponse response, String name, String value) {
        int maxAge = 3600;
        String path = request.getContextPath();
        if (StringUtils.isEmpty((CharSequence)path)) {
            path = "/";
        }
        boolean isInsecureCookie = SecurityConfigFactory.getInstance().isInsecureCookie();
        if (log.isDebugEnabled()) {
            log.debug("setCookie " + name + ":" + value + " path : " + path + " maxAge : " + maxAge + (isInsecureCookie ? " insecure" : " secure"));
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        cookie.setPath(path);
        if (!isInsecureCookie) {
            cookie.setSecure(request.isSecure());
        }
        response.addCookie(cookie);
        return cookie;
    }

    private void removeWarnMessage2Response(HttpServletRequest request, HttpServletResponse response, String name, String value) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                cookie.setValue("");
                cookie.setMaxAge(0);
                response.addCookie(cookie);
                break;
            }
        }
    }

    private void renderLoginVM(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String user = request.getParameter("os_username");
        String pass = request.getParameter("os_password");
        String dest = request.getParameter("os_destination");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("user", user);
        context.put("pass", pass);
        context.put("dest", dest);
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/login_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderQueueVM(String username, Quota quota, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("quota= " + quota);
        }
        this.renderQueueVM(username, quota.getQueueSizes(), quota.getFreeSlots(), request, response);
    }

    private void renderQueueVM(String username, int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.renderQueueVM(username, noOfUsers, -1, request, response);
    }

    private void renderQueueVM(String username, int noOfUsers, int freeSlots, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String referrer;
        String baseurl = this.applicationProperties.getBaseUrl();
        String origin = request.getParameter(ORIGIN);
        if (!(origin != null && origin.length() != 0 || (referrer = request.getHeader("referer")) == null || referrer.contains(URI_DISABLE) || referrer.contains("/login.jsp"))) {
            if (log.isDebugEnabled()) {
                log.debug("Retrive referrer from request: " + referrer + " update latest ref");
            }
            origin = referrer;
        }
        Boolean isServiceDesk = request.getServletPath() != null && request.getServletPath().contains("/servicedesk") ? Boolean.TRUE : Boolean.FALSE;
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(ORIGIN, origin);
        context.put("baseurl", baseurl);
        context.put("applicationProperties", this.applicationProperties);
        if (isServiceDesk.booleanValue()) {
            context.put("isServiceDesk", "YES");
            context.put("redirUrl", baseurl + "/servicedesk/");
        } else {
            context.put("redirUrl", baseurl + "/secure/Dashboard.jspa");
        }
        context.put("queueSize", noOfUsers);
        if (freeSlots > 0) {
            context.put("freeSlots", freeSlots);
        }
        context.put("duration", DAO.getDuration());
        context.put("urlLogo", DAO.getUrlLogo());
        context.put("queueMessage", DAO.getQueueMessage());
        context.put("username", username);
        if (log.isDebugEnabled()) {
            log.debug("context= " + ((Object)context).toString());
        }
        response.setContentType("text/html;charset=utf-8");
        this.pageBuilderService.assembler().resources().requireWebResource("de.accxia.jira.addon.IUM.IntelligentUserManager:IUM-Check-resources");
        this.pageBuilderService.assembler().resources().requireWebResource("de.accxia.jira.addon.IUM.IntelligentUserManager:login-resources");
        this.pageBuilderService.assembler().assembled().drainIncludedResources().writeHtmlTags((Writer)response.getWriter(), UrlMode.RELATIVE);
        this.renderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }

    private boolean shouldInterceptRestRequest(HttpServletRequest request) {
        if (RestRoute.getInstance().isEmpty()) {
            return false;
        }
        String referrer = request.getHeader("referer");
        String path = request.getRequestURI();
        boolean contain = Arrays.stream(RestRoute.getInstance().getAllRestRoutes()).anyMatch(s -> path.indexOf((String)s) != -1);
        return contain;
    }

    private void doDebugRequestData(ServletRequest request, ServletResponse response) {
        try {
            Cookie[] cookies;
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (httpRequest.getQueryString() != null) {
                log.warn("QueryString=" + httpRequest.getQueryString());
            }
            for (Cookie cookie : cookies = httpRequest.getCookies()) {
                log.warn(cookie.getName() + " " + cookie.getValue());
            }
            Enumeration headerNames = httpRequest.getHeaderNames();
            if (headerNames != null) {
                while (headerNames.hasMoreElements()) {
                    String headerName = (String)headerNames.nextElement();
                    log.warn(headerName + "=" + httpRequest.getHeader(headerName));
                }
            }
            Enumeration parameterNames = httpRequest.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                log.warn(parameterName + "=" + httpRequest.getParameter(parameterName));
            }
            Enumeration attributeNames = httpRequest.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                String attributeName = (String)attributeNames.nextElement();
                log.warn(attributeName + "=" + httpRequest.getParameter(attributeName));
            }
        }
        catch (Exception e) {
            log.error("Exception: " + e.getMessage(), (Throwable)e);
        }
    }
}

