/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.job;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IUMHelperCacheService;
import de.accxia.jira.addon.IUM.job.IJob;
import de.accxia.jira.addon.IUM.job.JobData;
import de.accxia.jira.addon.IUM.job.JobSyncService;
import de.accxia.jira.addon.IUM.job.ProcessResult;
import de.accxia.jira.addon.IUM.model.NavUserDTO;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import de.accxia.jira.addon.IUM.servlet.HelperTrialProcessing;
import de.accxia.jira.addon.IUM.servlet.session.AccxiaUserSessionTracker;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMClusterJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMClusterJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMClusterJob instance;
    private HelperTrialProcessing helperTrialProcessing;
    private PocketRepository pocketRepository;
    private JobResultRepository jobResultRepository;
    private JobSyncService jobSyncService;

    private IUMClusterJob() {
    }

    public static IUMClusterJob getInstance() {
        if (instance == null) {
            instance = new IUMClusterJob();
        }
        return instance;
    }

    @Override
    public void injectService(HelperTrialProcessing helperTrialProcessing, PocketRepository pocketRepository, JobResultRepository jobResultRepository) {
        IUMClusterJob.instance.helperTrialProcessing = helperTrialProcessing;
        IUMClusterJob.instance.pocketRepository = pocketRepository;
        IUMClusterJob.instance.jobResultRepository = jobResultRepository;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) throws RemoveException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMSyncJob Process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        long inactivityInterval = (Long)parameters.get("inactivity_interval");
        if (inactivityInterval <= 0L) {
            inactivityInterval = JobData.DEFAULT_USER_INACTIVITY_INTERVAL;
        }
        String enableGroups = DAO.getIUMGroups();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMClusterJob Process with groups={} interval={} at [ {} ] ", new Object[]{enableGroups, inactivityInterval, SDF.format(new Date())});
        }
        ProcessResult processResult = new ProcessResult("CleanJob", (String)((Object)parameters.get("enable_groups")), (String)((Object)parameters.get("disable_groups")));
        if (this.pocketRepository != null) {
            String[] arrayEnableGroups = IUMClusterJob.isEmpty(enableGroups) ? null : enableGroups.split(",");
            Timestamp ts = new Timestamp(new Date().getTime() - inactivityInterval);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("IUMClusterJob Process with groups={} interval={} at [ {} ] ", new Object[]{enableGroups, inactivityInterval, SDF.format(new Date())});
            }
            GroupManager groupManager = ComponentAccessor.getGroupManager();
            UserManager userManager = ComponentAccessor.getUserManager();
            UserUtil userUtil = ComponentAccessor.getUserUtil();
            HashMap<String, List<NavUserDTO>> usersEnabled = new HashMap<String, List<NavUserDTO>>();
            long now = new Date().getTime();
            if (arrayEnableGroups != null) {
                AccxiaUserSessionTracker accxiaUserSessionTracker = AccxiaUserSessionTracker.getInstance();
                for (String group : arrayEnableGroups) {
                    int count = groupManager.getUsersInGroupCount(group);
                    int cnt = 100;
                    if (count == 0) {
                        count = cnt;
                    }
                    for (int i = 0; i < count; i += cnt) {
                        List<NavUserDTO> oldestUsers = this.pocketRepository.getNavUserDisableForGroupLtTime(group, ts, i, cnt);
                        for (NavUserDTO oldestUser : oldestUsers) {
                            this.doAddUserActive(oldestUser, group, usersEnabled);
                        }
                    }
                }
                processResult.setUserRemoved(0L);
                for (Map.Entry entry : usersEnabled.entrySet()) {
                    if (((List)entry.getValue()).size() > 0) {
                        for (NavUserDTO navUser : (List)entry.getValue()) {
                            if (navUser.getGroupNameEx() == null) continue;
                            try {
                                userUtil.removeUserFromGroup(groupManager.getGroup(navUser.getGroupNameEx()), userManager.getUserByName((String)entry.getKey()));
                                IUMHelperCacheService.getInstance().addUserToRemovalCache((String)entry.getKey());
                                processResult.setUserRemoved(processResult.getUserRemoved() + 1L);
                                if (!this.LOG.isInfoEnabled()) continue;
                                this.LOG.info("IUMClusterJob removed user {} from group {} ", new Object[]{entry.getKey(), navUser.getGroupNameEx()});
                            }
                            catch (Exception e) {
                                this.LOG.error("Exception[removeUserFromGroup]: " + e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    for (NavUserDTO navUser : (List)entry.getValue()) {
                        if (navUser.getID() == null || navUser.getUserName() == null || navUser.getSessionId() == null) continue;
                        try {
                            if (this.LOG.isInfoEnabled()) {
                                this.LOG.info("IUMJob markSessionAsInvalid user {} from sessionId {} ", new Object[]{navUser.getUserName(), navUser.getSessionId()});
                            }
                            accxiaUserSessionTracker.markSessionAsInvalid(navUser.getSessionId());
                        }
                        catch (Exception e) {
                            this.LOG.error("Exception[markSessionAsInvalid]: " + e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMClusterJob Processed #[" + SDF.format(new Date()) + "] ");
        }
        processResultList.add(processResult);
        return processResultList;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    private void doAddUserActive(NavUserDTO navUser, String group, Map<String, List<NavUserDTO>> usersEnabled) {
        String userName;
        String string = userName = navUser.getUserName() == null ? navUser.getUserNameEx() : navUser.getUserName();
        if (userName != null) {
            if (navUser.getGroupNameEx() == null) {
                navUser.setGroupNameEx(group);
            }
            if (!usersEnabled.containsKey(userName)) {
                usersEnabled.put(userName, new ArrayList());
            }
            List<NavUserDTO> userActiveList = usersEnabled.get(userName);
            userActiveList.add(navUser);
        }
    }
}

