/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.job;

import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;
import de.accxia.jira.addon.IUM.job.IUMDailyJob;
import de.accxia.jira.addon.IUM.job.JobDataUtils;
import de.accxia.jira.addon.IUM.job.MonitorJobRunner;
import de.accxia.jira.addon.IUM.model.JobResult;
import de.accxia.jira.addon.IUM.model.JobResultDTO;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={JobDailyService.class})
@Named(value="JobDailyService")
public class JobDailyService {
    private static final Logger LOG = LoggerFactory.getLogger(JobDailyService.class);
    private final MonitorJobRunner monitorJobRunner;
    private final JobResultRepository jobResultRepository;
    private final ApplicationRoleManager applicationRoleManager;
    private static UserUtil userUtil = ComponentAccessor.getUserUtil();

    @Inject
    public JobDailyService(MonitorJobRunner monitorJobRunner, JobResultRepository jobResultRepository, ApplicationRoleManager applicationRoleManager) {
        this.monitorJobRunner = monitorJobRunner;
        this.jobResultRepository = jobResultRepository;
        this.applicationRoleManager = applicationRoleManager;
    }

    public boolean start() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JobDailyService call start");
            }
            this.monitorJobRunner.doUnSchedule(IUMDailyJob.class);
            this.monitorJobRunner.doSchedule(JobDataUtils.createIUMDailyJobData(), IUMDailyJob.getInstance());
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean stop() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JobDailyService doStop");
            }
            this.monitorJobRunner.doUnSchedule(IUMDailyJob.class);
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean isWorking() {
        return this.monitorJobRunner.isWorking(IUMDailyJob.class);
    }

    public JobDetails getJobDetails() {
        return this.monitorJobRunner.getJobDetails(IUMDailyJob.class);
    }

    public Date getNextRunDate() {
        return this.monitorJobRunner.getNextRunDate(IUMDailyJob.class);
    }

    public RunDetails getLastSuccessfulRunForJob() {
        return this.monitorJobRunner.getLastSuccessfulRunForJob(IUMDailyJob.class);
    }

    public List<JobResultDTO> findLatest(int idx, int ctx) {
        JobResult[] jobResults = this.jobResultRepository.findAll(idx, ctx);
        List<JobResultDTO> jobResultDTOList = Arrays.stream(jobResults).map(jobResult -> JobResultDTO.fromAO(jobResult)).collect(Collectors.toList());
        return jobResultDTOList;
    }
}

