/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.annotations.security.UnlicensedSiteAccess;
import de.accxia.jira.addon.IUM.servlet.session.AccxiaUserSessionTracker;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@UnlicensedSiteAccess
public class AccessLogFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AccessLogFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("AccessLogFilter initialized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        try {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        finally {
            try {
                AccxiaUserSessionTracker.recordInteraction(httpServletRequest);
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void destroy() {
    }
}

