/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.annotations.security.UnlicensedSiteAccess;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.permission.PermissionSchemeEntry;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.component.ComponentLocator;
import de.accxia.jira.addon.IUM.agents.AgentResultsResponse;
import de.accxia.jira.addon.IUM.agents.AgentWorkload;
import de.accxia.jira.addon.IUM.agents.AgentWorkloadImpl;
import de.accxia.jira.addon.IUM.utils.ParseUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.util.ContentCachingResponseWrapper;

@Component
@UnlicensedSiteAccess
public class IUMRestSDFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(IUMRestSDFilter.class);
    private AgentWorkload agentWorkload;
    @ComponentImport
    private final PluginAccessor pluginAccessor;
    public static final String AGENTS = "/rest/servicedesk/([\\d\\w]+)/pages/people/agents/([\\d\\w]+)/search";
    public static final Pattern PATTERN_AGENTS = Pattern.compile("/rest/servicedesk/([\\d\\w]+)/pages/people/agents/([\\d\\w]+)/search");
    private PermissionSchemeManager permissionSchemeManager;
    private ProjectRoleManager projectRoleManager;
    private ProjectManager projectManager;

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("IUMRestSDFilter initialized.");
    }

    public boolean isServiceDeskInstalled(PluginAccessor pluginAccessor) {
        Plugin serviceDeskPlugin = pluginAccessor.getPlugin("com.atlassian.servicedesk");
        return serviceDeskPlugin != null && serviceDeskPlugin.getPluginState() == PluginState.ENABLED;
    }

    @Inject
    public IUMRestSDFilter(ApplicationProperties applicationProperties, ProjectManager projectManager, IssueManager issueManager, PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
        this.permissionSchemeManager = ComponentAccessor.getPermissionSchemeManager();
        this.projectRoleManager = (ProjectRoleManager)ComponentAccessor.getComponent(ProjectRoleManager.class);
        this.projectManager = ComponentAccessor.getProjectManager();
        try {
            this.agentWorkload = (AgentWorkload)ComponentLocator.getComponent(AgentWorkload.class);
            if (this.isServiceDeskInstalled(pluginAccessor) && this.agentWorkload == null) {
                ComponentManager.getInstance().registerComponent(AgentWorkload.class, AgentWorkloadImpl.class);
                this.agentWorkload = (AgentWorkload)ComponentLocator.getComponent(AgentWorkload.class);
            }
        }
        catch (Throwable e) {
            LOG.error("Throwable " + e.getMessage(), e);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        try {
            if (StringUtils.isEmpty((CharSequence)httpServletRequest.getRequestURI())) {
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
            Matcher matcherAgents = PATTERN_AGENTS.matcher(httpServletRequest.getRequestURI());
            if (matcherAgents.matches()) {
                String projectKey = matcherAgents.groupCount() >= 2 ? matcherAgents.group(2) : "";
                String query = httpServletRequest.getParameter("query");
                String searchAll = httpServletRequest.getParameter("searchAll");
                ContentCachingResponseWrapper responseWrapper = new ContentCachingResponseWrapper((HttpServletResponse)servletResponse);
                filterChain.doFilter(servletRequest, (ServletResponse)responseWrapper);
                this.doAddAgents(projectKey, query, ParseUtil.safeParseBoolean(searchAll, Boolean.FALSE), responseWrapper, servletResponse);
                return;
            }
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    private void doAddAgents(String projectKey, String query, Boolean searchAll, ContentCachingResponseWrapper responseWrapper, ServletResponse servletResponse) throws IOException {
        byte[] originalData = responseWrapper.getContentAsByteArray();
        String newData = new String(originalData);
        Project project = this.projectManager.getProjectByCurrentKey(projectKey);
        Pair<Set<String>, Set<String>> allowGroups4ProjectPermissionKey = this.getGroups4ProjectPermissionKey(project, ProjectPermissions.VIEW_VOTERS_AND_WATCHERS);
        AgentResultsResponse disableAgents = this.agentWorkload.searchAgentWorkloadForProject(query, searchAll, projectKey, (Set)allowGroups4ProjectPermissionKey.getLeft(), (Set)allowGroups4ProjectPermissionKey.getRight());
        AgentResultsResponse enabledAgents = this.agentWorkload.fromString(newData);
        this.agentWorkload.mergeAgentResultsResponse(enabledAgents, disableAgents);
        newData = this.agentWorkload.toString(enabledAgents);
        servletResponse.setContentLength(newData.length());
        servletResponse.getOutputStream().write(newData.getBytes());
        servletResponse.getOutputStream().flush();
    }

    private Pair<Set<String>, Set<String>> getGroups4ProjectPermissionKey(Project project, ProjectPermissionKey projectPermissionKey) {
        if (project == null) {
            LOG.info("No project found ");
            return Pair.of((Object)Collections.EMPTY_SET, (Object)Collections.EMPTY_SET);
        }
        Scheme permissionScheme = this.permissionSchemeManager.getSchemeFor(project);
        if (permissionScheme == null) {
            LOG.info("No permission scheme found for project: " + project.getKey());
            return Pair.of((Object)Collections.EMPTY_SET, (Object)Collections.EMPTY_SET);
        }
        Collection permissionEntities = this.permissionSchemeManager.getPermissionSchemeEntries(permissionScheme, projectPermissionKey);
        HashSet<String> setGroups = new HashSet<String>();
        HashSet<String> setUsers = new HashSet<String>();
        for (PermissionSchemeEntry entity : permissionEntities) {
            Long roleId;
            ProjectRole projectRole;
            LOG.debug("entity.getType(): " + entity.getType());
            if (entity.getType().equals("group")) {
                setGroups.add(entity.getParameter());
                LOG.info("Group " + entity.getParameter() + " has Assign Issues permission on project " + project.getKey());
            }
            if (!entity.getType().equals("projectrole") || (projectRole = this.projectRoleManager.getProjectRole(roleId = Long.valueOf(Long.parseLong(entity.getParameter())))) == null) continue;
            Set roleActors = this.projectRoleManager.getProjectRoleActors(projectRole, project).getRoleActors();
            for (RoleActor roleActor : roleActors) {
                if (roleActor.getType().equals("atlassian-group-role-actor")) {
                    setGroups.add(roleActor.getParameter());
                }
                if (!roleActor.getType().equals("atlassian-user-role-actor")) continue;
                setUsers.add(roleActor.getParameter());
            }
        }
        return Pair.of(setUsers, setGroups);
    }

    public void destroy() {
    }
}

