/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.job;

import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.jira.addon.IUM.config.DBEngine;
import de.accxia.jira.addon.IUM.config.ResultOperation;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/generator")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Component
public class GeneratorController {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratorController.class);
    @ComponentImport
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final DBEngine dbEngine;
    private final DefaultOfBizConnectionFactory connectionFactory = DefaultOfBizConnectionFactory.getInstance();

    public GeneratorController(JiraAuthenticationContext jiraAuthenticationContext, DBEngine dbEngine) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.dbEngine = dbEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/indexes")
    @GET
    @Produces(value={"application/json"})
    public Response indexesGenerator() throws SQLException {
        String databaseType = this.connectionFactory.getDatasourceInfo().getDatabaseTypeFromJDBCConnection().getName().toUpperCase();
        LOG.info("database type is " + databaseType);
        StringBuffer sb = new StringBuffer();
        try (Connection connection = this.connectionFactory.getConnection();){
            DatabaseMetaData md = connection.getMetaData();
            LOG.info("database major version is " + md.getDatabaseMajorVersion());
            try (ResultSet tableRS = md.getTables(null, null, "%", null);){
                while (tableRS.next()) {
                    String catalog = tableRS.getString(1);
                    String schema = tableRS.getString(2);
                    String name = tableRS.getString(3);
                    String type = tableRS.getString(4);
                    if (type == null || !type.equalsIgnoreCase("TABLE")) continue;
                    sb.append("Table: " + name + "\n");
                    ResultSet indexRS = md.getIndexInfo(catalog, schema, name, false, false);
                    while (indexRS.next()) {
                        sb.append("Index: " + indexRS.getString("INDEX_NAME") + "\n");
                    }
                }
            }
            catch (SQLException e) {
                LOG.error("Error while getting database metadata" + e.getMessage(), (Throwable)e);
                Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error while getting database metadata").build();
                connection.close();
                return response;
            }
        }
        return Response.ok((Object)sb.toString()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/runner")
    @GET
    @Produces(value={"application/json"})
    public Response sqlRunner(@QueryParam(value="sql") String sql) throws SQLException {
        StringBuffer sb = new StringBuffer();
        if (null != sql && !sql.isEmpty()) {
            try (Connection connection = this.connectionFactory.getConnection();){
                LOG.debug("SQL - " + sql);
                sb.append(sql);
                Statement stmt = connection.createStatement();
                if (!stmt.execute(sql)) {
                    sb.append("ResultType:" + stmt.getResultSetType());
                    sb.append("UpdateCount:" + stmt.getUpdateCount());
                } else {
                    sb.append("ResultType:" + stmt.getResultSetType());
                    ResultSet resultSet = stmt.getResultSet();
                    ResultSetMetaData rsm = resultSet.getMetaData();
                    int columnCount = rsm.getColumnCount();
                    for (int nCol = 1; nCol <= columnCount; ++nCol) {
                        sb.append("Column:" + rsm.getColumnName(nCol));
                    }
                    while (resultSet.next()) {
                        ArrayList<String> row = new ArrayList<String>();
                        for (int nCol = 1; nCol <= columnCount; ++nCol) {
                            row.add(String.valueOf(resultSet.getObject(nCol)));
                        }
                        sb.append("Row:" + String.join((CharSequence)", ", row));
                    }
                    resultSet.close();
                }
                Response response = Response.ok((Object)sb.toString()).build();
                return response;
            }
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Bad request, probably sql parameter missing ").build();
    }

    @Path(value="/dbinfo")
    @GET
    @Produces(value={"application/json"})
    public Response getDatabaseInfo() throws SQLException {
        try {
            return Response.ok((Object)this.dbEngine.getDatabaseInfo()).build();
        }
        catch (SQLException e) {
            LOG.error("Error while getting database metadata" + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error while getting database metadata").build();
        }
    }

    @Path(value="/createIndexes")
    @POST
    @Produces(value={"application/json"})
    public Response createIndexes() throws SQLException {
        try {
            ResultOperation resultOperation = this.dbEngine.createIndexes();
            return Response.ok((Object)resultOperation).build();
        }
        catch (Exception e) {
            LOG.error("Error while created indexes " + e.getMessage(), (Throwable)e);
            ResultOperation resultOperation = new ResultOperation(false, "Error while created indexes " + e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)resultOperation).build();
        }
    }

    @Path(value="/dropIndexes")
    @POST
    @Produces(value={"application/json"})
    public Response dropIndexes() throws SQLException {
        try {
            ResultOperation resultOperation = this.dbEngine.dropIndexes();
            return Response.ok((Object)resultOperation).build();
        }
        catch (Exception e) {
            LOG.error("Error while dropped indexes " + e.getMessage(), (Throwable)e);
            ResultOperation resultOperation = new ResultOperation(false, "Error while dropped indexes " + e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)resultOperation).build();
        }
    }
}

