/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.cache.request.RequestCache;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.google.common.collect.ImmutableSet;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.CurrentUser;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.saml.SAMLHelper;
import de.accxia.jira.addon.IUM.servlet.filter.AccxiaResponseWrapper;
import de.accxia.jira.addon.IUM.servlet.filter.XSSHttpServletRequestWrapper;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@UnrestrictedAccess
public class IntelligentUserManagerSAMLFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(IntelligentUserManagerSAMLFilter.class);
    @ComponentImport
    private static PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private static ApplicationProperties applicationProperties;
    @ComponentImport
    private static TemplateRenderer renderer;
    private static UserManager userManagerJira;
    private static final GroupManager groupManager;

    @Inject
    public IntelligentUserManagerSAMLFilter(PluginLicenseManager pluginLicenseManager, ApplicationProperties applicationProperties, TemplateRenderer renderer) {
        IntelligentUserManagerSAMLFilter.pluginLicenseManager = pluginLicenseManager;
        IntelligentUserManagerSAMLFilter.applicationProperties = applicationProperties;
        IntelligentUserManagerSAMLFilter.renderer = renderer;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ApplicationUser theUser;
        String user;
        if (!ConditionEvaluatorImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        if ("".equals(DAO.getSamlIdp())) {
            chain.doFilter(request, response);
            return;
        }
        XSSHttpServletRequestWrapper xssRequest = new XSSHttpServletRequestWrapper((HttpServletRequest)request);
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String samlPar = xssRequest.getParameter("SAMLResponse");
        if (log.isDebugEnabled()) {
            log.info("SAML SAMLResponse: " + samlPar);
        }
        if ((user = SAMLHelper.getSAMLUserFromSAMLResponse(samlPar)) == null) {
            chain.doFilter((ServletRequest)xssRequest, response);
            return;
        }
        if (log.isDebugEnabled()) {
            log.info("SAML user: " + user);
        }
        ApplicationUser applicationUser = userManagerJira.getUserByName(user);
        String myRedirLocation = "/";
        if (applicationUser == null) {
            AccxiaResponseWrapper myWrapper = new AccxiaResponseWrapper(httpResponse);
            chain.doFilter((ServletRequest)xssRequest, (ServletResponse)myWrapper);
            myRedirLocation = myWrapper.getRedirectLocation();
            applicationUser = userManagerJira.getUserByName(user);
            IntelligentUserManagerHelper.moveUserToDisabled(applicationUser);
            httpResponse.sendRedirect(DAO.getSamlIdp());
            return;
        }
        if (IntelligentUserManagerHelper.isUserInGroups(applicationUser, DAO.getIUMGroups())) {
            chain.doFilter((ServletRequest)xssRequest, response);
            return;
        }
        if (!IntelligentUserManagerHelper.isUserInGroups(applicationUser, DAO.getIUMGroupsDisabled())) {
            chain.doFilter((ServletRequest)xssRequest, response);
            return;
        }
        CurrentUser currentUser = IntelligentUserManagerHelper.enableUserFromGroup(user, (HttpServletRequest)xssRequest);
        if (currentUser != null && (theUser = currentUser.user) != null) {
            xssRequest.getSession().setAttribute("IUMUSER", (Object)theUser.getUsername());
            xssRequest.getSession().setAttribute("seraph_defaultauthenticator_user", (Object)theUser);
            xssRequest.getSession().setAttribute("seraph_defaultauthenticator_logged_out_user", null);
            xssRequest.setAttribute("os_authstatus", "success");
            xssRequest.setAttribute("loginfilter.already.filtered", Boolean.TRUE);
            httpResponse.sendRedirect(DAO.getSamlIdp());
            return;
        }
        this.renderQueueVM(currentUser.noOfUsers, (HttpServletRequest)xssRequest, httpResponse);
    }

    public static boolean performAction4UserToEnabledGroup(String userName, boolean added) {
        String groupEnabled = DAO.getIUMGroups();
        String groupDisabled = DAO.getIUMGroupsDisabled();
        if (groupEnabled == null || groupDisabled == null) {
            return false;
        }
        boolean retVal = false;
        ApplicationUser user = userManagerJira.getUserByName(userName);
        String[] groupsEnabled = groupEnabled.split(",");
        String[] groupsDisabled = groupDisabled.split(",");
        for (int i = 0; i < groupsDisabled.length; ++i) {
            if (!groupManager.isUserInGroup(userName, groupsDisabled[i])) continue;
            Group theEnabledGroup = groupManager.getGroup(groupsEnabled[i]);
            Group theDisableGroup = groupManager.getGroup(groupsDisabled[i]);
            Field field = null;
            try {
                field = FieldUtils.getField(groupManager.getClass(), (String)"usernameToGroupNamesInLowerCase", (boolean)true);
                field.setAccessible(true);
                RequestCache usernameToGroupNamesInLowerCase = (RequestCache)field.get(groupManager);
                HashSet<String> existingUsernameToGroupNames = new HashSet<String>((Collection)usernameToGroupNamesInLowerCase.get((Object)userName));
                if (added) {
                    existingUsernameToGroupNames.add(groupsEnabled[i]);
                } else {
                    existingUsernameToGroupNames.remove(groupsEnabled[i]);
                }
                ImmutableSet grp3 = new ImmutableSet.Builder().addAll(existingUsernameToGroupNames).build();
                usernameToGroupNamesInLowerCase.remove((Object)user.getUsername());
                usernameToGroupNamesInLowerCase.get((Object)user.getUsername(), () -> IntelligentUserManagerSAMLFilter.lambda$performAction4UserToEnabledGroup$0((Set)grp3));
                retVal = true;
            }
            catch (IllegalAccessException e) {
                log.error("Exception " + e.getMessage(), (Throwable)e);
                return false;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Verify Move[simulate] {} isIumEnabled={}  isIumDisabled={} ", new Object[]{user.getUsername(), IntelligentUserManagerHelper.isUserInGroups(user, groupsEnabled[i]), IntelligentUserManagerHelper.isUserInGroups(user, groupsDisabled[i])});
        }
        return retVal;
    }

    private void renderQueueVM(int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("duration", DAO.getDuration());
        context.put("queueSize", noOfUsers);
        context.put("redirUrl", DAO.getSamlIdp());
        context.put("urlLogo", DAO.getUrlLogo());
        context.put("queueMessage", DAO.getQueueMessage());
        context.put("baseurl", applicationProperties.getBaseUrl(UrlMode.ABSOLUTE));
        response.setContentType("text/html;charset=utf-8");
        renderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }

    private static /* synthetic */ Set lambda$performAction4UserToEnabledGroup$0(Set grp3) {
        return grp3;
    }

    static {
        userManagerJira = ComponentAccessor.getUserManager();
        groupManager = ComponentAccessor.getGroupManager();
    }
}

