/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.job;

import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerHistoryService;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;
import com.atlassian.scheduler.status.RunOutcome;
import de.accxia.jira.addon.IUM.job.IJob;
import de.accxia.jira.addon.IUM.job.IUMRunTimeCalculator;
import de.accxia.jira.addon.IUM.job.JobData;
import de.accxia.jira.addon.IUM.job.MonitorJobRunner;
import de.accxia.jira.addon.IUM.job.ProcessResult;
import de.accxia.jira.addon.IUM.model.JobResultDTO;
import de.accxia.jira.addon.IUM.repository.IUMAlertRepository;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import de.accxia.jira.addon.IUM.repository.NavUserRepository;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import de.accxia.jira.addon.IUM.servlet.HelperTrialProcessing;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={MonitorJobRunnerImpl.class})
@Named(value="monitorJobRunner")
public class MonitorJobRunnerImpl
implements MonitorJobRunner {
    private Logger LOG = LoggerFactory.getLogger(MonitorJobRunnerImpl.class);
    public static final String JOB_ID = "JOB_ID";
    private final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)MonitorJobRunnerImpl.class.getName());
    private final ConcurrentHashMap<JobId, JobRunnerKeyDetail> map;
    @ComponentImport
    private final SchedulerService schedulerService;
    @ComponentImport
    private final SchedulerHistoryService schedulerHistoryService;
    @ComponentImport
    private final JiraLicenseManager jiraLicenseManager;
    @ComponentImport
    private final ApplicationRoleManager applicationRoleManager;
    private final IUMRunTimeCalculator iumRunTimeCalculator;
    private PocketRepository pocketRepository;
    private JobResultRepository jobResultRepository;
    private NavUserRepository navUserRepository;
    private final IUMAlertRepository alertRepository;
    private final HelperTrialProcessing helperTrialProcessing;

    @Inject
    public MonitorJobRunnerImpl(SchedulerService schedulerService, SchedulerHistoryService schedulerHistoryService, ApplicationRoleManager applicationRoleManager, IUMRunTimeCalculator iumRunTimeCalculator, NavUserRepository navUserRepository, PocketRepository pocketRepository, JobResultRepository jobResultRepository, JiraLicenseManager jiraLicenseManager, IUMAlertRepository alertRepository, HelperTrialProcessing helperTrialProcessing) {
        this.schedulerService = schedulerService;
        this.schedulerHistoryService = schedulerHistoryService;
        this.applicationRoleManager = applicationRoleManager;
        this.iumRunTimeCalculator = iumRunTimeCalculator;
        this.jiraLicenseManager = jiraLicenseManager;
        this.alertRepository = alertRepository;
        this.helperTrialProcessing = helperTrialProcessing;
        this.map = new ConcurrentHashMap();
        this.navUserRepository = navUserRepository;
        this.pocketRepository = pocketRepository;
        this.jobResultRepository = jobResultRepository;
    }

    @Override
    public String doSchedule(JobData jobData, final IJob job) throws SchedulerServiceException {
        boolean isStartingNow;
        JobId jobId = JobId.of((String)job.getClass().getName());
        JobRunnerKeyDetail jobRunnerKeyDetail = this.getOrCreateJob(jobId);
        job.injectService(this.helperTrialProcessing, this.pocketRepository, this.jobResultRepository);
        job.injectService(this.applicationRoleManager);
        job.injectService(this.alertRepository);
        job.injectService(this.jiraLicenseManager);
        this.schedulerService.registerJobRunner(jobRunnerKeyDetail.jobRunnerKey, new JobRunner(){

            @Nullable
            public JobRunnerResponse runJob(JobRunnerRequest jobRequest) {
                try {
                    if (MonitorJobRunnerImpl.this.LOG.isInfoEnabled()) {
                        MonitorJobRunnerImpl.this.LOG.info("Begin ProcessingJob at " + new Date());
                    }
                    MonitorJobRunnerImpl.this.doProcessingJob(job, jobRequest.getJobConfig().getParameters());
                    if (MonitorJobRunnerImpl.this.LOG.isInfoEnabled()) {
                        MonitorJobRunnerImpl.this.LOG.info("End ProcessingJob at " + new Date());
                    }
                }
                catch (Exception e) {
                    MonitorJobRunnerImpl.this.LOG.error("Exception ProcessingJob: " + e.getMessage(), (Throwable)e);
                    return JobRunnerResponse.aborted((String)("Task aborted due to the following error : " + e.getMessage()));
                }
                return JobRunnerResponse.success();
            }
        });
        jobData.getParameters().put(JOB_ID, (Serializable)((Object)jobId.toString()));
        Date firstRunTime = null;
        boolean bl = isStartingNow = jobData.getParameters().get("start_immediate") != null && jobData.getParameters().get("start_immediate") instanceof Boolean && (Boolean)jobData.getParameters().get("start_immediate") != false;
        if (isStartingNow) {
            firstRunTime = this.createStartNowRunDate(jobData.getRepeatInterval());
        } else if (jobData.getCronExpression() == null) {
            firstRunTime = jobData.getParameters().get("restart") != null ? this.createNextRunDate(jobData.getRepeatInterval(), jobData.getStartingFrom()) : this.createFirstRunDate(jobData.getRepeatInterval(), jobData.getStartingFrom());
        }
        Schedule schedule = null;
        if (jobData.getCronExpression() != null) {
            schedule = Schedule.forCronExpression((String)jobData.getCronExpression(), (TimeZone)TimeZone.getDefault());
            jobRunnerKeyDetail.currentRunDate = null;
            jobRunnerKeyDetail.nextRunDate = this.schedulerService.calculateNextRunTime(schedule);
        } else {
            schedule = Schedule.forInterval((long)jobData.getRepeatInterval(), (Date)firstRunTime);
            if (isStartingNow) {
                jobRunnerKeyDetail.currentRunDate = new Date();
                jobRunnerKeyDetail.nextRunDate = this.iumRunTimeCalculator.nextRunTime(schedule, new Date(System.currentTimeMillis() + jobData.getRepeatInterval()));
            } else {
                jobRunnerKeyDetail.currentRunDate = null;
                jobRunnerKeyDetail.nextRunDate = this.schedulerService.calculateNextRunTime(schedule);
            }
        }
        boolean runOncePerCluster = jobData.getParameters().get("run_once_per_cluster") != null && jobData.getParameters().get("run_once_per_cluster") instanceof Boolean && (Boolean)jobData.getParameters().get("run_once_per_cluster") != false;
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKeyDetail.jobRunnerKey).withRunMode(runOncePerCluster ? RunMode.RUN_ONCE_PER_CLUSTER : RunMode.RUN_LOCALLY).withParameters(jobData.getParameters()).withSchedule(schedule);
        try {
            this.schedulerService.scheduleJob(jobId, jobConfig);
            this.LOG.warn("Job schedule with id =" + jobId.toString());
            return jobRunnerKeyDetail.jobRunnerKey.toString();
        }
        catch (Exception e) {
            this.LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new SchedulerServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void doUnSchedule(Class classz) throws SchedulerServiceException {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            this.LOG.warn("Stopping..." + jobRunnerKeyDetail.jobRunnerKey);
            this.schedulerService.unscheduleJob(jobId);
            this.getOrCreateJob((JobId)jobId).nextRunDate = null;
        }
    }

    @Override
    public JobDetails getJobDetails(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            return this.schedulerService.getJobDetails(jobId);
        }
        return null;
    }

    @Override
    public Date getNextRunDate(Class classz) {
        try {
            JobId jobId = JobId.of((String)classz.getName());
            if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
                JobDetails jobDetails = this.schedulerService.getJobDetails(jobId);
                if (jobDetails == null) {
                    return null;
                }
                long firedAt = System.currentTimeMillis();
                JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
                if (jobDetails.getNextRunTime() != null && jobDetails.getNextRunTime().getTime() < firedAt) {
                    return jobRunnerKeyDetail.nextRunDate;
                }
                return jobDetails.getNextRunTime();
            }
        }
        catch (Exception e) {
            this.LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public Date calculateNextRunTime(Class classz, long repeatInterval) {
        try {
            JobId jobId = JobId.of((String)classz.getName());
            if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
                JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
                Date refDate = new Date(System.currentTimeMillis() + repeatInterval);
                return this.iumRunTimeCalculator.nextRunTime(this.schedulerService.getJobDetails(jobId).getSchedule(), refDate);
            }
        }
        catch (Exception e) {
            this.LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public void updateLastRunTime(Class classz, long timestamp) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            jobRunnerKeyDetail.currentRunDate = new Date(timestamp);
        }
    }

    @Override
    public RunDetails getLastRunForJob(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            return new RunDetails(){

                @Nonnull
                public Date getStartTime() {
                    return new Date();
                }

                public long getDurationInMillis() {
                    return 0L;
                }

                @Nonnull
                public RunOutcome getRunOutcome() {
                    return null;
                }

                @Nonnull
                public String getMessage() {
                    return "";
                }
            };
        }
        return null;
    }

    @Override
    public RunDetails getLastSuccessfulRunForJob(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            return new RunDetails(){

                @Nonnull
                public Date getStartTime() {
                    return new Date();
                }

                public long getDurationInMillis() {
                    return 0L;
                }

                @Nonnull
                public RunOutcome getRunOutcome() {
                    return null;
                }

                @Nonnull
                public String getMessage() {
                    return "";
                }
            };
        }
        return null;
    }

    @Override
    public boolean isWorking(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            return jobRunnerKeyDetail.nextRunDate != null;
        }
        return false;
    }

    @Override
    public List<JobDetails> getJobsByJobRunnerKey(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            return this.schedulerService.getJobsByJobRunnerKey(jobRunnerKeyDetail.jobRunnerKey);
        }
        return Collections.EMPTY_LIST;
    }

    private void doProcessingJob(IJob job, Map<String, Serializable> parameters) throws PermissionException, RemoveException {
        if (job != null) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("ProcessingJob parameters ");
                for (Map.Entry<String, Serializable> parameter : parameters.entrySet()) {
                    this.LOG.debug("key: " + parameter.getKey() + " = " + parameter.getValue());
                }
            }
            long startTime = System.currentTimeMillis();
            String className = (String)((Object)parameters.get(JOB_ID));
            JobId jobId = JobId.of((String)className);
            job.injectService(this.helperTrialProcessing, this.pocketRepository, this.jobResultRepository);
            job.injectService(this.jiraLicenseManager);
            List<ProcessResult> processResultList = job.doProcessingJob(parameters);
            long stopTime = System.currentTimeMillis();
            long elapsedTime = stopTime - startTime;
            this.doSaveProcessResultList(processResultList, parameters, elapsedTime);
            Schedule schedule = this.schedulerService.getJobDetails(jobId).getSchedule();
            this.getOrCreateJob((JobId)jobId).currentRunDate = new Date(System.currentTimeMillis() + 2000L);
            if (schedule != null) {
                Date nextRunDate;
                try {
                    nextRunDate = this.iumRunTimeCalculator.nextRunTime(schedule, this.getOrCreateJob((JobId)jobId).currentRunDate);
                }
                catch (Exception e) {
                    long timeInSecs = System.currentTimeMillis();
                    nextRunDate = new Date(timeInSecs + schedule.getIntervalScheduleInfo().getIntervalInMillis());
                }
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("{} nextRunDate= {}", (Object)this.schedulerService.getJobDetails(jobId).getJobId().toString(), (Object)nextRunDate);
                }
                this.getOrCreateJob((JobId)jobId).nextRunDate = nextRunDate;
            }
        } else {
            this.LOG.warn("ProcessingJob NO JOB");
        }
    }

    private String createPlainMessage(List<ProcessResult> processResultList, long elapsedTime) {
        StringBuffer sb = new StringBuffer();
        sb.append("Status:Done").append("\n");
        for (ProcessResult processResult : processResultList) {
            sb.append(String.format("Copy From %s to %s #%d", processResult.getSourceGroups(), processResult.getTargetGroup(), processResult.getUserCopied())).append("\n");
            sb.append(String.format("Remove From %s #%d", processResult.getTargetGroup(), processResult.getUserCopied())).append("\n");
        }
        sb.append(String.format("Duration %5.1f", (double)elapsedTime / 60.0 / 1000.0)).append(" minutes");
        return sb.toString();
    }

    private void doSaveProcessResultList(List<ProcessResult> processResultList, Map<String, Serializable> parameters, long elapsedTime) {
        String currentUser = (String)((Object)parameters.get("current_user"));
        for (ProcessResult processResult : processResultList) {
            if ("MembershipJob".equalsIgnoreCase(processResult.getProcess()) && processResult.getUserCopied() == 0L && processResult.getUserRemoved() == 0L) continue;
            this.jobResultRepository.save(JobResultDTO.createJobResult(processResult, currentUser, elapsedTime));
        }
    }

    private boolean isRunning(JobId jobId) {
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            return jobRunnerKeyDetail.nextRunDate != null;
        }
        return false;
    }

    private boolean stopRunning(JobId jobId) {
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            jobRunnerKeyDetail.nextRunDate = null;
            return true;
        }
        return false;
    }

    private JobRunnerKeyDetail getOrCreateJob(String className) {
        JobId jobId = JobId.of((String)className);
        if (!this.map.containsKey(jobId) || this.map.get(jobId) == null) {
            this.map.put(jobId, new JobRunnerKeyDetail(className));
        }
        JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
        return jobRunnerKeyDetail;
    }

    private JobRunnerKeyDetail getOrCreateJob(JobId jobId) {
        if (!this.map.containsKey(jobId) || this.map.get(jobId) == null) {
            this.map.put(jobId, new JobRunnerKeyDetail(jobId.toString()));
        }
        JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
        return jobRunnerKeyDetail;
    }

    private Date createFirstRunDate(long repeatInterval, int hour) {
        Random random = new Random();
        int randomNum = (random.nextInt(3) + 3) * 1000;
        if (repeatInterval <= 300000L) {
            long currentTimeMillis = System.currentTimeMillis();
            return new Date(currentTimeMillis + (long)randomNum);
        }
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(11) >= hour) {
            calendar.set(5, calendar.get(5) + 1);
        }
        calendar.set(11, hour);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long calendarTimeMillis = calendar.getTime().getTime();
        return new Date(calendarTimeMillis + (long)randomNum);
    }

    private Date createNextRunDate(long repeatInterval, int hour) {
        Random random = new Random();
        int randomNum = (random.nextInt(3) + 3) * 1000;
        if (repeatInterval <= 300000L) {
            long currentTimeMillis = System.currentTimeMillis();
            return new Date(currentTimeMillis + (long)randomNum);
        }
        int dh = (int)(repeatInterval / 3600000L);
        Calendar calendar = Calendar.getInstance();
        int currentHour = calendar.get(11);
        while (hour < 23 && hour <= currentHour) {
            hour += dh;
        }
        if (hour > 23) {
            calendar.set(5, calendar.get(5) + 1);
        }
        calendar.set(11, hour);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long calendarTimeMillis = calendar.getTime().getTime();
        return new Date(calendarTimeMillis + (long)randomNum);
    }

    private Date createStartNowRunDate(long repeatInterval) {
        Random random = new Random();
        int randomNum = (random.nextInt(3) + 3) * 1000;
        if (repeatInterval <= 300000L) {
            long currentTimeMillis = System.currentTimeMillis();
            return new Date(currentTimeMillis + (long)randomNum);
        }
        long currentTimeMillis = System.currentTimeMillis();
        return new Date(currentTimeMillis + (long)randomNum);
    }

    class JobRunnerKeyDetail {
        public JobRunnerKey jobRunnerKey;
        public Date nextRunDate = null;
        public Date currentRunDate = null;

        public JobRunnerKeyDetail(JobRunnerKey jobRunnerKey, Date currentRunDate, Date nextRunDate) {
            this.jobRunnerKey = jobRunnerKey;
            this.currentRunDate = currentRunDate;
            this.nextRunDate = nextRunDate;
        }

        public JobRunnerKeyDetail(JobRunnerKey jobRunnerKey) {
            this(jobRunnerKey, null, null);
        }

        public JobRunnerKeyDetail(String className) {
            this.jobRunnerKey = JobRunnerKey.of((String)className);
            this.nextRunDate = null;
            this.currentRunDate = null;
        }
    }
}

