/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.caesium.cron.parser.CronExpressionParser;
import com.atlassian.scheduler.caesium.cron.rule.CronExpression;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.cron.CronSyntaxException;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.accxia.jira.addon.IUM.job.IUMRunTimeCalculator;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/cron")
@Consumes(value={"text/html"})
@Produces(value={"text/plain"})
@Component
@UnrestrictedAccess
public class CronValidator {
    private static final Logger LOG = LoggerFactory.getLogger(CronValidator.class);
    @ComponentImport
    private final SchedulerService schedulerService;
    private final IUMRunTimeCalculator iumRunTimeCalculator;

    @Inject
    public CronValidator(SchedulerService schedulerService, IUMRunTimeCalculator iumRunTimeCalculator) {
        this.schedulerService = schedulerService;
        this.iumRunTimeCalculator = iumRunTimeCalculator;
    }

    @Path(value="/validate")
    @GET
    @Produces(value={"application/json"})
    public Response validateCronExpression(@QueryParam(value="cronExpression") String cronExpression) {
        JiraAuthenticationContext jiraAuthenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
        Locale userLocale = jiraAuthenticationContext.getLocale();
        I18nHelper i18nHelper = jiraAuthenticationContext.getI18nHelper();
        if (StringUtils.isEmpty((CharSequence)cronExpression)) {
            Result result = new Result(i18nHelper.getText("scheduledjob.cron.notspecified"));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)result).build();
        }
        try {
            CronExpression cron = CronValidator.parseCronDate(cronExpression);
            Schedule schedule = Schedule.forCronExpression((String)cronExpression);
            List<Date> futureDateSchedules = this.getFutureSchedules(cronExpression, 10);
            ArrayList<FormattedDateTime> futureSchedules = new ArrayList<FormattedDateTime>(10);
            for (Date d : futureDateSchedules) {
                String formattedDate = DateFormat.getDateInstance(2, userLocale).format(d);
                String formattedTime = DateFormat.getTimeInstance(2, userLocale).format(d);
                futureSchedules.add(new FormattedDateTime(formattedDate, formattedTime));
            }
            Result result = new Result(futureSchedules);
            ObjectMapper mapper = new ObjectMapper();
            mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
            return Response.ok((Object)mapper.writeValueAsString(result)).build();
        }
        catch (CronSyntaxException e) {
            LOG.error("CronSyntaxException: " + e.getMessage(), (Throwable)e);
            Result result = new Result(i18nHelper.getText("scheduledjob.cron.invalidformat"), e.getMessage());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
        }
        catch (JsonProcessingException e) {
            return Response.serverError().build();
        }
    }

    public static CronExpression parseCronDate(String cronValue) throws CronSyntaxException {
        if (StringUtils.isEmpty((CharSequence)cronValue)) {
            throw new RuntimeException("Cron expression is empty");
        }
        try {
            CronExpression cron = CronExpressionParser.parse((String)cronValue);
            return cron;
        }
        catch (CronSyntaxException e) {
            LOG.error("CronSyntaxException: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public List<Date> getFutureSchedules(String cronExpressionValue, int limit) throws CronSyntaxException {
        return this.getFutureSchedules(cronExpressionValue, limit, null);
    }

    public List<Date> getFutureSchedules(String cronExpressionValue, int limit, Date fromDate) throws CronSyntaxException {
        if (fromDate == null) {
            fromDate = new Date();
        }
        ArrayList<Date> futureSchedules = new ArrayList<Date>(limit);
        Schedule schedule = Schedule.forCronExpression((String)cronExpressionValue);
        Date nextRunTime = this.iumRunTimeCalculator.nextRunTime(schedule, fromDate);
        while (nextRunTime != null && futureSchedules.size() < limit) {
            futureSchedules.add(nextRunTime);
            nextRunTime = this.iumRunTimeCalculator.nextRunTime(schedule, nextRunTime);
        }
        return futureSchedules;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    public static class Result {
        public List<FormattedDateTime> futureSchedules;
        public String error = null;
        public String reason = null;

        public Result() {
        }

        public Result(List<FormattedDateTime> futureSchedules) {
            this.futureSchedules = futureSchedules;
        }

        public Result(String error) {
            this.futureSchedules = new ArrayList<FormattedDateTime>();
            this.error = error;
        }

        public Result(String error, String reason) {
            this.futureSchedules = new ArrayList<FormattedDateTime>();
            this.error = error;
            this.reason = reason;
        }

        public List<FormattedDateTime> getFutureSchedules() {
            return this.futureSchedules;
        }

        public String getError() {
            return this.error;
        }

        public String getReason() {
            return this.reason;
        }

        public void setFutureSchedules(List<FormattedDateTime> futureSchedules) {
            this.futureSchedules = futureSchedules;
        }

        public void setError(String error) {
            this.error = error;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    public static class FormattedDateTime {
        public String date;
        public String time;

        public FormattedDateTime() {
        }

        public FormattedDateTime(String date, String time) {
            this.date = date;
            this.time = time;
        }

        public String getDate() {
            return this.date;
        }

        public String getTime() {
            return this.time;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public void setTime(String time) {
            this.time = time;
        }
    }
}

