/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.job;

import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.job.IJob;
import de.accxia.jira.addon.IUM.job.ProcessResult;
import de.accxia.jira.addon.IUM.model.AlertType;
import de.accxia.jira.addon.IUM.repository.IUMAlertRepository;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import de.accxia.jira.addon.IUM.servlet.HelperTrialProcessing;
import de.accxia.jira.addon.IUM.side.LicenseData;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMDailyEventJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMDailyEventJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMDailyEventJob instance;
    private JobResultRepository jobResultRepository;
    private PocketRepository pocketRepository;
    private HelperTrialProcessing helperTrialProcessing;
    private IUMAlertRepository iumAlertRepository;
    int syncUsers = 0;

    public static IUMDailyEventJob getInstance() {
        if (instance == null) {
            instance = new IUMDailyEventJob();
        }
        return instance;
    }

    @Override
    public void injectService(HelperTrialProcessing helperTrialProcessing, PocketRepository pocketRepository, JobResultRepository jobResultRepository) {
        IUMDailyEventJob.instance.helperTrialProcessing = helperTrialProcessing;
        IUMDailyEventJob.instance.pocketRepository = pocketRepository;
        IUMDailyEventJob.instance.jobResultRepository = jobResultRepository;
    }

    @Override
    public void injectService(IUMAlertRepository iumAlertRepository) {
        this.iumAlertRepository = iumAlertRepository;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMDailyEventJob Process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        Date currentDate = new Date();
        LicenseData licenseData = ConditionEvaluatorImpl.getSideLicense();
        if (licenseData != null && licenseData.getDueDate() != null) {
            long diffInMillies = licenseData.getDueDate().getTime() - currentDate.getTime();
            long diff = TimeUnit.DAYS.convert(diffInMillies, TimeUnit.MILLISECONDS);
            if (diff >= 0L && diff < 30L) {
                this.helperTrialProcessing.markLicenseExpireError(AlertType.ALERT_LICENSE_EXPIRE, diff);
            }
            if (diff < 0L) {
                this.helperTrialProcessing.markLicenseExpireError(AlertType.ALERT_LICENSE_EXPIRE, diff);
            }
        }
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info("IUMDailyEventJob Processed #[" + SDF.format(new Date()) + "]");
        }
        return processResultList;
    }
}

