/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.annotations.security.UnlicensedSiteAccess;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.jira.addon.IUM.analytical.UserActionEvent;
import de.accxia.jira.addon.IUM.analytical.UserActionEventType;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.servlet.session.AccxiaUserSessionTracker;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@UnlicensedSiteAccess
public class AccessLogFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AccessLogFilter.class);
    @ComponentImport
    private EventPublisher eventPublisher;
    @ComponentImport
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Inject
    public AccessLogFilter(EventPublisher eventPublisher, JiraAuthenticationContext jiraAuthenticationContext) {
        this.eventPublisher = eventPublisher;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("AccessLogFilter initialized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        this.doUserAnalytical(httpServletRequest, httpServletResponse);
        try {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        finally {
            try {
                AccxiaUserSessionTracker.recordInteraction(httpServletRequest);
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void doUserAnalytical(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String userName = httpServletRequest.getRemoteUser();
        String requestURI = httpServletRequest.getRequestURI();
        if (!DAO.getAuditStatus()) {
            return;
        }
        if (userName == null || requestURI == null) {
            return;
        }
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        if (user == null) {
            return;
        }
        try {
            if (DAO.getAuditStatus()) {
                UserActionEvent userActionEvent = UserActionEvent.createUserActionEvent4Type(user, null, UserActionEventType.USER_ACTION);
                this.eventPublisher.publish((Object)userActionEvent);
            }
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
    }
}

