var IUMCheck = new function() {
    var self=this;
    var theTimer;
    let INTERVAL=15000;
    let ONE_MINUTE=60 * 1000;
    const DELTA=300;
    const DEBUG=false;
    const IUM_CHECK_SLOT_PING='jira_ium_check_slot_ping'
    const IUM_CHECK_SLOT_LOGOUT='jira_ium_check_slot_logout'
    const IUM_CHECK_ACCESS_PING='jira_ium_check_access_ping'

    var doDisabled=function(force){
        //debugger;

        if(force){
            //clean - IUM_CHECK_ACCESS_PING/IUM_CHECK_ACCESS_LOGOUT
            window.localStorage.removeItem(IUM_CHECK_SLOT_PING);
            window.localStorage.removeItem(IUM_CHECK_SLOT_LOGOUT);
            window.localStorage.removeItem(IUM_CHECK_ACCESS_PING);

            AJS.$(".ium_removal").show();
            AJS.$(".ium_queue").hide();

            // document.location.href=AJS.contextPath() + "/logout.action";
            /*
            var redirectPage = encodeURIComponent(window.location.pathname.replace(AJS.contextPath(), ''));
            document.location.href =  AJS.contextPath() + '/login.action?permissionViolation=true&os_destination=' + redirectPage;
             */
            return;

        }

        if(self.theLastUserName){
            document.location.href=AJS.contextPath() + "/secure/disable?username="+self.theLastUserName;
        }else {
            // ==> /login.action?os_destination=%2Fpages%2Fviewpage.action%3FspaceKey%3DCD%26title%3DComala%2BDemo%2BHome&permissionViolation=true
            document.location.href = AJS.contextPath() +"/login.action?os_destination=" +document.location.href +"&permissionViolation=true";
            //document.location.href = AJS.contextPath() + "/secure/Dashboard.jspa";
        }
    }

    var doRetry=function(){
       if(document.forms['retry']){
           document.forms['retry'].submit();
           return;
       }
        //document.location.href="/secure/restore?username="+self.theLastUserName;
        document.location.href = AJS.contextPath() + "/secure/Dashboard.jspa";
    }

    var getJSONDateRef=function(){
        let dateStr=window.localStorage.getItem(IUM_CHECK_SLOT_PING);
        let dateRef =null;
        if(dateStr){
            try{
                dateRef = JSON.parse(dateStr);
            } catch (error) {
                console.error(error);
                dateRef=null;
            }
        }
        return dateRef;

    }

    var doRetryOrStop=function(){
        //called at the end of waiting interval

        let dateRef=getJSONDateRef();
        if(dateRef && dateRef.removal){
            var dateNow = Date.now();
            var dateDiff = dateNow - dateRef.timestamp;
            if(DEBUG){
                console.log("RM:" + "removal " + dateRef.removal + (new Date(dateNow).toISOString().slice(-13, -5)) + " / " + (new Date(dateRef.timestamp).toISOString().slice(-13, -5)) + " Access diff " + (dateNow - dateRef.timestamp));
            }

            AJS.$(".ium_removal").show();
            AJS.$(".ium_queue").hide();

            return;
        }
        doRetry()
    }

    var checkApplicationAccess=function(){
        // debugger;

        //pass 15 sec
        self.duration=self.duration-INTERVAL;
        console.log("checkApplicationAccess self.duration= "+self.duration);

        if(self.duration>0){
            var dateNow = Date.now();
            var dateStr=window.localStorage.getItem(IUM_CHECK_SLOT_PING);
            var dateRef =null;
            if(dateStr){
                try{
                    var dateRef = JSON.parse(dateStr);
                    var dateDiff = dateNow - dateRef.timestamp;
                    if(DEBUG){
                        console.log("CHK:" + (new Date(dateNow).toISOString().slice(-13, -5)) + " / " + (new Date(dateRef.timestamp).toISOString().slice(-13, -5)) + " Access diff " + (dateNow - dateRef.timestamp));
                    }

                    if (((Math.abs(dateDiff - INTERVAL) > DELTA) && (dateDiff < INTERVAL + 2 * DELTA)) && (dateRef.username === self.theLastUserName)) {
                        if(DEBUG){
                            console.log("BKP:" + (new Date(dateNow).toISOString().slice(-13, -5)) + " / " + (new Date(dateRef.timestamp).toISOString().slice(-13, -5)) + " Access diff " + (dateNow - dateRef.timestamp));
                        }
                        doProcessData(dateRef,false);
                        return;
                    }
                } catch (error) {
                    console.error(error);
                    dateRef=null;
                }
            }

            if(DEBUG){
                if(dateRef && dateRef.timestamp){
                    console.log("NET:" +( new Date().toISOString().slice(-13, -5)) + " / " + ( new Date(dateRef.timestamp).toISOString().slice(-13, -5))  +  " Access diff " +(dateNow - dateRef.timestamp) );
                }else{
                    console.log("NET:" +( new Date().toISOString().slice(-13, -5)));
                }
            }

            self.ajaxGetCall(AJS.contextPath() + "/rest/IUM/latest/check?username="+self.theLastUserName);
        }else{
            callRetry();
        }
    }

    var doProcessData=function(data,withSaving){
        // debugger;

        if(DEBUG){
            console.log("data="+ JSON.stringify(data));
        }

        if(data.freeSlots && (data.removal===false)){
            doRetry()
        }

        if(withSaving){
            data.timestamp = Date.now();
            data.username=self.theLastUserName;
            window.localStorage.setItem(IUM_CHECK_SLOT_PING,JSON.stringify(data));
            if(DEBUG){
                console.log("SAVE:" + ( new Date(data.timestamp).toISOString().slice(-13, -5))  +  " data=" +JSON.stringify(data) );
            }
        }

        if(data.removal===true){
            clearInterval(theTimer);
            doRetryOrStop();
        }
    }

    this.startCheckWatcher=function(){
        //1. retrive input.hidden
        var userName=AJS.$("#username").val();
        var duration=AJS.$("#duration").val();
        self.duration = duration ? duration : 1;

        //convert to milliseconds
        self.duration=self.duration * ONE_MINUTE;
        INTERVAL =Math.ceil( self.duration/4);
        INTERVAL= INTERVAL<ONE_MINUTE ? INTERVAL :ONE_MINUTE;

        if (typeof (userName)!="undefined"){
            self.theLastUserName=userName;
            theTimer=setInterval(checkApplicationAccess, INTERVAL);


            window.addEventListener('storage', function(event) {
                // Check the changed key and react accordingly
                if (event.key === IUM_CHECK_SLOT_LOGOUT) {
                    var datRef =JSON.parse(event.newValue);

                    console.warn("storage: IUM_CHECK_SLOT_LOGOUT" + datRef);
                    if(self.theLastUserName === datRef.username){
                        doDisabled(!!datRef.force);
                    }
                }
            });

            const onStorageEvent=function(event) {
                // Check the changed key and react accordingly
                if (event.key === IUM_CHECK_ACCESS_PING) {
                    //{"username":"account10","enabled":true,"timestamp":1713290928760}'
                    var datRef = JSON.parse(event.newValue);

                    console.warn("storage: IUM_CHECK_ACCESS_PING" , datRef);
                    // if (self.theLastUserName === datRef.username && datRef.enabled) {}
                    if (self.theLastUserName === datRef.username &&
                        (datRef["jira-servicedesk"] || datRef["jira-software"] || datRef["jira-core"])){
                        doRetry();
                        window.removeEventListener('storage', onStorageEvent);
                    }
                }
            }
            window.addEventListener('storage', onStorageEvent);

        }


    }

    var callRetry=function(){
        clearInterval(theTimer);
        doRetryOrStop();
    }

    var callDisabledOrLogout=function(force){
        clearInterval(theTimer);
        var dateRef={username:self.theLastUserName, timestamp:Date.now(),force:force};
        window.localStorage.setItem(IUM_CHECK_SLOT_LOGOUT,JSON.stringify(dateRef));
        doDisabled(!!datRef.force);
        console.log("ACCXIA IUM: User has been logged out");
    }

    this.ajaxGetCall = function(url) {
        jQuery.ajax({
            url : url,
            dataType : 'json',
            contentType: "application/json; charset=utf-8",
            async : true,
            success : function(data) {
                doProcessData(data,true)

            },
            error :function (xhr, textStatus, errorThrown ) {
                if (xhr.status >= 400 || errorThrown ) {
                    // {"message":"Client must be authenticated to access this resource.","status-code":401}   Unauthorized
                    if(xhr.status==401){
                        callDisabledOrLogout(true);
                        return;
                    }

                    callDisabledOrLogout();
                }
            }
        });
    };
};

AJS.$( document ).ready(function() {
    IUMCheck.startCheckWatcher();
});
