/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.job;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.caesium.impl.RunTimeCalculator;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.core.spi.SchedulerServiceConfiguration;
import com.atlassian.scheduler.cron.CronSyntaxException;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class IUMRunTimeCalculator {
    @ComponentImport
    private final ApplicationProperties applicationProperties;
    private final SchedulerServiceConfiguration schedulerServiceConfiguration;
    private final RunTimeCalculator runTimeCalculator;

    @Inject
    public IUMRunTimeCalculator(final ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
        this.schedulerServiceConfiguration = new SchedulerServiceConfiguration(){

            @Nullable
            public TimeZone getDefaultTimeZone() {
                String zoneId = applicationProperties.getString("jira.default.timezone");
                return zoneId != null ? TimeZone.getTimeZone(zoneId) : null;
            }
        };
        this.runTimeCalculator = new RunTimeCalculator(this.schedulerServiceConfiguration);
    }

    public Date nextRunTime(Schedule schedule, @Nullable Date prevRunTime) throws CronSyntaxException {
        return this.runTimeCalculator.nextRunTime(schedule, prevRunTime);
    }
}

