/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.job;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.google.common.collect.Sets;
import de.accxia.jira.addon.IUM.job.IJob;
import de.accxia.jira.addon.IUM.job.ProcessResult;
import de.accxia.jira.addon.IUM.model.AlertType;
import de.accxia.jira.addon.IUM.model.IUMAlertDTO;
import de.accxia.jira.addon.IUM.model.TrialProcessing;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import de.accxia.jira.addon.IUM.servlet.HelperTrialProcessing;
import de.accxia.jira.addon.IUM.utils.ParseUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMSyncJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMSyncJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMSyncJob instance;
    private HelperTrialProcessing helperTrialProcessing;
    private PocketRepository pocketRepository;
    private JobResultRepository jobResultRepository;
    private ApplicationRoleManager applicationRoleManager;
    private static UserUtil userUtil;

    private IUMSyncJob() {
    }

    public static IUMSyncJob getInstance() {
        if (instance == null) {
            instance = new IUMSyncJob();
        }
        return instance;
    }

    @Override
    public void injectService(HelperTrialProcessing helperTrialProcessing, PocketRepository pocketRepository, JobResultRepository jobResultRepository) {
        IUMSyncJob.instance.helperTrialProcessing = helperTrialProcessing;
        IUMSyncJob.instance.pocketRepository = pocketRepository;
        IUMSyncJob.instance.jobResultRepository = jobResultRepository;
    }

    @Override
    public void injectService(ApplicationRoleManager applicationRoleManager) {
        IUMSyncJob.instance.applicationRoleManager = applicationRoleManager;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) throws RemoveException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMSyncJob Process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        String sourceGroups = (String)((Object)parameters.get("source_software_groups"));
        String targetGroup = (String)((Object)parameters.get("target_software_group"));
        String sourceGroups2 = (String)((Object)parameters.get("source_sdesk_groups"));
        String targetGroup2 = (String)((Object)parameters.get("target_sdesk_group"));
        String currentUser = (String)((Object)parameters.get("current_user"));
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMSyncJob Sync groups = {} -> {}  at [ {} ] ", new Object[]{sourceGroups, targetGroup, SDF.format(new Date())});
        }
        if (this.pocketRepository != null) {
            ProcessResult processResult;
            GroupManager groupManager = ComponentAccessor.getGroupManager();
            UserManager userManager = ComponentAccessor.getUserManager();
            UserUtil userUtil = ComponentAccessor.getUserUtil();
            if (!ParseUtil.isEmpty(sourceGroups) && !ParseUtil.isEmpty(targetGroup)) {
                Set<ApplicationUser> userJiraAccess = this.getUsersWithJiraAccess();
                processResult = this.processPair(groupManager, userUtil, currentUser, sourceGroups, targetGroup, userJiraAccess);
                processResultList.add(processResult);
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("IUMSyncJob copied #" + processResult.getUserCopied() + " to group " + targetGroup);
                    this.LOG.debug("IUMSyncJob removed #" + processResult.getUserRemoved() + " to group " + sourceGroups);
                }
            }
            if (!ParseUtil.isEmpty(sourceGroups2) && !ParseUtil.isEmpty(targetGroup2)) {
                Set<ApplicationUser> userSDeskAccess = this.getUsersWithSDeskAccess();
                processResult = this.processPair(groupManager, userUtil, currentUser, sourceGroups2, targetGroup2, userSDeskAccess);
                processResultList.add(processResult);
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("IUMSyncJob copied #" + processResult.getUserCopied() + " to group " + targetGroup2);
                    this.LOG.debug("IUMSyncJob removed #" + processResult.getUserRemoved() + " to group " + sourceGroups2);
                }
            }
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMSyncJob Processed #[" + SDF.format(new Date()) + "] ");
        }
        return processResultList;
    }

    private ProcessResult processPair(GroupManager groupManager, UserUtil userUtil, String currentUser, String sourceGroups, String targetGroup, Set<ApplicationUser> applicationUserAccess) {
        String[] arrayEnableGroups;
        String[] stringArray = arrayEnableGroups = ParseUtil.isEmpty(sourceGroups) ? null : sourceGroups.split(";");
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMSyncJob Sync groups = {} -> {}  at [ {} ] ", new Object[]{sourceGroups, targetGroup, SDF.format(new Date())});
        }
        ProcessResult processResult = new ProcessResult("SyncJob", sourceGroups, targetGroup);
        if (targetGroup != null) {
            Group jiraTargetGroup = groupManager.getGroup(targetGroup);
            if (arrayEnableGroups != null && jiraTargetGroup != null) {
                Collection targetUsers = groupManager.getUsersInGroup(targetGroup);
                Set targetUserSet = targetUsers.stream().collect(Collectors.toSet());
                HashSet sourceUserSet = new HashSet();
                for (String group : arrayEnableGroups) {
                    Set groupUsers = groupManager.getUsersInGroup(group).stream().filter(ApplicationUser::isActive).collect(Collectors.toSet());
                    sourceUserSet.addAll(groupUsers);
                }
                Sets.SetView set2AddView = Sets.difference((Set)Sets.difference(sourceUserSet, targetUserSet), applicationUserAccess);
                Sets.SetView set2RemoveView = Sets.difference((Set)Sets.difference(targetUserSet, sourceUserSet), applicationUserAccess);
                processResult.setUserRemoved(0L);
                set2RemoveView.stream().forEach(user -> {
                    try {
                        userUtil.removeUserFromGroup(jiraTargetGroup, user);
                        processResult.setUserRemoved(processResult.getUserRemoved() + 1L);
                        if (this.LOG.isInfoEnabled()) {
                            this.LOG.info("IUMSyncJob added user {} to group   {} ", new Object[]{user.getUsername(), targetGroup});
                        }
                    }
                    catch (Exception e) {
                        this.LOG.error("Exception " + e.getMessage(), (Throwable)e);
                    }
                });
                processResult.setUserCopied(0L);
                TrialProcessing trialProcessing = this.helperTrialProcessing.exceedLimitByCopyUsers2Group(targetGroup, set2AddView.size());
                if (trialProcessing.isTrial() && trialProcessing.isWarning()) {
                    IUMAlertDTO alertDTO = this.helperTrialProcessing.markSyncProcessingError(AlertType.ALERT_JOBSYNC, currentUser, targetGroup, set2AddView.size());
                    processResult.setError(alertDTO.getMessage());
                } else {
                    set2AddView.stream().forEach(user -> {
                        try {
                            userUtil.addUserToGroup(jiraTargetGroup, user);
                            processResult.setUserCopied(processResult.getUserCopied() + 1L);
                            if (this.LOG.isInfoEnabled()) {
                                this.LOG.info("IUMSyncJob added user {} to group   {} ", new Object[]{user.getUsername(), targetGroup});
                            }
                        }
                        catch (Exception e) {
                            this.LOG.error("Exception " + e.getMessage(), (Throwable)e);
                        }
                    });
                }
            }
        } else {
            this.LOG.warn("IUMSyncJob skipped Empty Source/Target config");
        }
        return processResult;
    }

    public Set<ApplicationUser> getUsersWithJiraAccess() {
        return this.helperTrialProcessing.getUsersWithGenericAccessExceptGroup(ApplicationKeys.SOFTWARE, "");
    }

    public Set<ApplicationUser> getUsersWithSDeskAccess() {
        return this.helperTrialProcessing.getUsersWithGenericAccessExceptGroup(ApplicationKeys.SERVICE_DESK, "");
    }

    private static ApplicationRole getApplicationRole(ApplicationRoleManager applicationRoleManager, ApplicationKey applicationKey) {
        if (applicationRoleManager == null || applicationKey == null) {
            return null;
        }
        List applicationRoleList = applicationRoleManager.getRoles().stream().filter(applicationRole -> applicationRole.getKey().equals((Object)applicationKey)).collect(Collectors.toList());
        return applicationRoleList.size() > 0 ? (ApplicationRole)applicationRoleList.get(0) : null;
    }

    static {
        userUtil = ComponentAccessor.getUserUtil();
    }
}

