/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.job;

import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;
import de.accxia.jira.addon.IUM.job.IUMDailyEventJob;
import de.accxia.jira.addon.IUM.job.JobDataUtils;
import de.accxia.jira.addon.IUM.job.MonitorJobRunner;
import de.accxia.jira.addon.IUM.model.JobResult;
import de.accxia.jira.addon.IUM.model.JobResultDTO;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={JobDailyEventService.class})
@Named(value="JobDailyEventService")
public class JobDailyEventService {
    private Logger LOG = LoggerFactory.getLogger(JobDailyEventService.class);
    private final MonitorJobRunner monitorJobRunner;
    private final JobResultRepository jobResultRepository;
    private final ApplicationRoleManager applicationRoleManager;
    private static UserUtil userUtil = ComponentAccessor.getUserUtil();

    @Inject
    public JobDailyEventService(MonitorJobRunner monitorJobRunner, JobResultRepository jobResultRepository, ApplicationRoleManager applicationRoleManager) {
        this.monitorJobRunner = monitorJobRunner;
        this.jobResultRepository = jobResultRepository;
        this.applicationRoleManager = applicationRoleManager;
    }

    public boolean start() {
        try {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("JobDailyEventService call start");
            }
            this.monitorJobRunner.doUnSchedule(IUMDailyEventJob.class);
            this.monitorJobRunner.doSchedule(JobDataUtils.createIUMDailyEventJobData(), IUMDailyEventJob.getInstance());
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            this.LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean stop() {
        try {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("JobDailyEventService doStop");
            }
            this.monitorJobRunner.doUnSchedule(IUMDailyEventJob.class);
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            this.LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean isWorking() {
        return this.monitorJobRunner.isWorking(IUMDailyEventJob.class);
    }

    public JobDetails getJobDetails() {
        return this.monitorJobRunner.getJobDetails(IUMDailyEventJob.class);
    }

    public Date getNextRunDate() {
        return this.monitorJobRunner.getNextRunDate(IUMDailyEventJob.class);
    }

    public RunDetails getLastSuccessfulRunForJob() {
        return this.monitorJobRunner.getLastSuccessfulRunForJob(IUMDailyEventJob.class);
    }

    public List<JobResultDTO> findLatest(int idx, int ctx) {
        JobResult[] jobResults = this.jobResultRepository.findAll(idx, ctx);
        List<JobResultDTO> jobResultDTOList = Arrays.stream(jobResults).map(jobResult -> JobResultDTO.fromAO(jobResult)).collect(Collectors.toList());
        return jobResultDTOList;
    }
}

