/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.accxia.jira.addon.IUM.config.DAO;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMHelperCacheService {
    private static final Logger LOG = LoggerFactory.getLogger(IUMHelperCacheService.class);
    public static final long USERCACHE_DURATION = 10L;
    public static final long DURATION = 30L;
    public static final long REMOVAL_DURATION = 10L;
    private Cache<String, Long> iumRemoval4UserCache = this.initIUMRemoval4UserCache();
    private static IUMHelperCacheService instance;

    private IUMHelperCacheService() {
    }

    public static IUMHelperCacheService getInstance() {
        if (instance == null) {
            instance = new IUMHelperCacheService();
        }
        return instance;
    }

    private Cache<String, Long> initIUMRemoval4UserCache() {
        return CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    }

    private void rebuildIUMRemoval4UserCache(long minutes) {
        Cache newIUMRemoval4UserCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(minutes, TimeUnit.MINUTES).build();
        newIUMRemoval4UserCache.putAll((Map)this.iumRemoval4UserCache.asMap());
        this.iumRemoval4UserCache = newIUMRemoval4UserCache;
        LOG.info("IUMRemoval4UserCache set at " + minutes + " minutes ");
    }

    public void addUserToRemovalCache(String userName) {
        if (DAO.getAutoConnectAsBool()) {
            this.iumRemoval4UserCache.put((Object)userName.toLowerCase(), (Object)System.currentTimeMillis());
        }
    }

    public void removeUserFromRemovalCache(String userName) {
        if (DAO.getAutoConnectAsBool()) {
            this.iumRemoval4UserCache.invalidate((Object)userName.toLowerCase());
        }
    }

    public Map<String, Long> getUsersFromRemovalCache() {
        HashMap<String, Long> retVal = new HashMap<String, Long>();
        long currentTime = System.currentTimeMillis();
        for (Map.Entry entry : this.iumRemoval4UserCache.asMap().entrySet()) {
            retVal.put((String)entry.getKey(), (currentTime - (entry.getValue() != null ? (Long)entry.getValue() : 0L)) / 1000L);
        }
        return retVal;
    }

    public boolean hasUserAutomaticRemovalStatus(String userName) {
        if (DAO.getAutoConnectAsBool()) {
            return this.iumRemoval4UserCache.getIfPresent((Object)userName.toLowerCase()) != null;
        }
        return false;
    }

    public boolean removeAllCache() {
        try {
            this.iumRemoval4UserCache.invalidateAll();
            return true;
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

