/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.session;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.http.HttpRequestType;
import com.atlassian.jira.web.filters.accesslog.AccessLogIPAddressUtil;
import com.atlassian.jira.web.session.currentusers.JiraUserSession;
import com.atlassian.jira.web.session.currentusers.JiraUserSessionInvalidator;
import com.atlassian.jira.web.session.currentusers.JiraUserSessionTracker;
import com.google.common.collect.Lists;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.servlet.session.AccxiaMutableJiraUserSession;
import de.accxia.jira.addon.IUM.servlet.session.AccxiaUserSessionTrackerDeletionStrategy;
import de.accxia.jira.addon.IUM.servlet.session.SnapshotAccxiaUserSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccxiaUserSessionTracker
extends JiraUserSessionTracker {
    private static final Logger log = LoggerFactory.getLogger(AccxiaUserSessionTracker.class);
    public static final String URI_IMAGE = "/plugins/servlet/ium-image";
    private final AccxiaUserSessionTrackerDeletionStrategy deletionStrategy = new AccxiaUserSessionTrackerDeletionStrategy();
    private static AccxiaUserSessionTracker instance;
    private JiraUserSessionInvalidator jiraUserSessionInvalidator;
    private JiraAuthenticationContext jiraAuthenticationContext;
    public static final long INTERVAL = 15000L;
    private final ConcurrentMap<String, AccxiaMutableJiraUserSession> sessionMap = new ConcurrentHashMap<String, AccxiaMutableJiraUserSession>();

    public AccxiaUserSessionTracker() {
        this.jiraUserSessionInvalidator = (JiraUserSessionInvalidator)ComponentAccessor.getComponent(JiraUserSessionInvalidator.class);
        this.jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
    }

    public static AccxiaUserSessionTracker getInstance() {
        if (instance == null) {
            instance = new AccxiaUserSessionTracker();
        }
        return instance;
    }

    public static void recordInteraction(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return;
        }
        String userName = httpServletRequest.getRemoteUser();
        String requestURI = httpServletRequest.getRequestURI();
        if (userName == null || requestURI == null) {
            return;
        }
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null || httpSession.isNew()) {
            return;
        }
        if (requestURI.contains(URI_IMAGE)) {
            return;
        }
        AccxiaUserSessionTracker tracker = AccxiaUserSessionTracker.getInstance();
        if (tracker != null) {
            tracker.recordInteractionImpl(httpServletRequest);
        }
    }

    public boolean markSessionAsInvalid(String sessionId) {
        if (StringUtils.isEmpty((CharSequence)sessionId)) {
            return false;
        }
        AccxiaMutableJiraUserSession session = (AccxiaMutableJiraUserSession)this.sessionMap.get(sessionId);
        if (session != null) {
            session.setInvalidateSessionFlag(false);
            this.jiraUserSessionInvalidator.invalidateSession(sessionId);
            this.sessionMap.remove(sessionId);
        }
        return true;
    }

    public boolean isMarkSessionAsInvalid(String sessionId) {
        if (StringUtils.isEmpty((CharSequence)sessionId)) {
            return false;
        }
        AccxiaMutableJiraUserSession session = (AccxiaMutableJiraUserSession)this.sessionMap.get(sessionId);
        if (session == null) {
            return false;
        }
        return session.getInvalidateSessionFlag();
    }

    public List<JiraUserSession> getAccxiaSnapshot() {
        ArrayList userSessions = Lists.newArrayListWithCapacity((int)this.sessionMap.size());
        for (AccxiaMutableJiraUserSession jiraUserSession : this.sessionMap.values()) {
            userSessions.add(new SnapshotAccxiaUserSession(jiraUserSession));
        }
        Collections.sort(userSessions, Collections.reverseOrder(BY_LAST_ACCESS_TIME));
        return userSessions;
    }

    protected void recordInteractionImpl(HttpServletRequest httpServletRequest) {
        String asessionId = (String)httpServletRequest.getAttribute("jira.request.assession.id");
        this.recordHttpInteraction(httpServletRequest, asessionId);
    }

    private HttpRequestType determineRequestType(HttpServletRequest httpServletRequest) {
        return AccessLogIPAddressUtil.getShortenedRequestUrl((HttpServletRequest)httpServletRequest).startsWith("/rest/") ? HttpRequestType.REST : HttpRequestType.HTTP;
    }

    private void recordHttpInteraction(HttpServletRequest httpServletRequest, final String asessionId) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            final String httpSessionId = httpSession.getId();
            HttpRequestType httpRequestType = this.determineRequestType(httpServletRequest);
            if (httpRequestType == HttpRequestType.HTTP && httpServletRequest.getRemoteUser() != null && (httpServletRequest.getRequestURI() == null || httpServletRequest != null && (httpServletRequest.getRequestURI().contains("/secure") || httpServletRequest.getRequestURI().contains("/browse") || httpServletRequest.getRequestURI().contains("/servlet") || httpServletRequest.getRequestURI().contains("/plugins") || httpServletRequest.getRequestURI().equals(httpServletRequest.getContextPath() + "/")))) {
                this.recordInteractionImpl(httpSessionId, httpServletRequest, httpServletRequest.getRemoteUser(), new AccxiaMutableSessionFactory(){

                    @Override
                    public AccxiaMutableJiraUserSession createUserSession() {
                        return new AccxiaMutableJiraUserSession(HttpRequestType.HTTP, httpSessionId, asessionId);
                    }
                });
            }
        }
    }

    private void recordInteractionImpl(String sessionId, HttpServletRequest httpServletRequest, String userName, AccxiaMutableSessionFactory sessionFactory) {
        this.deletionStrategy.deleteStaleSessions(this.sessionMap);
        boolean shouldRecordInteraction = false;
        AccxiaMutableJiraUserSession userSession = (AccxiaMutableJiraUserSession)this.sessionMap.get(sessionId);
        if (userSession == null) {
            AccxiaMutableJiraUserSession newSession = sessionFactory.createUserSession();
            AccxiaMutableJiraUserSession previousValue = this.sessionMap.putIfAbsent(sessionId, newSession);
            if (previousValue == null && this.jiraAuthenticationContext.getLoggedInUser() != null && IntelligentUserManagerHelper.isUserInGroups(this.jiraAuthenticationContext.getLoggedInUser(), DAO.getIUMGroups())) {
                shouldRecordInteraction = true;
            }
            userSession = previousValue != null ? previousValue : newSession;
        }
        long currentTime = System.currentTimeMillis();
        if (shouldRecordInteraction || currentTime - userSession.getLastAccessTime().getTime() > 15000L) {
            userSession.recordInteraction(httpServletRequest, userName);
            userSession.recordInteractionDB();
        } else {
            userSession.recordInteraction(httpServletRequest, userName);
        }
    }

    private static interface AccxiaMutableSessionFactory {
        public AccxiaMutableJiraUserSession createUserSession();
    }
}

