/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.side;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import de.accxia.jira.addon.IUM.analytical.ChartRepository;
import de.accxia.jira.addon.IUM.analytical.CounterActionDTO;
import de.accxia.jira.addon.IUM.analytical.CounterActionEvent;
import de.accxia.jira.addon.IUM.analytical.CounterActionEventType;
import de.accxia.jira.addon.IUM.analytical.LicenseAnalyticalService;
import de.accxia.jira.addon.IUM.analytical.LicenseTierDTO;
import de.accxia.jira.addon.IUM.analytical.ServiceMarkerType;
import de.accxia.jira.addon.IUM.analytical.UserActionEvent;
import de.accxia.jira.addon.IUM.analytical.UserActionEventType;
import de.accxia.jira.addon.IUM.analytical.UserActivity;
import de.accxia.jira.addon.IUM.analytical.UserAnalyticalDTO;
import de.accxia.jira.addon.IUM.analytical.UserReference;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.impl.OldestUser;
import de.accxia.jira.addon.IUM.impl.PublisherHelper;
import de.accxia.jira.addon.IUM.job.ProcessResult;
import de.accxia.jira.addon.IUM.model.IUMAlert;
import de.accxia.jira.addon.IUM.model.IUMAlertDTO;
import de.accxia.jira.addon.IUM.model.NavUser;
import de.accxia.jira.addon.IUM.model.NavUserDTO;
import de.accxia.jira.addon.IUM.model.UserHistoryDTO;
import de.accxia.jira.addon.IUM.repository.IUMAlertRepository;
import de.accxia.jira.addon.IUM.repository.NavUserRepository;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import de.accxia.jira.addon.IUM.servlet.HelperTrialProcessing;
import de.accxia.jira.addon.IUM.utils.DateUtil;
import de.accxia.jira.addon.IUM.utils.ParseUtil;
import java.lang.invoke.CallSite;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/test")
@Consumes(value={"text/html"})
@Produces(value={"text/plain"})
@Component
public class TestRest {
    private static final Logger LOG = LoggerFactory.getLogger(TestRest.class);
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserService userService;
    @ComponentImport
    private final IssueManager issueManager;
    @ComponentImport
    private final ProjectManager projectManager;
    private com.atlassian.jira.user.util.UserManager userManagerJira = ComponentAccessor.getUserManager();
    private final I18nHelper i18nHelper;
    @ComponentImport
    private final AvatarService avatarService;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final ApplicationRoleManager applicationRoleManager;
    @ComponentImport
    private final ApplicationAuthorizationService applicationAuthorizationService;
    @ComponentImport
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private static final I18nHelper i18Helper = ComponentAccessor.getI18nHelperFactory().getInstance(Locale.getDefault());
    private final IUMAlertRepository iumAlertRepository;
    private final HelperTrialProcessing helperTrialProcessing;
    private final ChartRepository chartRepository;
    private final LicenseAnalyticalService licenseAnalyticalService;
    private static final GroupManager groupManager = ComponentAccessor.getGroupManager();
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public TestRest(UserManager userManager, UserService userService, IssueManager issueManager, ProjectManager projectManager, PermissionManager permissionManager, ApplicationRoleManager applicationRoleManager, ApplicationAuthorizationService applicationAuthorizationService, JiraAuthenticationContext jiraAuthenticationContext, AvatarService avatarService, IUMAlertRepository iumAlertRepository, HelperTrialProcessing helperTrialProcessing, ChartRepository chartRepository, LicenseAnalyticalService licenseAnalyticalService) {
        this.userManager = userManager;
        this.userService = userService;
        this.issueManager = issueManager;
        this.projectManager = projectManager;
        this.iumAlertRepository = iumAlertRepository;
        this.helperTrialProcessing = helperTrialProcessing;
        this.chartRepository = chartRepository;
        this.licenseAnalyticalService = licenseAnalyticalService;
        this.i18nHelper = (I18nHelper)ComponentAccessor.getComponent(I18nHelper.class);
        this.permissionManager = permissionManager;
        this.applicationRoleManager = applicationRoleManager;
        this.applicationAuthorizationService = applicationAuthorizationService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.avatarService = avatarService;
    }

    @Path(value="/role")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getApplicationRole4Group(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        ArrayList retVal = new ArrayList();
        List<OldestUser> users = IntelligentUserManagerHelper.getSortedUserListFromGroup(group, 0, 1000, "");
        for (OldestUser ouser : users) {
            ArrayList<Object> uList = new ArrayList<Object>();
            uList.add(ouser.getUser().getName());
            uList.add(String.valueOf(ouser.ts));
            uList.add(String.valueOf(ouser.getUser().isActive()));
            uList.add(SDF.format(new Date(ouser.ts)));
            boolean canUseSoftwareAccess = this.applicationAuthorizationService.canUseApplication(ouser.getUser(), ApplicationKeys.SOFTWARE);
            boolean canUseServiceDeskAccess = this.applicationAuthorizationService.canUseApplication(ouser.getUser(), ApplicationKeys.SERVICE_DESK);
            boolean canUseCoreAccess = this.applicationAuthorizationService.canUseApplication(ouser.getUser(), ApplicationKeys.CORE);
            uList.add("canUseSoftwareAccess=" + String.valueOf(canUseSoftwareAccess));
            uList.add("canUseServiceDeskAccess=" + String.valueOf(canUseServiceDeskAccess));
            uList.add("canUseCoreAccess=" + String.valueOf(canUseCoreAccess));
            retVal.add(uList);
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/role2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getApplicationRole2(@Context HttpServletRequest request) {
        ApplicationUser user = null;
        String username = request.getParameter("username");
        if (username != null) {
            user = this.userManagerJira.getUserByName(username);
        }
        HashMap retVal = new HashMap();
        if (user != null) {
            Set applicationRoles = this.applicationRoleManager.getOccupiedLicenseRolesForUser(user);
            for (ApplicationRole applicationRole : applicationRoles) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("applicationRole[" + username + "]= " + applicationRole.getKey());
                }
                List groups = applicationRole.getGroups().stream().map(group -> group.getName()).collect(Collectors.toList());
                retVal.put(applicationRole.getKey().value(), groups);
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/role3")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getApplicationRole3(@Context HttpServletRequest request) {
        ApplicationUser user = null;
        String username = request.getParameter("username");
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("username", username);
        HashMap<CallSite, Boolean> retValCanUse = new HashMap<CallSite, Boolean>();
        HashMap retValLic = new HashMap();
        HashMap<CallSite, String[]> retValRole = new HashMap<CallSite, String[]>();
        HashMap<String, Integer> retValGroup = new HashMap<String, Integer>();
        if (username != null) {
            user = this.userManagerJira.getUserByName(username);
        }
        if (user != null) {
            String[] groups;
            boolean canUseSoftwareAccess = this.applicationAuthorizationService.canUseApplication(user, ApplicationKeys.SOFTWARE);
            boolean canUseServiceDeskAccess = this.applicationAuthorizationService.canUseApplication(user, ApplicationKeys.SERVICE_DESK);
            boolean canUseCoreAccess = this.applicationAuthorizationService.canUseApplication(user, ApplicationKeys.CORE);
            retValCanUse.put((CallSite)((Object)("can-use-" + ApplicationKeys.SOFTWARE.value())), canUseSoftwareAccess);
            retValCanUse.put((CallSite)((Object)("can-use-" + ApplicationKeys.SERVICE_DESK.value())), canUseServiceDeskAccess);
            retValCanUse.put((CallSite)((Object)("can-use-" + ApplicationKeys.CORE.value())), canUseCoreAccess);
            retVal.put("can-use", retValCanUse);
            Set applicationRoles = this.applicationRoleManager.getOccupiedLicenseRolesForUser(user);
            for (Object applicationRole : applicationRoles) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("applicationRole[" + username + "]= " + applicationRole.getKey());
                }
                List groups2 = applicationRole.getGroups().stream().map(group -> group.getName()).collect(Collectors.toList());
                retValLic.put((CallSite)((Object)("lic-role-" + applicationRole.getKey().value())), groups2);
            }
            retVal.put("lic-role", retValLic);
            Set applicationRoles2 = this.applicationRoleManager.getRolesForUser(user);
            for (ApplicationRole applicationRole : applicationRoles2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("applicationRole[" + username + "]= " + applicationRole.getKey());
                }
                groups = applicationRole.getGroups().stream().map(group -> group.getName()).collect(Collectors.toList());
                retValRole.put((CallSite)((Object)("app-role-" + applicationRole.getKey().value())), groups);
            }
            retVal.put("app-role", retValRole);
            Collection groupNames = groupManager.getGroupNamesForUser(user);
            retVal.put("groupNames", groupNames);
            String group2 = DAO.getIUMGroups();
            groups = null;
            if (group2 != null) {
                groups = group2.split(",");
                for (int i = 0; i < groups.length; ++i) {
                    int groupCount = groupManager.getUsersInGroupCount(groupManager.getGroup(groups[i]));
                    retValGroup.put(groups[i], groupCount);
                }
            }
            retVal.put("groups", retValGroup);
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav1")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAllNavUserForGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset = this.safeParseToInt(request.getParameter("offset"));
        int cnt = this.safeParseToInt(request.getParameter("cnt"));
        ArrayList<String> retVal = new ArrayList<String>();
        PocketRepository pocketRepository = (PocketRepository)ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
        if (pocketRepository != null) {
            List<NavUserDTO> navUsers = pocketRepository.getAllNavUserForGroup(group, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getOldestUsers(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset = this.safeParseToInt(request.getParameter("offset"));
        int cnt = this.safeParseToInt(request.getParameter("cnt"));
        ArrayList<String> retVal = new ArrayList<String>();
        PocketRepository pocketRepository = (PocketRepository)ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
        if (pocketRepository != null) {
            List<NavUserDTO> navUsers = pocketRepository.getOldestUsers(group, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav3")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getSortedUserListFromGroup2(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset = this.safeParseToInt(request.getParameter("offset"));
        int cnt = this.safeParseToInt(request.getParameter("cnt"));
        String filtergroup = request.getParameter("filtergroup");
        ArrayList<String> retVal = new ArrayList<String>();
        PocketRepository pocketRepository = (PocketRepository)ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
        if (pocketRepository != null) {
            List<NavUserDTO> navUsers = pocketRepository.getOldestUsers(group, filtergroup, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s %s %s - date %s", navUser.getUserName(), navUser.getDisplayNameEx(), navUser.getUserEmailEx(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s %s %s - date %s", navUser.getUserNameEx(), navUser.getDisplayNameEx(), navUser.getUserEmailEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav4")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response countSortedUserListFromGroup2(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String filtergroup = request.getParameter("filtergroup");
        ArrayList retVal = new ArrayList();
        PocketRepository pocketRepository = (PocketRepository)ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
        if (pocketRepository != null) {
            long countOldestUsers = pocketRepository.countOldestUsers(group, filtergroup);
            return Response.ok((Object)countOldestUsers).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing pocket").build();
    }

    @Path(value="/nav5")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getNavUserForGroupLtTime(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        long time = this.safeParseToInt(request.getParameter("time"));
        int offset = this.safeParseToInt(request.getParameter("offset"));
        int cnt = this.safeParseToInt(request.getParameter("cnt"));
        ArrayList<String> retVal = new ArrayList<String>();
        PocketRepository pocketRepository = (PocketRepository)ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
        Timestamp ts = new Timestamp(new Date().getTime() - time * 60L * 1000L);
        if (pocketRepository != null) {
            List<NavUserDTO> navUsers = pocketRepository.getNavUserActiveForGroupLtTime(group, ts, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav6")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getNavUserForGroupLtTime2(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        long time = this.safeParseToInt(request.getParameter("time"));
        int offset = this.safeParseToInt(request.getParameter("offset"));
        int cnt = this.safeParseToInt(request.getParameter("cnt"));
        ArrayList<String> retVal = new ArrayList<String>();
        PocketRepository pocketRepository = (PocketRepository)ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
        Timestamp ts = new Timestamp(new Date().getTime() - time * 60L * 1000L);
        if (pocketRepository != null) {
            List<NavUserDTO> navUsers = pocketRepository.getNavUserDisableForGroupLtTime(group, ts, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav7")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getSortedUserListFromGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset = this.safeParseToInt(request.getParameter("offset"));
        int cnt = this.safeParseToInt(request.getParameter("cnt"));
        String filtergroup = request.getParameter("filtergroup");
        ArrayList retVal = new ArrayList();
        List<OldestUser> users = IntelligentUserManagerHelper.getSortedUserListFromGroup(group, offset, cnt, filtergroup);
        for (OldestUser ouser : users) {
            ArrayList<String> uList = new ArrayList<String>();
            uList.add(ouser.getUser().getName());
            uList.add(String.valueOf(ouser.ts));
            uList.add(String.valueOf(ouser.getUser().isActive()));
            uList.add(SDF.format(new Date(ouser.ts)));
            retVal.add(uList);
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/hist1")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAllUserHistoryForGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset = this.safeParseToInt(request.getParameter("offset"));
        int cnt = this.safeParseToInt(request.getParameter("cnt"));
        ArrayList<String> retVal = new ArrayList<String>();
        PocketRepository pocketRepository = (PocketRepository)ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
        if (pocketRepository != null) {
            List<UserHistoryDTO> userHistories = pocketRepository.getAllUserHistoryForGroup(group, offset, cnt);
            for (UserHistoryDTO userHistory : userHistories) {
                if (userHistory.getLastViewTime() != null) {
                    retVal.add(String.format("User %s - date %s", userHistory.getUserName(), SDF.format(userHistory.getLastViewTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", userHistory.getUserName(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/hist2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getOldestUsersFromUserHistory(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset = this.safeParseToInt(request.getParameter("offset"));
        int cnt = this.safeParseToInt(request.getParameter("cnt"));
        ArrayList<String> retVal = new ArrayList<String>();
        PocketRepository pocketRepository = (PocketRepository)ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
        if (pocketRepository != null) {
            List<UserHistoryDTO> userHistories = pocketRepository.getOldestUsersFromUserHistory(group, offset, cnt);
            for (UserHistoryDTO userHistory : userHistories) {
                if (userHistory.getLastViewTime() != null) {
                    retVal.add(String.format("User %s - date %s", userHistory.getUserName(), SDF.format(userHistory.getLastViewTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", userHistory.getUserName(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/hist3")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getUserHistoryForGroupLtTime(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        long time = this.safeParseToInt(request.getParameter("time"));
        int offset = this.safeParseToInt(request.getParameter("offset"));
        int cnt = this.safeParseToInt(request.getParameter("cnt"));
        ArrayList<String> retVal = new ArrayList<String>();
        PocketRepository pocketRepository = (PocketRepository)ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
        long duration = time * 1000L * 60L;
        Timestamp refTime = new Timestamp(System.currentTimeMillis() - duration);
        if (pocketRepository != null) {
            List<UserHistoryDTO> userHistories = pocketRepository.getUserHistoryForGroupLtTime(group, refTime, offset, cnt);
            for (UserHistoryDTO userHistory : userHistories) {
                if (userHistory.getLastViewTime() != null) {
                    retVal.add(String.format("User %s - date %s", userHistory.getUserName(), SDF.format(userHistory.getLastViewTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", userHistory.getUserName(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/hist4")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getNavUserForGroupWithGroupLtTime(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String withGroup = request.getParameter("withGroup");
        long time = this.safeParseToInt(request.getParameter("time"));
        int offset = this.safeParseToInt(request.getParameter("offset"));
        int cnt = this.safeParseToInt(request.getParameter("cnt"));
        ArrayList<String> retVal = new ArrayList<String>();
        long watcherInactivityDuration = TimeUnit.MINUTES.toMillis(ParseUtil.safeParseInt(DAO.getWatcherInactivityDuration(), 0));
        long refTS = System.currentTimeMillis() - watcherInactivityDuration;
        PocketRepository pocketRepository = (PocketRepository)ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
        long duration = time * 1000L * 60L;
        Timestamp refTime = new Timestamp(System.currentTimeMillis() - duration);
        if (pocketRepository != null) {
            List<NavUserDTO> navUserList = pocketRepository.getNavUserForGroupWithGroupLtTime(group, withGroup, new Timestamp(refTS), offset, cnt);
            List<UserHistoryDTO> userHistories = pocketRepository.getUserHistoryForGroupLtTime(group, refTime, offset, cnt);
            for (NavUserDTO navUserDTO : navUserList) {
                if (navUserDTO.getLastViewTime() != null) {
                    retVal.add(String.format("User %s - date %s", navUserDTO.getUserName(), SDF.format(navUserDTO.getLastViewTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUserDTO.getUserName(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Deprecated
    @Path(value="/action2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getActionIUMEnableUsers(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        ArrayList<String> retVal = new ArrayList<String>();
        Collection users = groupManager.getUsersInGroup(group);
        String[] userNames = (String[])users.stream().map(user -> user.getUsername()).toArray(String[]::new);
        NavUserRepository navUserRepository = (NavUserRepository)ComponentAccessor.getOSGiComponentInstanceOfType(NavUserRepository.class);
        if (navUserRepository != null) {
            NavUser[] navUsers;
            for (NavUser navUser : navUsers = navUserRepository.getOldestUsers(userNames, 10)) {
                retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
            }
        }
        return Response.ok(retVal).build();
    }

    @Deprecated
    @Path(value="/action3")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAllNav(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        ArrayList<String> retVal = new ArrayList<String>();
        NavUserRepository navUserRepository = (NavUserRepository)ComponentAccessor.getOSGiComponentInstanceOfType(NavUserRepository.class);
        if (navUserRepository != null) {
            NavUser[] navUsers;
            for (NavUser navUser : navUsers = navUserRepository.getAll()) {
                retVal.add(String.format("User %s %s- date %s", navUser.getUserName(), navUser.toString(), SDF.format(navUser.getLastAccessTime())));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/member1")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getMebershipForUser(@Context HttpServletRequest request) {
        String username = request.getParameter("username");
        ArrayList retVal = new ArrayList();
        PocketRepository pocketRepository = (PocketRepository)ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
        if (pocketRepository != null) {
            List<String> memberships = pocketRepository.getMembershipForUser(username);
            return Response.ok(memberships).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing pocket").build();
    }

    @Path(value="/member2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getMebershipForGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        ArrayList retVal = new ArrayList();
        PocketRepository pocketRepository = (PocketRepository)ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
        if (pocketRepository != null) {
            List<String> memberships = pocketRepository.getMembershipForGroup(group);
            return Response.ok(memberships).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing pocket").build();
    }

    @Path(value="/create")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createUsers(@QueryParam(value="username") String username, @QueryParam(value="password") String password, @QueryParam(value="group") String group, @QueryParam(value="count") Integer count) {
        UserUtil userUtil = ComponentAccessor.getUserUtil();
        if (username != null) {
            try {
                Group parentGroup = groupManager.getGroup(group);
                ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
                for (int i = 1; i <= count; ++i) {
                    String uname = String.format("%s%d", username, i);
                    UserService.CreateUserRequest createUserRequest = UserService.CreateUserRequest.withUserDetails((ApplicationUser)user, (String)uname, (String)password, (String)("aurelian.cruceru+" + uname + "@alten.com"), (String)uname).withNoApplicationAccess();
                    UserService.CreateUserValidationResult result = this.userService.validateCreateUser(createUserRequest = createUserRequest.withNoApplicationAccess().sendNotification(false).skipValidation());
                    if (result.isValid()) {
                        try {
                            ApplicationUser usr = this.userService.createUser(result);
                            groupManager.addUserToGroup(usr, parentGroup);
                            LOG.info("User is created successfully: " + uname);
                        }
                        catch (Exception e) {
                            LOG.error("Cannot create user '" + username + "'!", (Throwable)e);
                        }
                        continue;
                    }
                    LOG.info("Error: " + result.getErrorCollection());
                }
            }
            catch (Exception le) {
                LOG.error("Cannot create user '" + username + "'!", (Throwable)le);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Cannot create user '" + username + "'!")).build();
            }
            catch (Throwable t) {
                LOG.error("Failed to create user '" + username + "'!", t);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Failed to create user '" + username + "'!")).build();
            }
        } else {
            LOG.warn("Cannot add user with null username!");
        }
        return Response.ok().build();
    }

    @Path(value="/log")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setLoggerDebug() {
        org.apache.log4j.Logger.getLogger((String)"de.accxia.jira.addon.IUM").setLevel(Level.DEBUG);
        return Response.ok().build();
    }

    @Path(value="/log2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setLoggerInfo() {
        org.apache.log4j.Logger.getLogger((String)"de.accxia.jira.addon.IUM").setLevel(Level.INFO);
        return Response.ok().build();
    }

    @Path(value="/property")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getProperty() {
        String iumGroups = DAO.getIUMGroups();
        return Response.ok((Object)iumGroups).build();
    }

    @Path(value="/getx")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getValue4tProperty(@QueryParam(value="field") String field) {
        String fieldValue = DAO.getValueX(field);
        return Response.ok((Object)fieldValue).build();
    }

    @Path(value="/setx")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setValue4tProperty(@QueryParam(value="field") String field, @QueryParam(value="value") String value) {
        DAO.setValueX(field, value);
        String fieldValue = DAO.getValueX(field);
        return Response.ok((Object)fieldValue).build();
    }

    private int safeParseToInt(String time) {
        if (time == null || time.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(time);
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    @Path(value="/empty")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setClearDAO() {
        DAO.cleanPluginSettings();
        ConditionEvaluatorImpl.setSideLicense(null);
        return Response.ok((Object)"OK").build();
    }

    @Path(value="/alert1")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAlerts(@Context HttpServletRequest request) {
        String username = request.getParameter("username");
        ArrayList retVal = new ArrayList();
        if (this.iumAlertRepository != null) {
            IUMAlert[] iumAlerts = this.iumAlertRepository.getActiveAlerts();
            List alertList = Arrays.stream(iumAlerts).map(IUMAlertDTO::fromAO).collect(Collectors.toList());
            return Response.ok(alertList).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing alert repository").build();
    }

    @Path(value="/prop")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getProperties(@Context HttpServletRequest request) {
        String username = request.getParameter("username");
        ArrayList<String> retVal = new ArrayList<String>();
        retVal.add(i18Helper.getText("de.accxia.apps.jira.IUM.exceed.license"));
        retVal.add(i18Helper.getText("de.accxia.apps.jira.IUM.copy.group"));
        retVal.add(i18Helper.getText("de.accxia.apps.jira.IUM.removed.group"));
        retVal.add(i18Helper.getText("de.accxia.apps.jira.IUM.copy.group.html"));
        return Response.ok(retVal).build();
    }

    @Path(value="/lic")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getLicense(@Context HttpServletRequest request) {
        ArrayList<String> retVal = new ArrayList<String>();
        if (ConditionEvaluatorImpl.getSideLicense() != null) {
            retVal.add(ConditionEvaluatorImpl.getSideLicense().getAppKey());
            retVal.add(ConditionEvaluatorImpl.getSideLicense().getCustomer());
            retVal.add(String.valueOf(ConditionEvaluatorImpl.getSideLicense().getUsers()));
            retVal.add(ConditionEvaluatorImpl.getSideLicense().getDueDate().toString());
        }
        retVal.add(DAO.getSideLicense());
        return Response.ok(retVal).build();
    }

    @Path(value="/trial")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getHelperTrialProcessing(@Context HttpServletRequest request) {
        ArrayList retVal = new ArrayList();
        List<ProcessResult> processResultList = this.helperTrialProcessing.adjustStatus4FreeVersion(this.jiraAuthenticationContext.getLoggedInUser().getUsername());
        return Response.ok(processResultList).build();
    }

    @Path(value="/event")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response publishJiraEvent(@Context HttpServletRequest request) {
        ArrayList<String> eventsUsers = new ArrayList<String>();
        ArrayList<CounterActionEvent> jiraEventList = new ArrayList<CounterActionEvent>();
        String sourceGroups = DAO.getIUMGroupsDisabled();
        if (!StringUtils.isEmpty((CharSequence)sourceGroups)) {
            String[] groups = sourceGroups.split(",");
            Collection users = groupManager.getUserNamesInGroup(groups[0]);
            for (String user : users) {
                CounterActionEvent event = CounterActionEvent.createCounterActionEvent4Type(CounterActionEventType.ANALYTICAL_EVENT_LOGOUT, user, groups[0]);
                PublisherHelper.emitCounterActionEvent(CounterActionEventType.ANALYTICAL_EVENT_LOGOUT, user, groups[0]);
                eventsUsers.add(user);
                jiraEventList.add(event);
            }
        }
        String databaseInfo = this.chartRepository.getDatabaseInfo();
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("events", jiraEventList);
        retVal.put("users", eventsUsers);
        retVal.put("databaseInfo", databaseInfo);
        return Response.ok(retVal).build();
    }

    @Path(value="/users")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response sendAsyncUserEvent(@Context HttpServletRequest request) {
        try {
            String sourceGroups = DAO.getIUMGroupsDisabled();
            if (!StringUtils.isEmpty((CharSequence)sourceGroups)) {
                String[] groups = sourceGroups.split(",");
                Collection users = groupManager.getUserNamesInGroup(groups[0]);
                ArrayList<String> eventsUsers = new ArrayList<String>();
                for (String user : users) {
                    UserActionEvent event = new UserActionEvent(this.userManagerJira.getUserByName(user), groups[0], UserActionEventType.randomEventType());
                    PublisherHelper.emitUserActionEvent(event.getUser(), event.getGroupName(), event.getEventType());
                    eventsUsers.add(user);
                }
                return Response.ok(eventsUsers).build();
            }
            return Response.serverError().entity((Object)"Missing groups").build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.ok((Object)e.getMessage()).build();
        }
    }

    @Path(value="/evaluation")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response sendEvaluation(@Context HttpServletRequest request) {
        Date date = DateUtil.getDate();
        int month = ParseUtil.safeParseInt(request.getParameter("month"), 5);
        int year = ParseUtil.safeParseInt(request.getParameter("year"), 2025);
        Date startDate = DateUtil.getFirstDayOfMonth(year, month);
        Date endDate = DateUtil.getLastDayOfMonth(year, month);
        List<CounterActionDTO> counterAction = this.licenseAnalyticalService.getCounterActionByInterval(startDate, endDate);
        List<LicenseTierDTO> licenseTier = this.licenseAnalyticalService.getLicenseTierByInterval(startDate, endDate);
        Map<String, List<UserAnalyticalDTO>> userAnalyticalList = this.licenseAnalyticalService.getUserAnalyticalByInterval(startDate, endDate);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("counterAction", counterAction);
        params.put("licenseTier", licenseTier);
        params.put("userAnalytical", userAnalyticalList);
        return Response.ok(params).build();
    }

    @Path(value="/xcounter0")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getCounter0(@Context HttpServletRequest request) {
        ConcurrentHashMap<ServiceMarkerType, CounterActionDTO> counterAction = this.licenseAnalyticalService.getCounterAction();
        LicenseTierDTO licenseTier = this.licenseAnalyticalService.getLicenseTier();
        ConcurrentHashMap<UserReference, UserActivity> action = this.licenseAnalyticalService.getUserActionMap();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("counterAction", counterAction);
        params.put("licenseTier", licenseTier);
        params.put("userAnalytical", action);
        return Response.ok(params).build();
    }

    @Path(value="/xcounter")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getCounter(@Context HttpServletRequest request) {
        this.licenseAnalyticalService.testFlushDatabase();
        return Response.ok((Object)"Ok").build();
    }

    @Path(value="/devent")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteCounterEventAction(@Context HttpServletRequest request) {
        int day = ParseUtil.safeParseInt(request.getParameter("day"), 2);
        int month = ParseUtil.safeParseInt(request.getParameter("month"), 6);
        int year = ParseUtil.safeParseInt(request.getParameter("year"), 2025);
        int deletedCount = this.licenseAnalyticalService.deleteCounterEventByDate(day, month, year);
        Date startDate = DateUtil.getFirstDayOfMonth(year, month);
        Date endDate = DateUtil.getLastDayOfMonth(year, month);
        List<CounterActionDTO> counterAction = this.licenseAnalyticalService.getCounterActionByInterval(startDate, endDate);
        List<LicenseTierDTO> licenseTier = this.licenseAnalyticalService.getLicenseTierByInterval(startDate, endDate);
        Map<String, List<UserAnalyticalDTO>> userAnalyticalList = this.licenseAnalyticalService.getUserAnalyticalByInterval(startDate, endDate);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("deletedCount", deletedCount);
        params.put("counterAction", counterAction);
        params.put("licenseTier", licenseTier);
        params.put("userAnalytical", userAnalyticalList);
        return Response.ok(params).build();
    }
}

