/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.job;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.session.currentusers.JiraUserSession;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.status.JobDetails;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.job.IUMClusterJob;
import de.accxia.jira.addon.IUM.job.JobDataUtils;
import de.accxia.jira.addon.IUM.job.MonitorJobRunner;
import de.accxia.jira.addon.IUM.job.ProcessResult;
import de.accxia.jira.addon.IUM.model.JobResultDTO;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import de.accxia.jira.addon.IUM.servlet.HelperTrialProcessing;
import de.accxia.jira.addon.IUM.servlet.session.AccxiaUserSessionTracker;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/job")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Component
public class JobRestController {
    private static final Logger LOG = LoggerFactory.getLogger(JobRestController.class);
    @ComponentImport
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final MonitorJobRunner monitorJobRunner;
    private final PocketRepository pocketRepository;
    private final JobResultRepository jobResultRepository;
    private final HelperTrialProcessing helperTrialProcessing;
    private static LocalThread localThread = null;

    @Inject
    public JobRestController(MonitorJobRunner monitorJobRunner, PocketRepository pocketRepository, JobResultRepository jobResultRepository, JiraAuthenticationContext jiraAuthenticationContext, HelperTrialProcessing helperTrialProcessing) {
        this.monitorJobRunner = monitorJobRunner;
        this.pocketRepository = pocketRepository;
        this.jobResultRepository = jobResultRepository;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.helperTrialProcessing = helperTrialProcessing;
    }

    @Path(value="/config")
    @GET
    @Produces(value={"application/json"})
    public Response getCurrentConfig() {
        List<JobDetails> details;
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put("repeat_interval", DAO.getRepeatInterval());
        map.put("starting_from", DAO.getStartingFrom());
        map.put("enable_groups", DAO.getIUMGroups());
        map.put("disable_groups", DAO.getIUMGroupsDisabled());
        map.put("working", String.valueOf(this.monitorJobRunner.isWorking(IUMClusterJob.class)));
        if (this.monitorJobRunner.getJobDetails(IUMClusterJob.class) != null) {
            map.put("jobDetails", this.convert2String(this.monitorJobRunner.getJobDetails(IUMClusterJob.class)));
        }
        if ((details = this.monitorJobRunner.getJobsByJobRunnerKey(IUMClusterJob.class)) != null) {
            for (int i = 0; i < details.size(); ++i) {
                map.put("jobDetails" + i, details.get(i).toString());
            }
        }
        if (this.monitorJobRunner.isWorking(IUMClusterJob.class)) {
            map.put("lastRunForJob", this.convert2String(this.monitorJobRunner.getLastRunForJob(IUMClusterJob.class)));
            map.put("lastSuccessfulRunForJob", this.convert2String(this.monitorJobRunner.getLastSuccessfulRunForJob(IUMClusterJob.class)));
            map.put("nextRunDate", this.convert2String(this.monitorJobRunner.getNextRunDate(IUMClusterJob.class)));
        }
        return Response.ok(map).build();
    }

    @Path(value="/config")
    @POST
    @Produces(value={"application/json"})
    public Response setCurrentConfig(@QueryParam(value="repeat_interval") String repeatinterval, @QueryParam(value="starting_from") String startingFrom) {
        DAO.updateRepeatInterval(repeatinterval);
        DAO.updateStartingFrom(startingFrom);
        return this.getCurrentConfig();
    }

    @Path(value="/start")
    @GET
    @Produces(value={"application/json"})
    public Response startDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMClusterJob.class);
            String jobKey = this.monitorJobRunner.doSchedule(JobDataUtils.createFakeIUMJobData(), IUMClusterJob.getInstance());
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/stop")
    @GET
    @Produces(value={"application/json"})
    public Response stopDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMClusterJob.class);
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/runnow")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsJob() {
        try {
            long duration = Long.parseLong(DAO.getRemovalInactivityDuration()) * 60L * 1000L;
            HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
            parameters.put("enable_groups", (Serializable)((Object)DAO.getIUMGroups()));
            parameters.put("inactivity_interval", Long.valueOf(duration));
            String currentUser = this.jiraAuthenticationContext.getLoggedInUser() != null ? this.jiraAuthenticationContext.getLoggedInUser().getUsername() : "IUMPlugin";
            parameters.put("current_user", (Serializable)((Object)currentUser));
            IUMClusterJob.getInstance().injectService(this.helperTrialProcessing, this.pocketRepository, this.jobResultRepository);
            localThread = new LocalThread(currentUser, parameters);
            localThread.start();
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    @Path(value="/jobcheck")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsCheckJob() {
        if (localThread == null) {
            String response = "{\"message\":\"not stating\"}";
            return Response.ok((Object)response).build();
        }
        if (JobRestController.localThread.isWorking) {
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        try {
            if (JobRestController.localThread.errorMessage != null) {
                String response = "{\"message\":\"" + JobRestController.localThread.errorMessage + "\"}";
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
            }
            return Response.ok(JobRestController.localThread.processResultList).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    @Path(value="/jobresults")
    @GET
    @Produces(value={"application/json"})
    public Response getLatestJobResults() {
        if (this.jobResultRepository == null) {
            String response = "{\"message\":\"not stating\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
        List jobResultDTOList = Arrays.stream(this.jobResultRepository.findAll(0, 10)).map(jobResult -> JobResultDTO.fromAO(jobResult)).collect(Collectors.toList());
        return Response.ok(jobResultDTOList).build();
    }

    @Path(value="/session")
    @GET
    @Produces(value={"application/json"})
    public Response getUserSession() {
        try {
            AccxiaUserSessionTracker accxiaUserSessionTracker = AccxiaUserSessionTracker.getInstance();
            List<JiraUserSession> userSessionList = accxiaUserSessionTracker.getAccxiaSnapshot();
            return Response.ok(userSessionList).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    private void doSaveProcessResultList(List<ProcessResult> processResultList, Map<String, Serializable> parameters, long elapsedTime) {
        String currentUser = (String)((Object)parameters.get("current_user"));
        for (ProcessResult processResult : processResultList) {
            this.jobResultRepository.save(JobResultDTO.createJobResult(processResult, currentUser, elapsedTime));
        }
    }

    private <T> String convert2String(T t) {
        return t != null ? t.toString() : "";
    }

    class LocalThread
    extends Thread {
        Map<String, Serializable> parameters;
        String currentUser;
        List<ProcessResult> processResultList = null;
        String errorMessage;
        boolean isWorking;

        public LocalThread(String currentUser, Map<String, Serializable> parameters) {
            this.parameters = parameters;
            this.currentUser = currentUser;
            this.isWorking = false;
            this.errorMessage = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                JobRestController.localThread.isWorking = true;
                IUMClusterJob.getInstance().injectService(JobRestController.this.helperTrialProcessing, JobRestController.this.pocketRepository, JobRestController.this.jobResultRepository);
                this.parameters.put("current_user", (Serializable)((Object)this.currentUser));
                List<ProcessResult> processResultList = IUMClusterJob.getInstance().doProcessingJob(this.parameters);
                long stopTime = System.currentTimeMillis();
                long elapsedTime = stopTime - startTime;
                JobRestController.localThread.processResultList = processResultList;
                JobRestController.this.doSaveProcessResultList(processResultList, this.parameters, elapsedTime);
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                try {
                    JobRestController.localThread.errorMessage = e.getMessage();
                }
                catch (Exception ex) {
                    LOG.error("Exception: " + ex.getMessage(), (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            finally {
                JobRestController.localThread.isWorking = false;
            }
        }
    }
}

