document.addEventListener("DOMContentLoaded", function () {
    if(!AJS.$("#cron-expression").length){
        return
    }

    AJS.$("#cron-expression").on('click', function (e) {
        e.preventDefault();
        AJS.$("#cron-input").val(AJS.$("#cron-expression").val())
        cron-input
        AJS.dialog2("#cron-dialog").show();
    });

    AJS.$("#edit-cron").on('click', function (e) {
        e.preventDefault();
        AJS.$("#cron-input").val(AJS.$("#cron-expression").val())
        AJS.dialog2("#cron-dialog").show();
    });

    AJS.$("#save-cron").on("click", function (e) {
        e.preventDefault();
        AJS.$("#cron-expression").val(AJS.$("#cron-input").val())
        AJS.dialog2("#cron-dialog").hide();
    });

    AJS.$("#cancel-cron").on("click", function (e) {
        e.preventDefault();
        AJS.dialog2("#cron-dialog").hide();
    });

    AJS.$("#cron-input").on("keyup", function (e) {
        e.preventDefault();
        callFutureSchedules(AJS.$('#cronPreview'));
    });

    let callFutureSchedules=function(resultDiv){
        let cronExpression=AJS.$("#cron-input").val()

        // Validate using server-side API
        fetch(AJS.contextPath() + '/rest/IUM/latest/cron/validate?cronExpression=' + encodeURIComponent(cronExpression), {
            contentType: "application/json; charset=utf-8",
            method: 'GET'
        })
            .then(response => response.json())
            .then(data => {

                var html;
                if (!data.error && data.futureSchedules) {
                    $('#save-cron').prop('disabled', false);

                    var prevDate = null;
                    var rows = '';
                    for (var i = 0; i < data.futureSchedules.length; i++) {
                        var date = data.futureSchedules[i].date;
                        var time = data.futureSchedules[i].time;

                        let rowData ={
                            date: (date == prevDate) ? '&nbsp;' : date,
                            time: time
                        }

                        rows += AJS.$('script[title="future-schedules-row"]').html()
                            .replace(/{\s*(\w+)\s*}/g, (_, key) => rowData[key] || '');

                        prevDate = date;
                    }

                    let tableRows= { rows: rows }
                    html = AJS.$('script[title="future-schedules-table"]').html()
                        .replace(/{\s*(\w+)\s*}/g, (_, key) => tableRows[key] || '');

                } else {
                    // An error occurred
                    $('#save-cron').prop('disabled', true);
                    let tableRows= { dataError: (data.reason && (' - ' + data.reason)) || '' }
                    html = AJS.$('script[title="validation-error"]').html()
                        .replace(/{\s*(\w+)\s*}/g, (_, key) => tableRows[key] || '');
                }

                resultDiv.html(html);

            })
            .catch(error => console.error('Error:', error));
    };

    let saveButton = document.getElementById("save-cron");

    // Validate and save cron expression
    saveButton.addEventListener("click", function () {
        let cronExpression=AJS.$("#cron-input").val()
        // Update input field in the form
        document.getElementById("cron-expression").value = cronExpression;
        AJS.dialog2("#cron-dialog").hide();

    });


});
