/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.agents;

import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.type.ProjectTypeKeys;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserFilter;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.jira.issue.ServiceDeskIssueService;
import com.atlassian.servicedesk.internal.api.search.issue.callback.DataCallback;
import com.atlassian.servicedesk.internal.api.search.issue.service.IssueDataService;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManager;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.google.gson.Gson;
import de.accxia.jira.addon.IUM.agents.AgentResponse;
import de.accxia.jira.addon.IUM.agents.AgentResultsResponse;
import de.accxia.jira.addon.IUM.agents.AgentWorkload;
import de.accxia.jira.addon.IUM.agents.AgentWorkloadDetails;
import de.accxia.jira.addon.IUM.agents.IssueCountByAssigneeDataCallback;
import de.accxia.jira.addon.IUM.config.DAO;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentWorkloadImpl
implements AgentWorkload {
    private static final Logger log = LoggerFactory.getLogger(AgentWorkloadImpl.class);
    private final ApplicationRoleManager applicationRoleManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectManager projectManager;
    private final AvatarService avatarService;
    private UserManager userManager;
    private UserSearchManager userSearchManager;
    private UserFactory userFactory;
    private IssueDataService issueDataService;
    private ServiceDeskService serviceDeskService;
    private ServiceDeskIssueService serviceDeskIssueService;
    private ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private static final GroupManager groupManager = ComponentAccessor.getGroupManager();

    public AgentWorkloadImpl(@ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport ProjectManager projectManager, @ComponentImport AvatarService avatarService, @ComponentImport ApplicationRoleManager applicationRoleManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.avatarService = avatarService;
        this.projectManager = projectManager;
        this.applicationRoleManager = applicationRoleManager;
        try {
            this.userManager = ComponentAccessor.getUserManager();
            this.userSearchManager = (UserSearchManager)ComponentAccessor.getOSGiComponentInstanceOfType(UserSearchManager.class);
            this.userFactory = (UserFactory)ComponentAccessor.getOSGiComponentInstanceOfType(UserFactory.class);
            this.issueDataService = (IssueDataService)ComponentAccessor.getOSGiComponentInstanceOfType(IssueDataService.class);
            this.serviceDeskService = (ServiceDeskService)ComponentAccessor.getOSGiComponentInstanceOfType(ServiceDeskService.class);
            this.serviceDeskIssueService = (ServiceDeskIssueService)ComponentAccessor.getOSGiComponentInstanceOfType(ServiceDeskIssueService.class);
            this.serviceDeskLicenseAndPermissionService = (ServiceDeskLicenseAndPermissionService)ComponentAccessor.getOSGiComponentInstanceOfType(ServiceDeskLicenseAndPermissionService.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public AgentResultsResponse searchAgentWorkloadForProject(String todoQuery, Boolean searchAll, String projectKey, Set<String> users, Set<String> groups) {
        List currentIssueBatch;
        if (this.userSearchManager == null || this.serviceDeskService == null) {
            return AgentResultsResponse.EMPTY;
        }
        Project project = this.projectManager.getProjectByCurrentKey(projectKey);
        if (project == null) {
            return AgentResultsResponse.EMPTY;
        }
        Long projectId = project.getId();
        ServiceDesk serviceDesk = this.serviceDeskService.getServiceDeskForProject(this.jiraAuthenticationContext.getLoggedInUser(), project);
        ApplicationUser applicationUser = this.jiraAuthenticationContext.getLoggedInUser();
        CheckedUser checkedUser = this.userFactory.wrap(applicationUser);
        List<String> filterGroups = ProjectTypeKeys.SERVICE_DESK.equals((Object)project.getProjectTypeKey()) ? Collections.singletonList(DAO.getIUMSDeskGroupsDisabled()) : Collections.singletonList(DAO.getIUMSoftGroupsDisabled());
        UserSearchParams userSearchParams = new UserSearchParams.Builder(1000).filterByProjectIds(Arrays.asList(projectId)).filter(new UserFilter(true, null, groups)).allowEmptyQuery(true).includeActive(true).includeInactive(false).ignorePermissionCheck(true).maxResults(Integer.valueOf(1000)).build();
        Query query = JqlQueryBuilder.newBuilder().where().project(new Long[]{projectId}).and().unresolved().and().not().assigneeIsEmpty().buildQuery();
        IssueCountByAssigneeDataCallback issueKeyCallback = new IssueCountByAssigneeDataCallback();
        this.issueDataService.find(applicationUser, query, (DataCallback)issueKeyCallback);
        Map<String, Long> mapIssueKeyCallback = issueKeyCallback.getCounts();
        List agentUserList = this.userSearchManager.search(todoQuery, userSearchParams).collect(Collectors.toList());
        users.stream().map(usr -> this.userManager.getUserByKey(usr)).forEach(user -> agentUserList.add(user));
        List<CheckedUser> filterAgentUserList = searchAll != false ? agentUserList.stream().filter(aUser -> !groupManager.isUserInGroup(aUser.getName(), DAO.getIUMSDeskGroupsEnable())).map(aUser -> this.userFactory.wrap(aUser)).collect(Collectors.toList()) : agentUserList.stream().filter(aUser -> mapIssueKeyCallback.containsKey(aUser.getKey())).filter(aUser -> !groupManager.isUserInGroup(aUser.getName(), DAO.getIUMSDeskGroupsEnable())).map(aUser -> this.userFactory.wrap(aUser)).collect(Collectors.toList());
        int currentPage = 0;
        HashMap<String, AgentWorkloadDetails> resultsMap = new HashMap<String, AgentWorkloadDetails>();
        do {
            currentIssueBatch = this.serviceDeskIssueService.getPagedAssignedAndUnresolvedIssues(checkedUser, project, filterAgentUserList, Integer.valueOf(currentPage));
            Map<String, List<Issue>> currentBatchGroupedByAssignee = this.groupBatchByAssignee(currentIssueBatch);
            this.addToResultMap(resultsMap, project, filterAgentUserList, currentBatchGroupedByAssignee);
            ++currentPage;
        } while (!currentIssueBatch.isEmpty());
        List<AgentResponse> agentResponses = filterAgentUserList.stream().map(this::buildAgentResponse).collect(Collectors.toList());
        AgentResultsResponse agentResultsResponse = new AgentResultsResponse("", agentResponses.size(), agentResponses, resultsMap);
        return agentResultsResponse;
    }

    @Override
    public AgentResultsResponse fromString(String jsonString) {
        Gson gson = new Gson();
        AgentResultsResponse agentResultsResponse = gson.fromJson(jsonString, AgentResultsResponse.class);
        return agentResultsResponse;
    }

    @Override
    public String toString(AgentResultsResponse agentResultsResponse) {
        Gson gson = new Gson();
        String jsonString = gson.toJson(agentResultsResponse);
        return jsonString;
    }

    @Override
    public AgentResultsResponse mergeAgentResultsResponse(AgentResultsResponse enabledAgents, AgentResultsResponse disableAgents) {
        int count = enabledAgents.getTotal();
        Set keys = enabledAgents.getResults().stream().map(AgentResponse::getKey).collect(Collectors.toSet());
        disableAgents.getResults().stream().filter(agentResponse -> !keys.contains(agentResponse.getKey())).forEach(agentResponse -> enabledAgents.getResults().add((AgentResponse)agentResponse));
        count = enabledAgents.getResults().size() - count;
        enabledAgents.getAgentWorkloads().putAll(disableAgents.getAgentWorkloads());
        enabledAgents.add2Total(count);
        return enabledAgents;
    }

    private void addToResultMap(Map<String, AgentWorkloadDetails> resultsMap, Project project, List<CheckedUser> filterAgentUserList, Map<String, List<Issue>> currentBatchGroupedByAssignee) {
        currentBatchGroupedByAssignee.forEach((userKey, issues) -> {
            if (!resultsMap.containsKey(userKey)) {
                String username = filterAgentUserList.stream().filter(aUser -> userKey.equals(aUser.getKey())).findFirst().map(aUser -> aUser.getName()).orElse("");
                String jql = String.format("assignee=%s AND resolution=Unresolved AND project=%s", username, project.getKey());
                resultsMap.put((String)userKey, new AgentWorkloadDetails(0L, jql));
            }
            ((AgentWorkloadDetails)resultsMap.get(userKey)).add2Totals(issues.size());
        });
    }

    private Map<String, List<Issue>> groupBatchByAssignee(List<Issue> issueList) {
        return issueList.stream().collect(Collectors.groupingBy(Issue::getAssigneeId));
    }

    private AgentResponse buildAgentResponse(CheckedUser applicationUser) {
        return AgentResponse.build(applicationUser, this.serviceDeskLicenseAndPermissionService.canAdministerJIRA((SDUser)applicationUser), this.getAvatarUrls(applicationUser.forJIRA()));
    }

    private AgentResponse.AvatarUrls getAvatarUrls(ApplicationUser applicationUser) {
        return new AgentResponse.AvatarUrls(this.avatarService.getAvatarURL(applicationUser, applicationUser, Avatar.Size.SMALL).toString(), this.avatarService.getAvatarURL(applicationUser, applicationUser, Avatar.Size.MEDIUM).toString(), this.avatarService.getAvatarURL(applicationUser, applicationUser, Avatar.Size.LARGE).toString());
    }
}

