/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.job;

import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;
import de.accxia.jira.addon.IUM.job.IUMWatcherJob;
import de.accxia.jira.addon.IUM.job.JobData;
import de.accxia.jira.addon.IUM.job.JobDataUtils;
import de.accxia.jira.addon.IUM.job.MonitorJobRunner;
import de.accxia.jira.addon.IUM.job.Mutex;
import de.accxia.jira.addon.IUM.model.JobResult;
import de.accxia.jira.addon.IUM.model.JobResultDTO;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={JobWatchService.class})
@Named(value="JobWatchService")
public class JobWatchService {
    private static final Logger LOG = LoggerFactory.getLogger(JobWatchService.class);
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final MonitorJobRunner monitorJobRunner;
    private final JobResultRepository jobResultRepository;
    private final ApplicationRoleManager applicationRoleManager;
    private static UserUtil userUtil = ComponentAccessor.getUserUtil();

    public JobWatchService(MonitorJobRunner monitorJobRunner, JobResultRepository jobResultRepository, ApplicationRoleManager applicationRoleManager) {
        this.monitorJobRunner = monitorJobRunner;
        this.jobResultRepository = jobResultRepository;
        this.applicationRoleManager = applicationRoleManager;
    }

    public boolean start() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JobWatchService call start");
            }
            this.monitorJobRunner.doUnSchedule(IUMWatcherJob.class);
            this.monitorJobRunner.doSchedule(JobDataUtils.createIUMWatcherJobData(), IUMWatcherJob.getInstance());
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean stop() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JobWatchService doStop");
            }
            this.monitorJobRunner.doUnSchedule(IUMWatcherJob.class);
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean restart() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JobWatchService call restart");
            }
            this.monitorJobRunner.doUnSchedule(IUMWatcherJob.class);
            JobData jobData = JobDataUtils.createIUMWatcherJobData();
            jobData.getParameters().put("restart", Boolean.TRUE);
            this.monitorJobRunner.doSchedule(jobData, IUMWatcherJob.getInstance());
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean isWorking() {
        return this.monitorJobRunner.isWorking(IUMWatcherJob.class);
    }

    public JobDetails getJobDetails() {
        return this.monitorJobRunner.getJobDetails(IUMWatcherJob.class);
    }

    public Date getNextRunDate() {
        return this.monitorJobRunner.getNextRunDate(IUMWatcherJob.class);
    }

    public void updateLastRunTime(long timestamp) {
        this.monitorJobRunner.updateLastRunTime(IUMWatcherJob.class, timestamp);
    }

    public Date calculateNextRunTime() {
        return this.monitorJobRunner.calculateNextRunTime(IUMWatcherJob.class, 0L);
    }

    public RunDetails getLastSuccessfulRunForJob() {
        return this.monitorJobRunner.getLastSuccessfulRunForJob(IUMWatcherJob.class);
    }

    public List<JobResultDTO> findLatest(int idx, int ctx) {
        JobResult[] jobResults = this.jobResultRepository.findAll(new String[]{"LevelJob"}, idx, ctx);
        List<JobResultDTO> jobResultDTOList = Arrays.stream(jobResults).map(jobResult -> JobResultDTO.fromAO(jobResult)).collect(Collectors.toList());
        return jobResultDTOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPreparation() {
        boolean locked = false;
        try {
            locked = Mutex.MUTEX.tryLock(100L, TimeUnit.MILLISECONDS);
            if (locked) {
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                Future retVal = executorService.submit(new Callable(){

                    public Boolean call() throws Exception {
                        return JobWatchService.this.doLocalRunPreparation();
                    }
                });
                LOG.info("WatchService run #[" + SDF.format(new Date()) + "] ");
            }
        }
        catch (Exception e) {
            LOG.error("WatchService Process #[" + SDF.format(new Date()) + "] " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (locked) {
                Mutex.MUTEX.unlock();
            }
        }
    }

    public Boolean doLocalRunPreparation() {
        boolean locked = false;
        try {
            locked = Mutex.MUTEX.tryLock(100L, TimeUnit.MILLISECONDS);
            if (locked && LOG.isDebugEnabled()) {
                LOG.debug("WatchService Process #[" + SDF.format(new Date()) + "] ");
            }
            Boolean bl = Boolean.TRUE;
            return bl;
        }
        catch (Exception e) {
            LOG.error("IUMWatcherJob Process #[" + SDF.format(new Date()) + "] " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (locked) {
                Mutex.MUTEX.unlock();
            }
        }
        return Boolean.FALSE;
    }
}

