/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ImageServletUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ImageServletUtil.class);
    @ComponentImport
    private final JiraHome jiraHome;

    public ImageServletUtil(JiraHome jiraHome) {
        this.jiraHome = jiraHome;
    }

    public void processGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        File uploadPath = this.getUploadsDirectory();
        String fileName = request.getParameter("fileName");
        if (fileName == null || fileName.isEmpty()) {
            response.sendError(400, "File name parameter is missing");
            return;
        }
        File imageFile = new File(uploadPath, fileName);
        LOG.info("Processing image file: " + imageFile.getAbsolutePath());
        if (!imageFile.exists()) {
            LOG.info("Processing imageFile missing  " + imageFile.getAbsolutePath());
            response.sendError(404, "Image file not found");
            return;
        }
        response.setContentType("image/png");
        response.setContentLength((int)imageFile.length());
        FileInputStream fileInputStream = new FileInputStream(imageFile);
        ServletOutputStream out = response.getOutputStream();
        byte[] buf = new byte[1024];
        int count = 0;
        while ((count = fileInputStream.read(buf)) >= 0) {
            out.write(buf, 0, count);
        }
        out.close();
        fileInputStream.close();
    }

    public File getUploadsDirectory() {
        File homeDirectory = this.jiraHome.getHome();
        File uploadDirectory = new File(homeDirectory, "uploads");
        if (!uploadDirectory.exists()) {
            uploadDirectory.mkdirs();
        }
        return uploadDirectory;
    }
}

