/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet;

import de.accxia.jira.addon.IUM.analytical.ChartRepository;
import de.accxia.jira.addon.IUM.analytical.CounterActionDTO;
import de.accxia.jira.addon.IUM.analytical.LicenseAnalyticalService;
import de.accxia.jira.addon.IUM.analytical.LicenseTierDTO;
import de.accxia.jira.addon.IUM.analytical.model.AuditRequest;
import de.accxia.jira.addon.IUM.analytical.model.UserPeak;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.utils.DateUtil;
import de.accxia.jira.addon.IUM.utils.ParseUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/charts")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RestChartsData {
    private static final Logger LOG = LoggerFactory.getLogger(RestChartsData.class);
    private final LicenseAnalyticalService licenseAnalyticalService;
    private final ChartRepository chartRepository;

    @Inject
    public RestChartsData(LicenseAnalyticalService licenseAnalyticalService, ChartRepository chartRepository) {
        this.licenseAnalyticalService = licenseAnalyticalService;
        this.chartRepository = chartRepository;
    }

    @GET
    @Path(value="/userpeak")
    public Response userpeak(@Context HttpServletRequest req) {
        String strYear = req.getParameter("year");
        String strMonth = req.getParameter("month");
        int year = ParseUtil.safeParseInt(strYear);
        int month = ParseUtil.safeParseInt(strMonth);
        Date startDate = DateUtil.getFirstDayOfMonth(year, month);
        Date endDate = DateUtil.getLastDayOfMonth(year, month);
        List<UserPeak> userPeaks = this.chartRepository.userPeaksForInterval(startDate, endDate);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userPeaks", userPeaks);
        params.put("chartLabel", "User peak and Queue display");
        params.put("userPeakLabel", "User Peak");
        params.put("userBannerLabel", "Queue");
        params.put("days", DateUtil.getDaysInMonth(year, month));
        params.put("month", DateUtil.getMonthName(month));
        params.put("chartTitle", "User peak and Queue display");
        params.put("chartJiraFileName", "user-jira-peak");
        params.put("chartJSMFileName", "user-jsm-peak");
        return Response.ok(params).build();
    }

    @GET
    @Path(value="/licenses")
    public Response licenses(@Context HttpServletRequest req) {
        String strYear = req.getParameter("year");
        String strMonth = req.getParameter("month");
        int year = ParseUtil.safeParseInt(strYear);
        int month = ParseUtil.safeParseInt(strMonth);
        Date startDate = DateUtil.getFirstDayOfMonth(year, month);
        Date endDate = DateUtil.getLastDayOfMonth(year, month);
        List<LicenseTierDTO> licenseTierList = this.licenseAnalyticalService.getLicenseTierByInterval(startDate, endDate);
        List<UserPeak> userPeaks = this.chartRepository.userPeaksForInterval(startDate, endDate);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("licenseTiers", licenseTierList);
        params.put("userPeaks", userPeaks);
        params.put("chartLabel", "User and Licenses");
        params.put("iumJiraTotalUsersLabel", "Jira Total Users");
        params.put("iumJSMTotalUsersLabel", "JSM Total Users");
        params.put("jiraUserTierLabel", "Jira Users with fix license");
        params.put("jsmUserTierLabel", "JSM Users with fix license");
        params.put("iumJiraUserTierLabel", "Jira IUM Users");
        params.put("iumJSMUserTierLabel", "JSM IUM Users");
        params.put("jiraLicenseTierLabel", "Jira license tier");
        params.put("jsmLicenseTierLabel", "JSM license tier");
        params.put("iumJiraLicenseTierLabel", "Jira IUM Shared license");
        params.put("iumJSMLicenseTierLabel", "JSM IUM Shared license");
        params.put("peakJiraUserLabel", "Jira User Peak");
        params.put("peakJSMUserLabel", "JSM User Peak");
        params.put("days", DateUtil.getDaysInMonth(year, month));
        params.put("month", DateUtil.getMonthName(month));
        params.put("chartTitle", "User and Licenses");
        params.put("chartJiraFileName", "ium-jira-user-and-licenses");
        params.put("chartJSMFileName", "ium-jsm-user-and-licenses");
        return Response.ok(params).build();
    }

    @GET
    @Path(value="/revocation")
    public Response revocation(@Context HttpServletRequest req) {
        String strYear = req.getParameter("year");
        String strMonth = req.getParameter("month");
        int year = ParseUtil.safeParseInt(strYear);
        int month = ParseUtil.safeParseInt(strMonth);
        Date startDate = DateUtil.getFirstDayOfMonth(year, month);
        Date endDate = DateUtil.getLastDayOfMonth(year, month);
        List<CounterActionDTO> counterActionList = this.licenseAnalyticalService.getCounterActionByInterval(startDate, endDate);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("counterActions", counterActionList);
        params.put("chartLabel", "IUM License and Revocation");
        params.put("iumJiraLicenseLabel", "Jira Licenses assigned by IUM");
        params.put("iumJSMLicenseLabel", "JSM Licenses assigned by IUM");
        params.put("totalJiraUsersRemovedLabel", "Jira Total Number of users removed by IUM");
        params.put("totalJSMUsersRemovedLabel", "JSM Total Number of users removed by IUM");
        params.put("logoutJiraUserLabel", "by IUM Jira user logout");
        params.put("logoutJSMUserLabel", "by IUM JSM user logout");
        params.put("licenseJiraRequestLabel", "by another IUM Jira user");
        params.put("licenseJSMRequestLabel", "by another IUM JSM user");
        params.put("autoJiraRemovalUserLabel", "by Jira auto removal");
        params.put("autoJSMRemovalUserLabel", "by JSM auto removal");
        params.put("groupJiraRemovalUserLabel", "by Jira group level removal");
        params.put("groupJSMRemovalUserLabel", "by JSM group level removal");
        params.put("days", DateUtil.getDaysInMonth(year, month));
        params.put("month", DateUtil.getMonthName(month));
        params.put("chartTitle", "IUM License and Revocation");
        params.put("chartJiraFileName", "ium-jira-statistics");
        params.put("chartJSMFileName", "ium-jsm-statistics");
        return Response.ok(params).build();
    }

    @GET
    @Path(value="/userpeak2")
    public Response userpeak2(@Context HttpServletRequest req) {
        String strYear = req.getParameter("year");
        String strMonth = req.getParameter("month");
        int year = ParseUtil.safeParseInt(strYear);
        int month = ParseUtil.safeParseInt(strMonth);
        Date startDate = DateUtil.getFirstDayOfMonth(year, month);
        Date endDate = DateUtil.getLastDayOfMonth(year, month);
        List<UserPeak> userPeaks = this.chartRepository.userPeaksForInterval2(startDate, endDate);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userPeaks", userPeaks);
        params.put("chartLabel", "User peak and Queue display");
        params.put("userPeakLabel", "User Peak");
        params.put("userBannerLabel", "Queue");
        params.put("days", DateUtil.getDaysInMonth(year, month));
        params.put("month", DateUtil.getMonthName(month));
        params.put("chartTitle", "User peak and Queue display");
        params.put("chartJiraFileName", "user-jira-peak");
        params.put("chartJSMFileName", "user-jsm-peak");
        return Response.ok(params).build();
    }

    @POST
    @Path(value="/auditstatus")
    public Response updateAuditStatus(@Context HttpServletRequest req, AuditRequest auditRequest) {
        if (auditRequest != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(auditRequest.toString());
            }
            DAO.updateAuditStatus(auditRequest.isAuditStatus() ? "true" : "false");
        }
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("auditRequest", DAO.getAuditStatus());
        return Response.ok(params).build();
    }

    @POST
    @Path(value="/dropaudit")
    public Response dropAuditData(@Context HttpServletRequest req) {
        boolean retVal = this.chartRepository.truncateTable();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("drop", retVal);
        return Response.ok(params).build();
    }
}

