/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.analytical;

import de.accxia.jira.addon.IUM.analytical.PermissionMarkerType;
import de.accxia.jira.addon.IUM.analytical.UserActivity;
import de.accxia.jira.addon.IUM.analytical.UserAnalytical;
import de.accxia.jira.addon.IUM.analytical.UserReference;
import de.accxia.jira.addon.IUM.utils.DateUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class UserAnalyticalDTO {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    private Integer ID;
    private String username;
    private PermissionMarkerType permJira;
    private PermissionMarkerType permJsm;
    private PermissionMarkerType permAdmin;
    private PermissionMarkerType permIumJira;
    private PermissionMarkerType permIumJsm;
    private int banned;
    private int jobBanned;
    private int activated;
    private int actionHour;
    private Date actionDate;
    public static Comparator<UserAnalyticalDTO> USER_ANALYTICAL_COMPARATOR = new Comparator<UserAnalyticalDTO>(){

        @Override
        public int compare(UserAnalyticalDTO e1, UserAnalyticalDTO e2) {
            if (e1 == null && e2 == null) {
                return 0;
            }
            if (e1 == null) {
                return -1;
            }
            if (e2 == null) {
                return 1;
            }
            int result = e1.getUsername().compareTo(e2.getUsername());
            if (result != 0) {
                return result;
            }
            result = Integer.compare(e1.getActionHour(), e2.getActionHour());
            if (result != 0) {
                return result;
            }
            if (DateUtil.isSameDay(e1.getActionDate(), e2.getActionDate())) {
                return 0;
            }
            return 1;
        }
    };

    public UserAnalyticalDTO(Integer ID, String username, PermissionMarkerType permJira, PermissionMarkerType permJsm, PermissionMarkerType permIumJira, PermissionMarkerType permIumJsm, PermissionMarkerType permAdmin, int banned, int actionHour, Date actionDate) {
        this.ID = ID;
        this.username = username;
        this.permJira = permJira;
        this.permJsm = permJsm;
        this.permIumJira = permIumJira;
        this.permIumJsm = permIumJsm;
        this.permAdmin = permAdmin;
        this.banned = banned;
        this.jobBanned = this.jobBanned;
        this.actionHour = actionHour;
        this.actionDate = actionDate;
    }

    public UserAnalyticalDTO(UserReference userReference, UserActivity userActivity) {
        this.username = userReference.getUserName();
        this.permJira = PermissionMarkerType.PERMISSION_NONE;
        this.permJsm = PermissionMarkerType.PERMISSION_NONE;
        this.permIumJira = PermissionMarkerType.PERMISSION_NONE;
        this.permIumJsm = PermissionMarkerType.PERMISSION_NONE;
        this.permAdmin = PermissionMarkerType.PERMISSION_NONE;
        this.banned = userActivity.getBanned();
        this.jobBanned = userActivity.getJobBanned();
        this.actionHour = userReference.getHour();
        this.actionDate = userReference.getDate();
    }

    protected UserAnalyticalDTO() {
    }

    public static UserAnalyticalDTO fromAO(UserAnalytical userAnalytical) {
        UserAnalyticalDTO userAnalyticalDTO = new UserAnalyticalDTO();
        if (userAnalytical != null) {
            userAnalyticalDTO.setID(userAnalytical.getID());
            userAnalyticalDTO.setUsername(userAnalytical.getUsername());
            userAnalyticalDTO.setPermJira(PermissionMarkerType.from(userAnalytical.getJira()));
            userAnalyticalDTO.setPermJsm(PermissionMarkerType.from(userAnalytical.getJsm()));
            userAnalyticalDTO.setPermIumJira(PermissionMarkerType.from(userAnalytical.getIumJira()));
            userAnalyticalDTO.setPermIumJsm(PermissionMarkerType.from(userAnalytical.getIumJsm()));
            userAnalyticalDTO.setPermAdmin(PermissionMarkerType.from(userAnalytical.getAdmin()));
            userAnalyticalDTO.setBanned(userAnalytical.getBanned());
            userAnalyticalDTO.setJobBanned(userAnalytical.getJobBanned());
            userAnalyticalDTO.setActionHour(userAnalytical.getActionHour());
            userAnalyticalDTO.setActionDate(userAnalytical.getActionDate());
        }
        return userAnalyticalDTO;
    }

    public static List<UserAnalyticalDTO> fromAOs(UserAnalytical[] userAnalytical) {
        ArrayList<UserAnalyticalDTO> userAnalyticalList = new ArrayList<UserAnalyticalDTO>();
        if (userAnalytical != null) {
            for (UserAnalytical ua : userAnalytical) {
                userAnalyticalList.add(UserAnalyticalDTO.fromAO(ua));
            }
        }
        return userAnalyticalList;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAnalyticalDTO that = (UserAnalyticalDTO)o;
        return Objects.equals(this.username, that.username) && this.actionHour == that.actionHour && DateUtil.isSameDay(that.actionDate, that.actionDate);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.username);
        result = 31 * result + this.actionHour;
        result = 31 * result + Objects.hashCode(this.actionDate);
        return result;
    }

    public Integer getID() {
        return this.ID;
    }

    public void setID(Integer ID) {
        this.ID = ID;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public PermissionMarkerType getPermJira() {
        return this.permJira;
    }

    public void setPermJira(PermissionMarkerType permJira) {
        this.permJira = permJira;
    }

    public PermissionMarkerType getPermJsm() {
        return this.permJsm;
    }

    public void setPermJsm(PermissionMarkerType permJsm) {
        this.permJsm = permJsm;
    }

    public PermissionMarkerType getPermIumJira() {
        return this.permIumJira;
    }

    public void setPermIumJira(PermissionMarkerType permIumJira) {
        this.permIumJira = permIumJira;
    }

    public PermissionMarkerType getPermIumJsm() {
        return this.permIumJsm;
    }

    public void setPermIumJsm(PermissionMarkerType permIumJsm) {
        this.permIumJsm = permIumJsm;
    }

    public PermissionMarkerType getPermAdmin() {
        return this.permAdmin;
    }

    public void setPermAdmin(PermissionMarkerType permAdmin) {
        this.permAdmin = permAdmin;
    }

    public int getBanned() {
        return this.banned;
    }

    public void setBanned(int banned) {
        this.banned = banned;
    }

    public int getJobBanned() {
        return this.jobBanned;
    }

    public void setJobBanned(int jobBanned) {
        this.jobBanned = jobBanned;
    }

    public int getActivated() {
        return this.activated;
    }

    public void setActivated(int activated) {
        this.activated = activated;
    }

    public int getActionHour() {
        return this.actionHour;
    }

    public void setActionHour(int actionHour) {
        this.actionHour = actionHour;
    }

    public Date getActionDate() {
        return this.actionDate;
    }

    public void setActionDate(Date actionDate) {
        this.actionDate = actionDate;
    }

    public String getActionDateAsYYYYMMDD() {
        if (this.actionDate != null) {
            return sdf.format(this.actionDate);
        }
        return "";
    }

    public String toString() {
        return "UserAnalyticalDTO{ID=" + this.ID + ", username='" + this.username + "', permJira=" + this.permJira + ", permJsm=" + this.permJsm + ", permIumJira=" + this.permIumJira + ", permIumJsm=" + this.permIumJsm + ", permAdmin=" + this.permAdmin + ", banned=" + this.banned + ", jobBanned=" + this.jobBanned + ", actionHour=" + this.actionHour + ", actionDate=" + this.actionDate + "}";
    }
}

