/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.impl;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import de.accxia.jira.addon.IUM.analytical.CounterActionEvent;
import de.accxia.jira.addon.IUM.analytical.CounterActionEventType;
import de.accxia.jira.addon.IUM.analytical.UserActionEvent;
import de.accxia.jira.addon.IUM.analytical.UserActionEventType;
import de.accxia.jira.addon.IUM.config.DAO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublisherHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PublisherHelper.class);
    private static EventPublisher eventPublisher;
    private static UserManager userManagerJira;

    public static EventPublisher getEventPublisher() {
        if (eventPublisher == null) {
            eventPublisher = (EventPublisher)ComponentAccessor.getComponent(EventPublisher.class);
        }
        return eventPublisher;
    }

    public static void emitCounterActionEvent(CounterActionEventType counterActionEventType, int quantity, String userName, String groupName) {
        if (DAO.getAuditStatus() && counterActionEventType != null) {
            PublisherHelper.getEventPublisher().publish((Object)CounterActionEvent.createCounterActionEvent4Type(counterActionEventType, quantity, userName, groupName));
        }
    }

    public static void emitCounterActionEvent(CounterActionEventType counterActionEventType, String userName, String groupName) {
        if (DAO.getAuditStatus() && counterActionEventType != null) {
            PublisherHelper.getEventPublisher().publish((Object)CounterActionEvent.createCounterActionEvent4Type(counterActionEventType, userName, groupName));
        }
    }

    public static void emitUserActionEvent(ApplicationUser user, String groupName, UserActionEventType userActionEventType) {
        if (DAO.getAuditStatus() && userActionEventType != null && user != null) {
            PublisherHelper.getEventPublisher().publish((Object)UserActionEvent.createUserActionEvent4Type(user, groupName, userActionEventType));
        }
    }

    public static void emitUserActionEvent(List<String> userName, String groupName, UserActionEventType userActionEventType) {
        if (DAO.getAuditStatus() && userActionEventType != null && userName != null) {
            for (String name : userName) {
                ApplicationUser user = userManagerJira.getUserByName(name);
                if (user != null) {
                    PublisherHelper.getEventPublisher().publish((Object)UserActionEvent.createUserActionEvent4Type(user, groupName, userActionEventType));
                    continue;
                }
                LOG.warn("emitUserActionEvent: User not found for userName={}", (Object)name);
            }
        }
    }

    static {
        userManagerJira = ComponentAccessor.getUserManager();
    }
}

