/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.repository;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.jira.addon.IUM.model.NavUser;
import de.accxia.jira.addon.IUM.model.NavUserDTO;
import de.accxia.jira.addon.IUM.repository.UtilRepository;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={NavUserRepository.class})
@Named(value="NavUserRepository")
public class NavUserRepository {
    private static final Logger logger = LoggerFactory.getLogger(NavUserRepository.class);
    @ComponentImport
    private final ActiveObjects ao;

    @Inject
    public NavUserRepository(ActiveObjects ao) {
        this.ao = ao;
    }

    public NavUser save(NavUserDTO navUserDTO) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called save for user {}", (Object)navUserDTO.getUserName());
        }
        if (!UtilRepository.checkAO(this.ao)) {
            return null;
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("REQUEST_COUNT", navUserDTO.getRequestCount());
        values.put("USER_NAME", navUserDTO.getUserName());
        values.put("LAST_ACCESS_TIME", navUserDTO.getLastAccessTime());
        values.put("CREATION_TIME", navUserDTO.getCreationTime());
        values.put("INVALIDATE_SESSION_FLAG", navUserDTO.getInvalidateSessionFlag());
        values.put("ASESSION_ID", navUserDTO.getAsessionId());
        values.put("SESSION_ID", navUserDTO.getSessionId());
        NavUser response = (NavUser)this.ao.create(NavUser.class, values);
        logger.debug("Successfully save for user {}", (Object)navUserDTO.getUserName());
        return response;
    }

    public NavUser update(Long id, String asessionId, String sessionId, Long requestCount, String userName) {
        if (!UtilRepository.checkAO(this.ao)) {
            return null;
        }
        NavUser navUser = (NavUser)this.ao.get(NavUser.class, (Object)id.intValue());
        if (navUser != null) {
            navUser.setRequestCount(requestCount);
            navUser.setLastAccessTime(new Date());
            navUser.setUserName(userName);
            navUser.save();
        } else {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("REQUEST_COUNT", requestCount);
            values.put("USER_NAME", userName);
            values.put("LAST_ACCESS_TIME", new Date());
            values.put("CREATION_TIME", new Date());
            values.put("ASESSION_ID", asessionId);
            values.put("SESSION_ID", sessionId);
            navUser = (NavUser)this.ao.create(NavUser.class, values);
        }
        return navUser;
    }

    public NavUser[] getBySession(String asessionId, String sessionId) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called getAllByUsers for session {} asession {} ", (Object)asessionId, (Object)sessionId);
        }
        NavUser[] queryResult = (NavUser[])this.ao.find(NavUser.class, Query.select().where("ASESSION_ID = ? AND SESSION_ID = ? ", new Object[]{asessionId, sessionId}).order("LAST_ACCESS_TIME DESC"));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully fetch result for session {} asession {} ", (Object)asessionId, (Object)sessionId);
        }
        return queryResult;
    }

    public NavUser[] getByUserName(String userName) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called getByUserName for userName {} ", (Object)userName);
        }
        NavUser[] queryResult = (NavUser[])this.ao.find(NavUser.class, Query.select().where("USER_NAME = ? ", new Object[]{userName}).order("LAST_ACCESS_TIME DESC"));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully fetch result for userName {} ", (Object)userName);
        }
        return queryResult;
    }

    public NavUser[] getAllByUsers(String[] userNames) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called getAllByUsers for userNames {}", (Object)Arrays.stream(userNames).collect(Collectors.joining(",")));
        }
        String placeholderUsers = Arrays.stream(userNames).collect(Collectors.joining(","));
        NavUser[] queryResult = (NavUser[])this.ao.find(NavUser.class, Query.select().where("USER_NAME in (?)", new Object[]{placeholderUsers}));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully fetch result for userNames {}", (Object)Arrays.stream(userNames).collect(Collectors.joining(",")));
        }
        return queryResult;
    }

    public NavUser[] getOldestUsers(String[] userNames, int ctx) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called getAllByUsers for userNames {}", (Object)Arrays.stream(userNames).collect(Collectors.joining(",")));
        }
        String placeholderCommaList = Arrays.stream(userNames).map(un -> "?").collect(Collectors.joining(","));
        NavUser[] queryResult = (NavUser[])this.ao.find(NavUser.class, Query.select().where("USER_NAME in  ( " + placeholderCommaList + " )", (Object[])userNames).order("LAST_ACCESS_TIME ASC").limit(ctx));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully fetch result for userNames {}", (Object)Arrays.stream(userNames).collect(Collectors.joining(",")));
        }
        return queryResult;
    }

    public NavUser[] getAll() {
        if (logger.isDebugEnabled()) {
            logger.debug("Called getAll ");
        }
        NavUser[] queryResult = (NavUser[])this.ao.find(NavUser.class, Query.select());
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully fetch result for getAll");
        }
        return queryResult;
    }

    public int deleteBySession(String asessionId, String sessionId) {
        return this.ao.deleteWithSQL(NavUser.class, "ASESSION_ID = ? AND SESSION_ID = ? ", new Object[]{asessionId, sessionId});
    }

    public int deleteOldestExceptUsers(String userName, NavUser navUser) {
        if (logger.isDebugEnabled()) {
            logger.debug("Called deleteOldestExceptUsers for userName {} except {}", (Object)userName, (Object)navUser.getID());
        }
        int cnt = this.ao.deleteWithSQL(NavUser.class, "USER_NAME = ? AND ID != ? ", new Object[]{userName, navUser.getID()});
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully deleteOldestExceptUsers  for userName {} except {}", (Object)userName, (Object)navUser.getID());
        }
        return cnt;
    }

    public void delete(NavUser navUser) {
        this.ao.delete(new RawEntity[]{navUser});
    }
}

