AJS.toInit(function() {
    // Display the alert for administrators only if needed

    jQuery.ajax({
        url: AJS.contextPath() + "/rest/IUM/latest/ium-alert/alerts",
        contentType: "application/json; charset=utf-8",
        success: function (data) {
          if(data && data.messages) {
              let messages=data.messages.join("<br/><br/>")

              let ajsFlag = AJS.flag({
                  type: 'success',
                  title: 'Intelligent User Manager (IUM)',
                  body: messages +
                      '<ul class="aui-nav-actions-list">' +
                      '<li><a class="aui-button aui-button-link" href="#">Close</a></li>' +
                      '</ul>'
              });

              ajsFlag.querySelector(".aui-button-link").addEventListener("click",function(){
                  jQuery.ajax({
                      url: AJS.contextPath() + '/rest/IUM/latest/ium-alert/dismiss',
                      type: 'POST',
                      contentType: "application/json; charset=utf-8",
                      success: function (data) {
                          if(data && data.messages) {
                              //let users = [...new Set(data.users.flatMap(msg => msg.message.split(",")))].join(',')
                              console.log(data.messages)
                          }
                      },
                      error: function (xhr, ajaxOptions, thrownError) {
                          console.error("Error on checking alerts dismiss");
                      },
                      complete:function (xhr, textStatus ) {
                          ajsFlag.close();
                      }
                  });

              })
          }
        },
        error: function (xhr, ajaxOptions, thrownError) {
            console.error("Error on checking alerts")
        }
    });

     
    // Close the alert on "OK" click
    AJS.$("#close-alert").click(function() {
        AJS.$("#ium-alert-container").hide();
        jQuery.ajax({
            url: AJS.contextPath() + '/rest/IUM/latest/ium-alert/dismiss',
            type: 'POST',
            contentType: "application/json; charset=utf-8",
            success: function (data) {
                if(data && data.messages && data.messages.length>0) {
                    let users =[... new Set(data.messages.flatMap(msg=>msg.message.split(",")))].join(',')
                    console.log(users)
                }
            },
            error: function (xhr, ajaxOptions, thrownError) {
                console.error("Error on checking alerts dismiss")
            }
        });
    });

});
