/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.analytical;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import de.accxia.jira.addon.IUM.analytical.CounterAction;
import de.accxia.jira.addon.IUM.analytical.CounterActionDTO;
import de.accxia.jira.addon.IUM.analytical.ServiceMarkerType;
import de.accxia.jira.addon.IUM.repository.UtilRepository;
import de.accxia.jira.addon.IUM.utils.DateUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={CounterActionRepository.class})
@Named(value="CounterActionRepository")
public class CounterActionRepository {
    private static final Logger LOG = LoggerFactory.getLogger(CounterActionRepository.class);
    @ComponentImport
    private final ActiveObjects ao;

    @Inject
    public CounterActionRepository(ActiveObjects ao) {
        this.ao = ao;
    }

    public Map<ServiceMarkerType, CounterActionDTO> saveOrUpdate(Map<ServiceMarkerType, CounterActionDTO> counterAction) {
        if (!UtilRepository.checkAO(this.ao)) {
            return null;
        }
        Map<ServiceMarkerType, CounterActionDTO> retVal = this.updatedBySum(counterAction);
        return retVal;
    }

    public CounterActionDTO save(CounterActionDTO counterActionDTO) {
        if (!UtilRepository.checkAO(this.ao)) {
            return null;
        }
        LOG.debug("Called save for day {}", (Object)counterActionDTO.getDay());
        CounterActionDTO[] analyticalDTO = new CounterActionDTO[1];
        HashMap<String, Comparable<Date>> values = new HashMap<String, Comparable<Date>>();
        values.put("DAY", counterActionDTO.getDay());
        values.put("APP_USER_COUNT", counterActionDTO.getAppUserCount());
        values.put("IUM_LICENSE_COUNT", counterActionDTO.getIumLicenseCount());
        values.put("LOGOUT_USER_COUNT", counterActionDTO.getLogoutUserCount());
        values.put("INACTIVE_USER_COUNT", counterActionDTO.getInactiveUserCount());
        values.put("LICENSE_REQUEST_COUNT", counterActionDTO.getLicenseRequestCount());
        values.put("REDUCED_EXCEED_COUNT", counterActionDTO.getReducedExceedCount());
        values.put("AUTO_REMOVAL_USER_COUNT", counterActionDTO.getAutoRemovalUserCount());
        values.put("GROUP_REMOVAL_USER_COUNT", counterActionDTO.getGroupRemovalUserCount());
        values.put("SERVICE_MARKER_TYPE", Integer.valueOf(counterActionDTO.getServiceMarkerType().getValue()));
        CounterAction response = (CounterAction)this.ao.create(CounterAction.class, values);
        return CounterActionDTO.fromAO(response);
    }

    public CounterActionDTO update(CounterAction counterAction, CounterActionDTO counterActionDTO) {
        if (!UtilRepository.checkAO(this.ao)) {
            return null;
        }
        LOG.debug("Called updatedBySum for day {}", (Object)counterActionDTO.getDay());
        counterAction.setDay(counterActionDTO.getDay());
        counterAction.setAppUserCount(this.getSum(counterAction.getAppUserCount(), counterActionDTO.getAppUserCount()));
        counterAction.setIumLicenseCount(this.getSum(counterAction.getIumLicenseCount(), counterActionDTO.getIumLicenseCount()));
        counterAction.setLogoutUserCount(this.getSum(counterAction.getLogoutUserCount(), counterActionDTO.getLogoutUserCount()));
        counterAction.setInactiveUserCount(this.getSum(counterAction.getInactiveUserCount(), counterActionDTO.getInactiveUserCount()));
        counterAction.setLicenseRequestCount(this.getSum(counterAction.getLicenseRequestCount(), counterActionDTO.getLicenseRequestCount()));
        counterAction.setReducedExceedCount(this.getSum(counterAction.getReducedExceedCount(), counterActionDTO.getReducedExceedCount()));
        counterAction.setAutoRemovalUserCount(this.getSum(counterAction.getAutoRemovalUserCount(), counterActionDTO.getAutoRemovalUserCount()));
        counterAction.setGroupRemovalUserCount(this.getSum(counterAction.getGroupRemovalUserCount(), counterActionDTO.getGroupRemovalUserCount()));
        counterAction.setServiceMarkerType(this.getMax(counterAction.getServiceMarkerType(), counterActionDTO.getServiceMarkerType()));
        counterAction.save();
        return CounterActionDTO.fromAO(counterAction);
    }

    private Map<ServiceMarkerType, CounterActionDTO> updatedBySum(final Map<ServiceMarkerType, CounterActionDTO> counterAction) {
        if (!UtilRepository.checkAO(this.ao)) {
            return null;
        }
        HashMap<ServiceMarkerType, CounterActionDTO> retVal = new HashMap<ServiceMarkerType, CounterActionDTO>();
        LOG.debug("Called updatedBySum for day {}", counterAction.keySet());
        final CounterActionDTO[] counterDTO = new CounterActionDTO[2];
        CounterAction response = (CounterAction)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<CounterAction>(){

            public CounterAction doInTransaction() {
                CounterActionDTO jiraCounterActionDTO = (CounterActionDTO)counterAction.get((Object)ServiceMarkerType.SERVICE_MARKER_TYPE_JIRA);
                CounterAction jiraCounterAction = CounterActionRepository.this.getByDay(jiraCounterActionDTO.getDay(), ServiceMarkerType.SERVICE_MARKER_TYPE_JIRA);
                counterDTO[0] = jiraCounterAction == null ? CounterActionRepository.this.save(jiraCounterActionDTO) : CounterActionRepository.this.update(jiraCounterAction, jiraCounterActionDTO);
                CounterActionDTO jsmCounterActionDTO = (CounterActionDTO)counterAction.get((Object)ServiceMarkerType.SERVICE_MARKER_TYPE_JSM);
                CounterAction jsmCounterAction = CounterActionRepository.this.getByDay(jsmCounterActionDTO.getDay(), ServiceMarkerType.SERVICE_MARKER_TYPE_JSM);
                counterDTO[1] = jsmCounterAction == null ? CounterActionRepository.this.save(jsmCounterActionDTO) : CounterActionRepository.this.update(jsmCounterAction, jsmCounterActionDTO);
                return null;
            }
        });
        retVal.put(ServiceMarkerType.SERVICE_MARKER_TYPE_JIRA, counterDTO[0]);
        retVal.put(ServiceMarkerType.SERVICE_MARKER_TYPE_JSM, counterDTO[1]);
        return retVal;
    }

    private Integer getSum(Integer b1, Integer b2) {
        int wb1 = b1 == null ? 0 : b1;
        int wb2 = b2 == null ? 0 : b2;
        return wb1 + wb2;
    }

    private Integer getMax(Integer baseValue, ServiceMarkerType serviceMarker) {
        int base = baseValue == null ? 0 : baseValue;
        int maxValue = base > serviceMarker.getValue() ? base : serviceMarker.getValue();
        return maxValue;
    }

    public CounterAction getByDay(Date date, ServiceMarkerType serviceMarker) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Called getByDay ");
        }
        CounterAction[] queryResult = (CounterAction[])this.ao.find(CounterAction.class, Query.select().where("DAY = ? AND SERVICE_MARKER_TYPE = ?", new Object[]{date, serviceMarker.getValue()}));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully fetch result for getByDay");
        }
        if (queryResult != null && queryResult.length > 0) {
            return queryResult[0];
        }
        return null;
    }

    public CounterAction[] getByPeriod(Date startDate, Date endDate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Called getByPeriod ");
        }
        CounterAction[] queryResult = (CounterAction[])this.ao.find(CounterAction.class, Query.select().where("DAY BETWEEN ? AND ?", new Object[]{startDate, endDate}));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully fetch result for getByDay");
        }
        return queryResult;
    }

    public int deleteByDate(int day, int month, int year) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Called deleteByDate day: {} month: {} year: {}", new Object[]{day, month, year});
        }
        Date date = DateUtil.getDayOfMonth(day, month, year);
        int deletedCount = this.ao.deleteWithSQL(CounterAction.class, "DAY = ?", new Object[]{date});
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully deleted ByDate");
        }
        return deletedCount;
    }

    public int deleteAll() {
        try {
            int recs = this.ao.deleteWithSQL(CounterAction.class, "1=1", new Object[0]);
            return recs;
        }
        catch (Exception e) {
            LOG.error("Error while deleting all records", (Throwable)e);
            return -1;
        }
    }

    @Deprecated
    private CounterAction getByDay(Date date) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Called getByDay ");
        }
        CounterAction[] queryResult = (CounterAction[])this.ao.find(CounterAction.class, Query.select().where("DAY = ?", new Object[]{date}));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully fetch result for getByDay");
        }
        if (queryResult != null && queryResult.length > 0) {
            return queryResult[0];
        }
        return null;
    }

    @Deprecated
    private CounterActionDTO save_(CounterActionDTO counterActionDTO) {
        if (!UtilRepository.checkAO(this.ao)) {
            return null;
        }
        LOG.debug("Called save for day {}", (Object)counterActionDTO.getDay());
        final CounterActionDTO[] analyticalDTO = new CounterActionDTO[1];
        final HashMap<String, Comparable<Date>> values = new HashMap<String, Comparable<Date>>();
        values.put("DAY", counterActionDTO.getDay());
        values.put("APP_USER_COUNT", counterActionDTO.getAppUserCount());
        values.put("IUM_LICENSE_COUNT", counterActionDTO.getIumLicenseCount());
        values.put("LOGOUT_USER_COUNT", counterActionDTO.getLogoutUserCount());
        values.put("INACTIVE_USER_COUNT", counterActionDTO.getInactiveUserCount());
        values.put("LICENSE_REQUEST_COUNT", counterActionDTO.getLicenseRequestCount());
        values.put("REDUCED_EXCEED_COUNT", counterActionDTO.getReducedExceedCount());
        values.put("AUTO_REMOVAL_USER_COUNT", counterActionDTO.getAutoRemovalUserCount());
        values.put("GROUP_REMOVAL_USER_COUNT", counterActionDTO.getGroupRemovalUserCount());
        values.put("SERVICE_MARKER_TYPE", Integer.valueOf(counterActionDTO.getServiceMarkerType().getValue()));
        CounterAction response = (CounterAction)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<CounterAction>(){

            public CounterAction doInTransaction() {
                CounterAction response = (CounterAction)CounterActionRepository.this.ao.create(CounterAction.class, values);
                LOG.debug("Successfully created with ID {}", (Object)response.getID());
                analyticalDTO[0] = CounterActionDTO.fromAO(response);
                return response;
            }
        });
        LOG.debug("Successfully save for {} with ID {}", (Object)analyticalDTO[0].toString(), (Object)analyticalDTO[0].getID());
        return analyticalDTO[0];
    }

    @Deprecated
    private CounterActionDTO updatedBySum_(final CounterActionDTO counterActionDTO) {
        if (!UtilRepository.checkAO(this.ao)) {
            return null;
        }
        LOG.debug("Called updatedBySum for day {}", (Object)counterActionDTO.getDay());
        final CounterActionDTO[] analyticalDTO = new CounterActionDTO[1];
        CounterAction response = (CounterAction)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<CounterAction>(){

            public CounterAction doInTransaction() {
                CounterAction counterAction = null;
                counterAction = counterActionDTO.getID() != null ? (CounterAction)CounterActionRepository.this.ao.get(CounterAction.class, (Object)counterActionDTO.getID()) : CounterActionRepository.this.getByDay(counterActionDTO.getDay());
                if (counterAction != null && counterAction.getID() != 0 && DateUtil.isSameDay(counterAction.getDay(), counterActionDTO.getDay())) {
                    counterAction.setDay(counterActionDTO.getDay());
                    counterAction.setAppUserCount(CounterActionRepository.this.getSum(counterAction.getAppUserCount(), counterActionDTO.getAppUserCount()));
                    counterAction.setIumLicenseCount(CounterActionRepository.this.getSum(counterAction.getIumLicenseCount(), counterActionDTO.getIumLicenseCount()));
                    counterAction.setLogoutUserCount(CounterActionRepository.this.getSum(counterAction.getLogoutUserCount(), counterActionDTO.getLogoutUserCount()));
                    counterAction.setInactiveUserCount(CounterActionRepository.this.getSum(counterAction.getInactiveUserCount(), counterActionDTO.getInactiveUserCount()));
                    counterAction.setLicenseRequestCount(CounterActionRepository.this.getSum(counterAction.getLicenseRequestCount(), counterActionDTO.getLicenseRequestCount()));
                    counterAction.setReducedExceedCount(CounterActionRepository.this.getSum(counterAction.getReducedExceedCount(), counterActionDTO.getReducedExceedCount()));
                    counterAction.setAutoRemovalUserCount(CounterActionRepository.this.getSum(counterAction.getAutoRemovalUserCount(), counterActionDTO.getAutoRemovalUserCount()));
                    counterAction.setGroupRemovalUserCount(CounterActionRepository.this.getSum(counterAction.getGroupRemovalUserCount(), counterActionDTO.getGroupRemovalUserCount()));
                    counterAction.setServiceMarkerType(CounterActionRepository.this.getMax(counterAction.getServiceMarkerType(), counterActionDTO.getServiceMarkerType()));
                    counterAction.save();
                } else {
                    HashMap<String, Comparable<Date>> values = new HashMap<String, Comparable<Date>>();
                    values.put("DAY", counterActionDTO.getDay());
                    values.put("APP_USER_COUNT", counterActionDTO.getAppUserCount());
                    values.put("IUM_LICENSE_COUNT", counterActionDTO.getIumLicenseCount());
                    values.put("LOGOUT_USER_COUNT", counterActionDTO.getLogoutUserCount());
                    values.put("INACTIVE_USER_COUNT", counterActionDTO.getInactiveUserCount());
                    values.put("LICENSE_REQUEST_COUNT", counterActionDTO.getLicenseRequestCount());
                    values.put("REDUCED_EXCEED_COUNT", counterActionDTO.getReducedExceedCount());
                    values.put("AUTO_REMOVAL_USER_COUNT", counterActionDTO.getAutoRemovalUserCount());
                    values.put("GROUP_REMOVAL_USER_COUNT", counterActionDTO.getGroupRemovalUserCount());
                    values.put("SERVICE_MARKER_TYPE", Integer.valueOf(counterActionDTO.getServiceMarkerType().getValue()));
                    counterAction = (CounterAction)CounterActionRepository.this.ao.create(CounterAction.class, values);
                }
                analyticalDTO[0] = CounterActionDTO.fromAO(counterAction);
                return counterAction;
            }
        });
        LOG.debug("Successfully updatedBySum for {} with ID {}", (Object)analyticalDTO[0].toString(), (Object)analyticalDTO[0].getID());
        return analyticalDTO[0];
    }
}

