/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.analytical;

import java.util.Random;

public enum ServiceMarkerType {
    SERVICE_MARKER_TYPE_NONE(0),
    SERVICE_MARKER_TYPE_JIRA(1),
    SERVICE_MARKER_TYPE_JSM(2);

    private static final Random PRNG;
    private final int value;

    private ServiceMarkerType(int value) {
        this.value = value;
    }

    public static ServiceMarkerType from(int permission) {
        ServiceMarkerType[] eventTypes;
        for (ServiceMarkerType eventType : eventTypes = ServiceMarkerType.values()) {
            if (eventType.value != permission) continue;
            return eventType;
        }
        return SERVICE_MARKER_TYPE_NONE;
    }

    public int getValue() {
        return this.value;
    }

    public static ServiceMarkerType randomServiceMarkerType() {
        ServiceMarkerType[] eventTypes = ServiceMarkerType.values();
        return eventTypes[PRNG.nextInt(eventTypes.length)];
    }

    static {
        PRNG = new Random();
    }
}

