/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.analytical;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.jira.addon.IUM.analytical.CounterActionDTO;
import de.accxia.jira.addon.IUM.analytical.CounterActionEvent;
import de.accxia.jira.addon.IUM.analytical.CounterActionRepository;
import de.accxia.jira.addon.IUM.analytical.LicenseTierDTO;
import de.accxia.jira.addon.IUM.analytical.LicenseTierRepository;
import de.accxia.jira.addon.IUM.analytical.PermissionMarkerType;
import de.accxia.jira.addon.IUM.analytical.ServiceMarkerType;
import de.accxia.jira.addon.IUM.analytical.UserActionEvent;
import de.accxia.jira.addon.IUM.analytical.UserActivity;
import de.accxia.jira.addon.IUM.analytical.UserAnalyticalDTO;
import de.accxia.jira.addon.IUM.analytical.UserAnalyticalRepository;
import de.accxia.jira.addon.IUM.analytical.UserReference;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.servlet.HelperTrialProcessing;
import de.accxia.jira.addon.IUM.utils.DateUtil;
import de.accxia.jira.addon.IUM.utils.ParseUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class LicenseAnalyticalService
implements InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseAnalyticalService.class);
    private static final long INITIAL_DELAY = 1L;
    private static final long PERIOD = 1L;
    private final ReentrantLock lock1 = new ReentrantLock();
    private final ReentrantLock lock2 = new ReentrantLock();
    private final ReentrantLock lock3 = new ReentrantLock();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture scheduledLicenseFuture = null;
    private ScheduledFuture scheduledUserFuture = null;
    private ScheduledFuture scheduledTierFuture = null;
    private ConcurrentHashMap<ServiceMarkerType, CounterActionDTO> counterAction;
    private LicenseTierDTO licenseTier;
    private ConcurrentHashMap<UserReference, UserActivity> userActionMap = null;
    private static UserUtil userUtil = ComponentAccessor.getUserUtil();
    @ComponentImport
    private final EventPublisher eventPublisher;
    private final HelperTrialProcessing helperTrialProcessing;
    private final CounterActionRepository counterActionRepository;
    private final UserAnalyticalRepository userAnalyticalRepository;
    private final LicenseTierRepository licenseTierRepository;
    String jiraDisabledGroupName;
    String jsmDisabledGroupName;
    String jiraEnabledGroupName;
    String jsmEnabledGroupName;

    @Inject
    public LicenseAnalyticalService(EventPublisher eventPublisher, HelperTrialProcessing helperTrialProcessing, CounterActionRepository counterActionRepository, UserAnalyticalRepository userAnalyticalRepository, LicenseTierRepository licenseTierRepository) {
        this.eventPublisher = eventPublisher;
        this.helperTrialProcessing = helperTrialProcessing;
        this.counterActionRepository = counterActionRepository;
        this.userAnalyticalRepository = userAnalyticalRepository;
        this.licenseTierRepository = licenseTierRepository;
        this.startScheduledFlush();
    }

    public void publishEvent(CounterActionEvent event) {
        this.eventPublisher.publish((Object)event);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
        this.userActionMap = null;
        this.counterAction = null;
        this.licenseTier = null;
        this.shutdownScheduled();
    }

    private void shutdownScheduled() {
        try {
            if (this.scheduledLicenseFuture != null) {
                LOG.info("LicenseAnalytical scheduledLicenseFuture canceled");
                this.scheduledLicenseFuture.cancel(true);
            }
            LOG.info("LicenseAnalytical scheduledLicenseFuture shutdown");
            if (this.scheduledUserFuture != null) {
                LOG.info("UserAnalytical scheduledUserFuture canceled");
                this.scheduledUserFuture.cancel(true);
            }
            LOG.info("LicenseAnalytical scheduledUserFuture shutdown");
            if (this.scheduledTierFuture != null) {
                LOG.info("UserAnalytical scheduledTierFuture canceled");
                this.scheduledTierFuture.cancel(true);
            }
            LOG.info("UserAnalytical scheduledTierFuture shutdown");
            this.scheduler.shutdown();
            if (!this.scheduler.awaitTermination(10L, TimeUnit.SECONDS)) {
                LOG.info("LicenseAnalytical/UserAnalytical/TierFuture scheduledFuture shutdownNow");
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOG.error("Exception while shutting down LicenseAnalytical/UserAnalytical scheduledFuture: {}", (Object)e.getMessage(), (Object)e);
            this.scheduler.shutdownNow();
        }
    }

    @EventListener
    public void onIssueEvent(CounterActionEvent event) {
        this.processCounterActionEvent(event);
    }

    @EventListener
    public void onIssueEvent(UserActionEvent event) {
        this.processAsyncUserEvent(event);
    }

    private void startScheduledFlush() {
        this.scheduledLicenseFuture = this.scheduler.scheduleAtFixedRate(this::flushCounterActionToDatabase, 1L, 1L, TimeUnit.MINUTES);
        this.scheduledUserFuture = this.scheduler.scheduleAtFixedRate(this::flushUserActionToDatabase, 1L, 2L, TimeUnit.MINUTES);
        this.scheduledTierFuture = this.scheduler.scheduleAtFixedRate(this::flushTierAnalyticalToDatabase, 1L, 2L, TimeUnit.MINUTES);
    }

    private void flushCounterActionToDatabase() {
        if (!this.scheduledLicenseFuture.isCancelled()) {
            this.lock1.lock();
            try {
                LOG.info("Lock aquired");
                LOG.info("Flushing CounterAction to database");
                Map<ServiceMarkerType, CounterActionDTO> analytical = this.counterActionRepository.saveOrUpdate(this.getCounterAction());
                LOG.info("Saved  CounterAction with ID: {} and day {}", analytical.keySet(), analytical.values());
                this.counterAction = null;
                this.getCounterAction();
            }
            catch (Exception e) {
                LOG.error("Error while saving CounterAction: {}", (Object)e.getMessage(), (Object)e);
                this.counterAction = null;
                this.getCounterAction();
            }
            finally {
                this.lock1.unlock();
                LOG.info("Lock released");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushUserActionToDatabase() {
        if (!this.scheduledUserFuture.isCancelled()) {
            String groupsDisabled = DAO.getIUMGroupsDisabled();
            String groupsEnabled = DAO.getIUMGroups();
            String[] disableGroupNames = groupsDisabled.split(",");
            String jiraDisabledGroupName = disableGroupNames.length > 0 ? disableGroupNames[0] : "";
            String jsmDisabledGroupName = disableGroupNames.length > 1 ? disableGroupNames[1] : "";
            String[] enableGroupNames = groupsEnabled.split(",");
            String jiraEnabledGroupName = enableGroupNames.length > 0 ? disableGroupNames[0] : "";
            String jsmEnabledGroupName = enableGroupNames.length > 1 ? disableGroupNames[1] : "";
            List jiraAccess = this.helperTrialProcessing.getUsersWithGenericAccessExceptGroup(ApplicationKeys.SOFTWARE, "").stream().map(user -> user.getName()).collect(Collectors.toList());
            List jsmAccess = this.helperTrialProcessing.getUsersWithGenericAccessExceptGroup(ApplicationKeys.SERVICE_DESK, "").stream().map(user -> user.getName()).collect(Collectors.toList());
            List jiraUsersFromDisableGroup = StringUtils.isEmpty((CharSequence)jiraDisabledGroupName) ? Collections.emptyList() : userUtil.getAllUsersInGroupNamesUnsorted(List.of(jiraDisabledGroupName)).stream().map(user -> user.getName()).collect(Collectors.toList());
            List jsmUsersFromDisableGroup = StringUtils.isEmpty((CharSequence)jsmDisabledGroupName) ? Collections.emptyList() : userUtil.getAllUsersInGroupNamesUnsorted(List.of(jsmDisabledGroupName)).stream().map(user -> user.getName()).collect(Collectors.toList());
            this.lock2.lock();
            try {
                LOG.info("Lock aquired");
                LOG.info("Flushing UserAnalytical to database");
                this.getUserActionMap();
                ArrayList<UserAnalyticalDTO> userAnalyticalList = new ArrayList<UserAnalyticalDTO>();
                this.userActionMap.forEach((key, value) -> userAnalyticalList.add(new UserAnalyticalDTO((UserReference)key, (UserActivity)value)));
                this.userActionMap = new ConcurrentHashMap();
                for (UserAnalyticalDTO ua : userAnalyticalList) {
                    if (jiraUsersFromDisableGroup.contains(ua.getUsername())) {
                        ua.setPermIumJira(PermissionMarkerType.PERMISSION_ALLOW);
                    } else {
                        ua.setPermIumJira(PermissionMarkerType.PERMISSION_NONE);
                    }
                    if (jsmUsersFromDisableGroup.contains(ua.getUsername())) {
                        ua.setPermIumJsm(PermissionMarkerType.PERMISSION_ALLOW);
                    } else {
                        ua.setPermIumJsm(PermissionMarkerType.PERMISSION_NONE);
                    }
                    if (jiraAccess.contains(ua.getUsername())) {
                        ua.setPermJira(PermissionMarkerType.PERMISSION_ALLOW);
                    } else {
                        ua.setPermJira(PermissionMarkerType.PERMISSION_NONE);
                    }
                    if (jsmAccess.contains(ua.getUsername())) {
                        ua.setPermJsm(PermissionMarkerType.PERMISSION_ALLOW);
                        continue;
                    }
                    ua.setPermJsm(PermissionMarkerType.PERMISSION_NONE);
                }
                this.userAnalyticalRepository.saveOrUpdateBatch(userAnalyticalList);
            }
            catch (Exception e) {
                LOG.error("Error while saving UserAnalytical: {}", (Object)e.getMessage(), (Object)e);
                this.userActionMap = new ConcurrentHashMap();
            }
            finally {
                this.lock2.unlock();
                LOG.info("Lock released");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushTierAnalyticalToDatabase() {
        if (!this.scheduledLicenseFuture.isCancelled()) {
            this.lock3.lock();
            try {
                LOG.info("Lock aquired");
                LOG.info("Flushing TierAnalytical to database");
                this.licenseTier = new LicenseTierDTO(DateUtil.getDate());
                String queueSize = DAO.getQueueSize();
                String[] queueSizes = queueSize.split(",");
                if (!StringUtils.isEmpty((CharSequence)queueSize)) {
                    this.licenseTier.setIumJiraLicenseTier(queueSizes.length > 0 ? ParseUtil.safeParseInt(queueSizes[0]) : 0);
                    this.licenseTier.setIumJsmLicenseTier(queueSizes.length > 1 ? ParseUtil.safeParseInt(queueSizes[1]) : 0);
                } else {
                    this.licenseTier.setIumJiraLicenseTier(0);
                    this.licenseTier.setIumJsmLicenseTier(0);
                }
                int jiraLicense = this.helperTrialProcessing.getSeats(ApplicationKeys.SOFTWARE);
                this.licenseTier.setJiraLicenseTier(jiraLicense);
                int jsmLicense = this.helperTrialProcessing.getSeats(ApplicationKeys.SERVICE_DESK);
                this.licenseTier.setJsmLicenseTier(jsmLicense);
                String group = DAO.getIUMGroupsDisabled();
                String groupEnable = DAO.getIUMGroups();
                String[] disableGroupNames = group.split(",");
                String jiraDisabledGroupName = disableGroupNames.length > 0 ? disableGroupNames[0] : "";
                String jsmDisabledGroupName = disableGroupNames.length > 1 ? disableGroupNames[1] : "";
                String[] enableGroupNames = groupEnable.split(",");
                String jiraEnableGroupName = enableGroupNames.length > 0 ? enableGroupNames[0] : "";
                String jsmEnableGroupName = enableGroupNames.length > 1 ? enableGroupNames[1] : "";
                List onlyJiraAccess = this.helperTrialProcessing.getUsersWithGenericAccessExceptGroup(ApplicationKeys.SOFTWARE, jiraEnableGroupName).stream().map(user -> user.getName()).collect(Collectors.toList());
                List onlyJsmAccess = this.helperTrialProcessing.getUsersWithGenericAccessExceptGroup(ApplicationKeys.SERVICE_DESK, jsmEnableGroupName).stream().map(user -> user.getName()).collect(Collectors.toList());
                List jiraUsersFromDisableGroup = StringUtils.isEmpty((CharSequence)jiraDisabledGroupName) ? Collections.emptyList() : userUtil.getAllUsersInGroupNamesUnsorted(List.of(jiraDisabledGroupName)).stream().map(user -> user.getName()).collect(Collectors.toList());
                List jsmUsersFromDisableGroup = StringUtils.isEmpty((CharSequence)jsmDisabledGroupName) ? Collections.emptyList() : userUtil.getAllUsersInGroupNamesUnsorted(List.of(jsmDisabledGroupName)).stream().map(user -> user.getName()).collect(Collectors.toList());
                this.licenseTier.setIumJiraUserTier(jiraUsersFromDisableGroup.size());
                this.licenseTier.setIumJsmUserTier(jsmUsersFromDisableGroup.size());
                this.licenseTier.setJiraUserTier(onlyJiraAccess.size());
                this.licenseTier.setJsmUserTier(onlyJsmAccess.size());
                LOG.info("licenseTier ={}", (Object)this.licenseTier);
                LicenseTierDTO analytical = this.licenseTierRepository.saveOrUpdate(this.licenseTier);
                LOG.info("Saved  GlobalLicense with ID: {} and day {}", (Object)analytical.getID(), (Object)analytical.getDay());
            }
            catch (Exception e) {
                LOG.error("Error while saving GlobalLicense: {}", (Object)e.getMessage(), (Object)e);
                this.licenseTier = new LicenseTierDTO(DateUtil.getDate());
            }
            finally {
                this.lock3.unlock();
                LOG.info("Lock released");
            }
        }
    }

    private void processAsyncUserEvent(UserActionEvent event) {
        LOG.info("Processing user event: {}", (Object)event.getUser().getName());
        UserReference userReference = new UserReference(event.getUser().getName());
        this.getUserActionMap();
        UserActivity userActivity = this.userActionMap.containsKey(userReference) ? this.userActionMap.get(userReference) : new UserActivity();
        userActivity.updateGroupName(event.getGroupName());
        switch (event.getEventType()) {
            case USER_ACTION: {
                userActivity.incAction();
                break;
            }
            case USER_SLOT_REVOKED: {
                userActivity.incBanned();
                break;
            }
            case USER_SLOT_GRANTED: {
                userActivity.incActivated();
                break;
            }
            case USER_JOB_REVOKED: {
                userActivity.incJobBanned();
            }
        }
        this.userActionMap.put(userReference, userActivity);
    }

    public void processCounterActionEvent(CounterActionEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing event: {} on thread# {}", (Object)event, (Object)Thread.currentThread().getName());
        }
        switch (event.getEventType()) {
            case ANALYTICAL_EVENT_APP: {
                this.incrementAppTier(event.getGroupName());
                break;
            }
            case ANALYTICAL_EVENT_IUM: {
                this.incrementIumTier(event.getGroupName());
                break;
            }
            case ANALYTICAL_EVENT_LOGOUT: {
                this.incrementLogoutUserCount(event.getGroupName());
                break;
            }
            case ANALYTICAL_EVENT_INACTIVE: {
                this.incrementInactiveUserCount(event.getGroupName());
                break;
            }
            case ANALYTICAL_EVENT_LICENSE_REQ: {
                this.incrementLicenseReq(event.getGroupName());
                break;
            }
            case ANALYTICAL_EVENT_REDUCED_EXCEED: {
                this.reducedExceedCount(event.getQuantity(), event.getGroupName());
                break;
            }
            case ANALYTICAL_EVENT_AUTO_REMOVAL: {
                this.incrementAutoRemovalUserCount(event.getGroupName());
                break;
            }
            case ANALYTICAL_EVENT_GROUP_REMOVAL: {
                this.incrementGroupRemovalUserCount(event.getGroupName());
                break;
            }
            default: {
                LOG.warn("Unknown event type: {}", (Object)event.getEventType());
            }
        }
    }

    private void incrementAppTier(String groupName) {
        this.lock1.lock();
        try {
            CounterActionDTO lCounter;
            if (groupName != null && (groupName.equals(this.jiraEnabledGroupName) || groupName.equals(this.jiraDisabledGroupName))) {
                lCounter = this.getCounterAction().get((Object)ServiceMarkerType.SERVICE_MARKER_TYPE_JIRA);
                lCounter.setAppUserCount(lCounter.getAppUserCount() + 1);
            }
            if (groupName != null && (groupName.equals(this.jsmEnabledGroupName) || groupName.equals(this.jsmDisabledGroupName))) {
                lCounter = this.getCounterAction().get((Object)ServiceMarkerType.SERVICE_MARKER_TYPE_JSM);
                lCounter.setAppUserCount(lCounter.getAppUserCount() + 1);
            }
        }
        finally {
            this.lock1.unlock();
        }
    }

    private void incrementIumTier(String groupName) {
        this.lock1.lock();
        try {
            CounterActionDTO lCounter;
            if (groupName != null && (groupName.equals(this.jiraEnabledGroupName) || groupName.equals(this.jiraDisabledGroupName))) {
                lCounter = this.getCounterAction().get((Object)ServiceMarkerType.SERVICE_MARKER_TYPE_JIRA);
                lCounter.setIumLicenseCount(lCounter.getIumLicenseCount() + 1);
            }
            if (groupName != null && (groupName.equals(this.jsmEnabledGroupName) || groupName.equals(this.jsmDisabledGroupName))) {
                lCounter = this.getCounterAction().get((Object)ServiceMarkerType.SERVICE_MARKER_TYPE_JSM);
                lCounter.setIumLicenseCount(lCounter.getIumLicenseCount() + 1);
            }
        }
        finally {
            this.lock1.unlock();
        }
    }

    private void incrementLogoutUserCount(String groupName) {
        this.lock1.lock();
        try {
            CounterActionDTO lCounter;
            if (groupName != null && (groupName.equals(this.jiraEnabledGroupName) || groupName.equals(this.jiraDisabledGroupName))) {
                lCounter = this.getCounterAction().get((Object)ServiceMarkerType.SERVICE_MARKER_TYPE_JIRA);
                lCounter.setLogoutUserCount(lCounter.getLogoutUserCount() + 1);
            }
            if (groupName != null && (groupName.equals(this.jsmEnabledGroupName) || groupName.equals(this.jsmDisabledGroupName))) {
                lCounter = this.getCounterAction().get((Object)ServiceMarkerType.SERVICE_MARKER_TYPE_JSM);
                lCounter.setLogoutUserCount(lCounter.getLogoutUserCount() + 1);
            }
        }
        finally {
            this.lock1.unlock();
        }
    }

    private void incrementInactiveUserCount(String groupName) {
        this.lock1.lock();
        try {
            CounterActionDTO lCounter;
            if (groupName != null && (groupName.equals(this.jiraEnabledGroupName) || groupName.equals(this.jiraDisabledGroupName))) {
                lCounter = this.getCounterAction().get((Object)ServiceMarkerType.SERVICE_MARKER_TYPE_JIRA);
                lCounter.setInactiveUserCount(lCounter.getInactiveUserCount() + 1);
            }
            if (groupName != null && (groupName.equals(this.jsmEnabledGroupName) || groupName.equals(this.jsmDisabledGroupName))) {
                lCounter = this.getCounterAction().get((Object)ServiceMarkerType.SERVICE_MARKER_TYPE_JSM);
                lCounter.setInactiveUserCount(lCounter.getInactiveUserCount() + 1);
            }
        }
        finally {
            this.lock1.unlock();
        }
    }

    private void incrementLicenseReq(String groupName) {
        this.lock1.lock();
        try {
            CounterActionDTO lCounter;
            if (groupName != null && (groupName.equals(this.jiraEnabledGroupName) || groupName.equals(this.jiraDisabledGroupName))) {
                lCounter = this.getCounterAction().get((Object)ServiceMarkerType.SERVICE_MARKER_TYPE_JIRA);
                lCounter.setLicenseRequestCount(lCounter.getLicenseRequestCount() + 1);
            }
            if (groupName != null && (groupName.equals(this.jsmEnabledGroupName) || groupName.equals(this.jsmDisabledGroupName))) {
                lCounter = this.getCounterAction().get((Object)ServiceMarkerType.SERVICE_MARKER_TYPE_JSM);
                lCounter.setLicenseRequestCount(lCounter.getLicenseRequestCount() + 1);
            }
        }
        finally {
            this.lock1.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reducedExceedCount(int quantity, String groupName) {
        this.lock1.lock();
        try {
            CounterActionDTO lCounter;
            if (groupName != null && (groupName.equals(this.jiraEnabledGroupName) || groupName.equals(this.jiraDisabledGroupName))) {
                lCounter = this.getCounterAction().get((Object)ServiceMarkerType.SERVICE_MARKER_TYPE_JIRA);
                lCounter.setReducedExceedCount(lCounter.getReducedExceedCount() + (quantity > 0 ? quantity : 1));
            }
            if (groupName != null && (groupName.equals(this.jsmEnabledGroupName) || groupName.equals(this.jsmDisabledGroupName))) {
                lCounter = this.getCounterAction().get((Object)ServiceMarkerType.SERVICE_MARKER_TYPE_JSM);
                lCounter.setReducedExceedCount(lCounter.getReducedExceedCount() + (quantity > 0 ? quantity : 1));
            }
        }
        finally {
            this.lock1.unlock();
        }
    }

    private void incrementAutoRemovalUserCount(String groupName) {
        this.lock1.lock();
        try {
            CounterActionDTO lCounter;
            if (groupName != null && (groupName.equals(this.jiraEnabledGroupName) || groupName.equals(this.jiraDisabledGroupName))) {
                lCounter = this.getCounterAction().get((Object)ServiceMarkerType.SERVICE_MARKER_TYPE_JIRA);
                lCounter.setAutoRemovalUserCount(lCounter.getAutoRemovalUserCount() + 1);
            }
            if (groupName != null && (groupName.equals(this.jsmEnabledGroupName) || groupName.equals(this.jsmDisabledGroupName))) {
                lCounter = this.getCounterAction().get((Object)ServiceMarkerType.SERVICE_MARKER_TYPE_JSM);
                lCounter.setAutoRemovalUserCount(lCounter.getAutoRemovalUserCount() + 1);
            }
        }
        finally {
            this.lock1.unlock();
        }
    }

    private void incrementGroupRemovalUserCount(String groupName) {
        this.lock1.lock();
        try {
            CounterActionDTO lCounter;
            if (groupName != null && (groupName.equals(this.jiraEnabledGroupName) || groupName.equals(this.jiraDisabledGroupName))) {
                lCounter = this.getCounterAction().get((Object)ServiceMarkerType.SERVICE_MARKER_TYPE_JIRA);
                lCounter.setGroupRemovalUserCount(lCounter.getGroupRemovalUserCount() + 1);
            }
            if (groupName != null && (groupName.equals(this.jsmEnabledGroupName) || groupName.equals(this.jsmDisabledGroupName))) {
                lCounter = this.getCounterAction().get((Object)ServiceMarkerType.SERVICE_MARKER_TYPE_JSM);
                lCounter.setGroupRemovalUserCount(lCounter.getGroupRemovalUserCount() + 1);
            }
        }
        finally {
            this.lock1.unlock();
        }
    }

    public ConcurrentHashMap<ServiceMarkerType, CounterActionDTO> getCounterAction() {
        if (this.counterAction == null) {
            this.counterAction = new ConcurrentHashMap();
            this.counterAction.put(ServiceMarkerType.SERVICE_MARKER_TYPE_JIRA, new CounterActionDTO(DateUtil.getDate(), ServiceMarkerType.SERVICE_MARKER_TYPE_JIRA));
            this.counterAction.put(ServiceMarkerType.SERVICE_MARKER_TYPE_JSM, new CounterActionDTO(DateUtil.getDate(), ServiceMarkerType.SERVICE_MARKER_TYPE_JSM));
            String[] disableGroupNames = DAO.getIUMGroupsDisabled().split(",");
            this.jiraDisabledGroupName = disableGroupNames.length > 0 ? disableGroupNames[0] : "";
            this.jsmDisabledGroupName = disableGroupNames.length > 1 ? disableGroupNames[1] : "";
            String[] enableGroupNames = DAO.getIUMGroups().split(",");
            this.jiraEnabledGroupName = enableGroupNames.length > 0 ? enableGroupNames[0] : "";
            this.jsmEnabledGroupName = enableGroupNames.length > 1 ? enableGroupNames[1] : "";
        }
        return this.counterAction;
    }

    public ConcurrentHashMap<UserReference, UserActivity> getUserActionMap() {
        if (this.userActionMap == null) {
            this.userActionMap = new ConcurrentHashMap();
        }
        return this.userActionMap;
    }

    public LicenseTierDTO getLicenseTier() {
        if (this.licenseTier == null) {
            this.licenseTier = new LicenseTierDTO(DateUtil.getDate());
        }
        return this.licenseTier;
    }

    public void savedToDatabase(List<UserAnalyticalDTO> userAnalyticalList) {
        if (userAnalyticalList == null || userAnalyticalList.isEmpty()) {
            return;
        }
        this.userAnalyticalRepository.saveOrUpdateBatch(userAnalyticalList);
    }

    public CounterActionDTO getCounterActionByDay(Date date, ServiceMarkerType serviceMarkerType) {
        CounterActionDTO action = CounterActionDTO.fromAO(this.counterActionRepository.getByDay(date, serviceMarkerType));
        return action;
    }

    public LicenseTierDTO getLicenseTierByDay(Date date) {
        LicenseTierDTO action = LicenseTierDTO.fromAO(this.licenseTierRepository.getByDay(date));
        return action;
    }

    public List<UserAnalyticalDTO> getUserAnalyticalByDay(Date date) {
        List<UserAnalyticalDTO> action = this.userAnalyticalRepository.getByDay(date);
        return action;
    }

    public List<CounterActionDTO> getCounterActionByInterval(Date startDate, Date endDate) {
        List<CounterActionDTO> actions = CounterActionDTO.fromAOs(this.counterActionRepository.getByPeriod(startDate, endDate));
        if (actions != null && !actions.isEmpty()) {
            for (CounterActionDTO action : actions) {
                int diff = action.getLicenseRequestCount() - action.getLogoutUserCount();
                action.setLicenseRequestCount(Math.max(diff, 0));
            }
        }
        return actions;
    }

    public List<LicenseTierDTO> getLicenseTierByInterval(Date startDate, Date endDate) {
        List<LicenseTierDTO> action = LicenseTierDTO.fromAOs(this.licenseTierRepository.getByPeriod(startDate, endDate));
        return action;
    }

    public Map<String, List<UserAnalyticalDTO>> getUserAnalyticalByInterval(Date startDate, Date endDate) {
        List<UserAnalyticalDTO> actions = UserAnalyticalDTO.fromAOs(this.userAnalyticalRepository.getByPeriod(startDate, endDate));
        Map<String, List<UserAnalyticalDTO>> result = actions.stream().collect(Collectors.groupingBy(UserAnalyticalDTO::getActionDateAsYYYYMMDD));
        return result;
    }

    public boolean dropAuditData() {
        int rec1 = this.userAnalyticalRepository.deleteAll();
        int rec2 = this.licenseTierRepository.deleteAll();
        int rec3 = this.counterActionRepository.deleteAll();
        return rec1 != -1 && rec2 != -1 && rec3 != -1;
    }

    public void testFlushDatabase() {
        this.flushTierAnalyticalToDatabase();
    }

    public int deleteCounterEventByDate(int day, int month, int year) {
        return this.counterActionRepository.deleteByDate(day, month, year);
    }
}

