/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.repository;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.SQLQuery;
import de.accxia.jira.addon.IUM.model.NavUserDTO;
import de.accxia.jira.addon.IUM.model.UserHistoryDTO;
import de.accxia.jira.addon.IUM.tables.QAppUser;
import de.accxia.jira.addon.IUM.tables.QGroup;
import de.accxia.jira.addon.IUM.tables.QMembership;
import de.accxia.jira.addon.IUM.tables.QNavUser;
import de.accxia.jira.addon.IUM.tables.QUser;
import de.accxia.jira.addon.IUM.tables.QUserHistory;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={PocketRepository.class})
@Named(value="PocketRepository")
public class PocketRepository {
    private static final Logger LOG = LoggerFactory.getLogger(PocketRepository.class);
    private final DatabaseAccessor databaseAccessor;

    public PocketRepository(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    @Deprecated
    public List<NavUserDTO> getAllNavUserForGroup(String groupName, int offset, int ctx) {
        List tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QNavUser.NAVUSER.getColumns();
            path.add(QMembership.MEMBERSHIP.childName);
            path.add(QMembership.MEMBERSHIP.parentName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QMembership.MEMBERSHIP)).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq(QMembership.MEMBERSHIP.childName))).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))).where(QUser.MEMBERSHIP.active.eq(1).and(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase())))).orderBy((OrderSpecifier<?>)QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst())).offset(offset)).limit(ctx);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getAllNavUserForGroup SQL = " + sqlQuery.toString());
                LOG.debug("getAllNavUserForGroup groupName = " + groupName);
                LOG.debug("getAllNavUserForGroup offset = " + offset);
                LOG.debug("getAllNavUserForGroup ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    public List<NavUserDTO> getOldestUsers(String groupName, int offset, int ctx) {
        List tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QNavUser.NAVUSER.getColumns();
            path.add(QMembership.MEMBERSHIP.childName);
            path.add(QMembership.MEMBERSHIP.parentName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq(QUser.MEMBERSHIP.userName))).where(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase()))).orderBy((OrderSpecifier<?>)QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst())).offset(offset)).limit(ctx);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getOldestUsers SQL = " + sqlQuery.toString());
                LOG.debug("getOldestUsers groupName = " + groupName);
                LOG.debug("getOldestUsers offset = " + offset);
                LOG.debug("getOldestUsers ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    public List<NavUserDTO> getOldestUsers(String groupName, String filterGroup, int offset, int ctx) {
        String filterGroupName = StringUtils.isEmpty((CharSequence)filterGroup) ? null : filterGroup.toLowerCase();
        List tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QNavUser.NAVUSER.getColumns();
            path.add(QUser.MEMBERSHIP.displayName);
            path.add(QUser.MEMBERSHIP.emailAddress);
            path.add(QMembership.MEMBERSHIP.childName);
            path.add(QMembership.MEMBERSHIP.parentName);
            SubQueryExpression filterQuery = filterGroupName == null ? null : (SubQueryExpression)((SQLQuery)databaseConnection.select(QMembership.MEMBERSHIP.lowerChildName).from((Expression<?>)QMembership.MEMBERSHIP)).where(QMembership.MEMBERSHIP.lowerParentName.eq(filterGroupName));
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq(QUser.MEMBERSHIP.userName));
            if (filterGroupName != null) {
                sqlQuery.where(QUser.MEMBERSHIP.active.eq(1).and(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase())).and(QMembership.MEMBERSHIP.lowerChildName.notIn(filterQuery)));
            } else {
                sqlQuery.where(QUser.MEMBERSHIP.active.eq(1).and(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase())));
            }
            ((SQLQuery)((SQLQuery)sqlQuery.orderBy((OrderSpecifier<?>)QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst())).offset(offset)).limit(ctx);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getOldestUsers SQL = " + sqlQuery.toString());
                if (filterGroupName != null) {
                    LOG.debug("getOldestUsers filterGroup = " + filterGroup);
                    LOG.debug("getOldestUsers filterQuery = " + filterQuery.toString());
                }
                LOG.debug("getOldestUsers groupName = " + groupName);
                LOG.debug("getOldestUsers offset = " + offset);
                LOG.debug("getOldestUsers ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    public long countOldestUsers(String groupName, String filterGroup) {
        String filterGroupName = StringUtils.isEmpty((CharSequence)filterGroup) ? null : filterGroup.toLowerCase();
        long tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            SubQueryExpression filterQuery = filterGroupName == null ? null : (SubQueryExpression)((SQLQuery)databaseConnection.select(QMembership.MEMBERSHIP.lowerChildName).from((Expression<?>)QMembership.MEMBERSHIP)).where(QMembership.MEMBERSHIP.lowerParentName.eq(filterGroupName.toLowerCase()));
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(new Expression[0]).from((Expression<?>)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq(QUser.MEMBERSHIP.userName));
            if (filterGroupName == null) {
                sqlQuery.where(QUser.MEMBERSHIP.active.eq(1).and(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase())));
            } else {
                sqlQuery.where(QUser.MEMBERSHIP.active.eq(1).and(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase())).and(QMembership.MEMBERSHIP.lowerChildName.notIn(filterQuery)));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("countOldestUsers SQL = " + sqlQuery.toString());
                if (filterGroupName != null) {
                    LOG.debug("countOldestUsers filterGroup = " + filterGroup);
                    LOG.debug("countOldestUsers filterQuery = " + filterQuery.toString());
                }
                LOG.debug("countOldestUsers groupName = " + groupName);
            }
            long retVal = sqlQuery.fetchCount();
            return retVal;
        });
        return tupleSQLQuery;
    }

    private List<NavUserDTO> getNavUserForGroupLtTime(String groupName, boolean onlyActive, Timestamp timestamp, int offset, int ctx) {
        List tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QNavUser.NAVUSER.getColumns();
            path.add(QMembership.MEMBERSHIP.childName);
            path.add(QMembership.MEMBERSHIP.parentName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq(QUser.MEMBERSHIP.userName));
            if (onlyActive) {
                sqlQuery.where(QUser.MEMBERSHIP.active.eq(1).and(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase())).and(QNavUser.NAVUSER.lastAccessTime.lt(timestamp).or(QNavUser.NAVUSER.lastAccessTime.isNull())));
            } else {
                sqlQuery.where(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase()).and(QNavUser.NAVUSER.lastAccessTime.lt(timestamp).or(QNavUser.NAVUSER.lastAccessTime.isNull())));
            }
            ((SQLQuery)((SQLQuery)sqlQuery.orderBy((OrderSpecifier<?>)QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst())).offset(offset)).limit(ctx);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getNavUserForGroupLtTime SQL = " + sqlQuery.toString());
                LOG.debug("getNavUserForGroupLtTime groupName = " + groupName.toLowerCase());
                LOG.debug("getNavUserForGroupLtTime timestamp = " + timestamp);
                LOG.debug("getNavUserForGroupLtTime offset = " + offset);
                LOG.debug("getNavUserForGroupLtTime ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    public List<NavUserDTO> getNavUserActiveForGroupLtTime(String groupName, Timestamp timestamp, int offset, int ctx) {
        return this.getNavUserForGroupLtTime(groupName, true, timestamp, offset, ctx);
    }

    public List<NavUserDTO> getNavUserDisableForGroupLtTime(String groupName, Timestamp timestamp, int offset, int ctx) {
        return this.getNavUserForGroupLtTime(groupName, false, timestamp, offset, ctx);
    }

    @Deprecated
    public List<UserHistoryDTO> getAllUserHistoryForGroup(String groupName, int offset, int ctx) {
        List tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(QAppUser.MEMBERSHIP.userKey, QAppUser.MEMBERSHIP.lowerUserName, QUserHistory.MEMBERSHIP.lastViewed.max().as("lastViewedDate")).from((Expression<?>)QUserHistory.MEMBERSHIP)).innerJoin((EntityPath)QAppUser.MEMBERSHIP)).on((Predicate)QAppUser.MEMBERSHIP.userKey.eq(QUserHistory.MEMBERSHIP.userName))).innerJoin((EntityPath)QMembership.MEMBERSHIP)).on((Predicate)QMembership.MEMBERSHIP.lowerChildName.eq(QAppUser.MEMBERSHIP.lowerUserName))).where(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase()))).groupBy((Expression<?>[])new Expression[]{QAppUser.MEMBERSHIP.userKey, QAppUser.MEMBERSHIP.lowerUserName})).orderBy((OrderSpecifier<?>)new OrderSpecifier(Order.ASC, QUserHistory.MEMBERSHIP.lastViewed.max()).nullsFirst())).offset(offset)).limit(ctx);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getAllUserHistoryForGroup SQL = " + sqlQuery.toString());
                LOG.debug("getAllUserHistoryForGroup groupName = " + groupName);
                LOG.debug("getAllUserHistoryForGroup offset = " + offset);
                LOG.debug("getAllUserHistoryForGroup ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToUserHistoryDTO(tupleSQLQuery);
    }

    @Deprecated
    public List<UserHistoryDTO> getOldestUsersFromUserHistory(String groupName, int offset, int ctx) {
        List tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(QAppUser.MEMBERSHIP.userKey, QAppUser.MEMBERSHIP.lowerUserName, QUserHistory.MEMBERSHIP.lastViewed.max().as("lastViewedDate")).from((Expression<?>)QUserHistory.MEMBERSHIP)).innerJoin((EntityPath)QAppUser.MEMBERSHIP)).on((Predicate)QAppUser.MEMBERSHIP.userKey.eq(QUserHistory.MEMBERSHIP.userName))).innerJoin((EntityPath)QMembership.MEMBERSHIP)).on((Predicate)QMembership.MEMBERSHIP.lowerChildName.eq(QAppUser.MEMBERSHIP.lowerUserName))).where(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase()))).groupBy((Expression<?>[])new Expression[]{QAppUser.MEMBERSHIP.userKey, QAppUser.MEMBERSHIP.lowerUserName})).orderBy((OrderSpecifier<?>)new OrderSpecifier(Order.ASC, QUserHistory.MEMBERSHIP.lastViewed.max()).nullsFirst())).offset(offset)).limit(ctx);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getOldestUsersBasedOnUserHistory SQL = " + sqlQuery.toString());
                LOG.debug("getOldestUsersBasedOnUserHistory groupName = " + groupName);
                LOG.debug("getOldestUsersBasedOnUserHistory offset = " + offset);
                LOG.debug("getOldestUsersBasedOnUserHistory ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToUserHistoryDTO(tupleSQLQuery);
    }

    public List<UserHistoryDTO> getUserHistoryForGroupLtTime(String groupName, Timestamp timestamp, int offset, int ctx) {
        List tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(QAppUser.MEMBERSHIP.userKey, QAppUser.MEMBERSHIP.lowerUserName, QUserHistory.MEMBERSHIP.lastViewed.max().as("lastViewedDate")).from((Expression<?>)QUserHistory.MEMBERSHIP)).innerJoin((EntityPath)QAppUser.MEMBERSHIP)).on((Predicate)QAppUser.MEMBERSHIP.userKey.eq(QUserHistory.MEMBERSHIP.userName))).innerJoin((EntityPath)QMembership.MEMBERSHIP)).on((Predicate)QMembership.MEMBERSHIP.lowerChildName.eq(QAppUser.MEMBERSHIP.lowerUserName))).where(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase()).and(QUserHistory.MEMBERSHIP.lastViewed.lt(timestamp.getTime()).or(QUserHistory.MEMBERSHIP.lastViewed.isNull())))).groupBy((Expression<?>[])new Expression[]{QAppUser.MEMBERSHIP.userKey, QAppUser.MEMBERSHIP.lowerUserName})).orderBy((OrderSpecifier<?>)new OrderSpecifier(Order.ASC, QUserHistory.MEMBERSHIP.lastViewed.max()).nullsFirst())).offset(offset)).limit(ctx);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getUserHistoryForGroupLtTime SQL = " + sqlQuery.toString());
                LOG.debug("getUserHistoryForGroupLtTime groupName = " + groupName);
                LOG.debug("getUserHistoryForGroupLtTime timestamp = " + timestamp);
                LOG.debug("getUserHistoryForGroupLtTime offset = " + offset);
                LOG.debug("getUserHistoryForGroupLtTime ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToUserHistoryDTO(tupleSQLQuery);
    }

    public List<NavUserDTO> getNavUserForGroupWithGroupLtTime(String fromGroupName, String withGroupName, Timestamp timestamp) {
        return this.getNavUserForGroupWithGroupLtTime(fromGroupName, withGroupName, timestamp, -1, 0);
    }

    public List<NavUserDTO> getNavUserForGroupWithGroupLtTime(String fromGroupName, String withGroupName, Timestamp timestamp, int offset, int ctx) {
        String fromGroupNameLowerCase = fromGroupName != null ? fromGroupName.toLowerCase() : "";
        String withGroupNameLowerCase = withGroupName != null ? withGroupName.toLowerCase() : "";
        List tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QNavUser.NAVUSER.getColumns();
            path.add(QUser.MEMBERSHIP.userName);
            path.add(QGroup.MEMBERSHIP.groupName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QUser.MEMBERSHIP)).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.toLowerCase().eq(QUser.MEMBERSHIP.lowerUserName))).innerJoin((EntityPath)QMembership.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on(new Predicate[]{QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId), QGroup.MEMBERSHIP.lowerGroupName.eq(fromGroupNameLowerCase)})).innerJoin((EntityPath)QMembership.MEMBERSHIP2)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP2.childId))).innerJoin((EntityPath)QGroup.MEMBERSHIP2)).on(new Predicate[]{QGroup.MEMBERSHIP2.id.eq(QMembership.MEMBERSHIP2.parentId), QGroup.MEMBERSHIP2.lowerGroupName.eq(withGroupNameLowerCase)});
            sqlQuery.where(QNavUser.NAVUSER.lastAccessTime.lt(timestamp).or(QNavUser.NAVUSER.lastAccessTime.isNull()));
            sqlQuery.orderBy((OrderSpecifier<?>)QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst());
            if (offset != -1) {
                ((SQLQuery)sqlQuery.offset(offset)).limit(ctx);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getNavUserForGroupWithGroupLtTime SQL = " + sqlQuery.toString());
                LOG.debug("getNavUserForGroupWithGroupLtTime groupName = " + fromGroupNameLowerCase);
                LOG.debug("getNavUserForGroupWithGroupLtTime withGroupName = " + withGroupNameLowerCase);
                LOG.debug("getNavUserForGroupWithGroupLtTime timestamp = " + timestamp);
                LOG.debug("getNavUserForGroupWithGroupLtTime offset = " + offset);
                LOG.debug("getNavUserForGroupWithGroupLtTime ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    @Deprecated
    public List<String> getMembershipForUser(String username) {
        List tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QMembership.MEMBERSHIP.getColumns();
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QMembership.MEMBERSHIP)).where(QMembership.MEMBERSHIP.lowerChildName.eq(username.toLowerCase()));
            if (LOG.isDebugEnabled()) {
                LOG.debug("getMmebershipForUser SQL = " + sqlQuery.toString());
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToUsertMmebership(tupleSQLQuery);
    }

    public List<String> getMembershipForGroup(String groupName) {
        List tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            List<Path<?>> path = QMembership.MEMBERSHIP.getColumns();
            path.add(QUser.MEMBERSHIP.id);
            path.add(QUser.MEMBERSHIP.directoryId);
            path.add(QUser.MEMBERSHIP.userName);
            path.add(QUser.MEMBERSHIP.lowerUserName);
            path.add(QGroup.MEMBERSHIP.id);
            path.add(QGroup.MEMBERSHIP.groupName);
            path.add(QGroup.MEMBERSHIP.lowerGroupName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(path.toArray(new Path[0])).from((Expression<?>)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).where(QMembership.MEMBERSHIP.lowerParentName.eq(groupName.toLowerCase()).and(QUser.MEMBERSHIP.active.eq(1)));
            if (LOG.isDebugEnabled()) {
                LOG.debug("getMmebershipForUser SQL = " + sqlQuery.toString());
                LOG.debug("getMmebershipForUser groupName = " + groupName.toLowerCase());
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToUsertMmebership(tupleSQLQuery);
    }

    private List<NavUserDTO> convertTuplesToNavUserDTO(List<Tuple> tupleSQLQuery) {
        ArrayList<NavUserDTO> retVal = new ArrayList<NavUserDTO>();
        for (Tuple tuple : tupleSQLQuery) {
            retVal.add(this.convertTupleToEventModel(tuple));
        }
        return retVal;
    }

    private NavUserDTO convertTupleToEventModel(Tuple tuple) {
        NavUserDTO navUserDTO = new NavUserDTO();
        if (tuple.get(QNavUser.NAVUSER.id) != null) {
            navUserDTO.setID(tuple.get(QNavUser.NAVUSER.id));
            navUserDTO.setRequestCount(tuple.get(QNavUser.NAVUSER.requestCount));
            navUserDTO.setASessionId(tuple.get(QNavUser.NAVUSER.asessionId));
            navUserDTO.setSessionId(tuple.get(QNavUser.NAVUSER.sessionId));
            navUserDTO.setUserName(tuple.get(QNavUser.NAVUSER.userName));
            navUserDTO.setLastAccessTime(tuple.get(QNavUser.NAVUSER.lastAccessTime));
            navUserDTO.setCreationTime(tuple.get(QNavUser.NAVUSER.creationTime));
            navUserDTO.setInvalidateSessionFlag(tuple.get(QNavUser.NAVUSER.invalidateSessionFlag));
        }
        navUserDTO.setUserNameEx(tuple.get(QMembership.MEMBERSHIP.childName));
        navUserDTO.setGroupNameEx(tuple.get(QMembership.MEMBERSHIP.parentName));
        if (navUserDTO.getUserNameEx() == null) {
            navUserDTO.setUserNameEx(tuple.get(QUser.MEMBERSHIP.userName));
        }
        if (navUserDTO.getGroupNameEx() == null) {
            navUserDTO.setGroupNameEx(tuple.get(QGroup.MEMBERSHIP.groupName));
        }
        navUserDTO.setDisplayNameEx(tuple.get(QUser.MEMBERSHIP.displayName));
        navUserDTO.setUserEmailEx(tuple.get(QUser.MEMBERSHIP.emailAddress));
        navUserDTO.setLastViewTime(tuple.get(QUserHistory.MEMBERSHIP.lastViewed) != null ? new Date(tuple.get(QUserHistory.MEMBERSHIP.lastViewed)) : null);
        return navUserDTO;
    }

    private List<UserHistoryDTO> convertTuplesToUserHistoryDTO(List<Tuple> tupleSQLQuery) {
        ArrayList<UserHistoryDTO> retVal = new ArrayList<UserHistoryDTO>();
        for (Tuple tuple : tupleSQLQuery) {
            retVal.add(this.convertTupleToHistoryModel(tuple));
        }
        return retVal;
    }

    private UserHistoryDTO convertTupleToHistoryModel(Tuple tuple) {
        UserHistoryDTO userHistoryDTO = new UserHistoryDTO();
        userHistoryDTO.setUserName(tuple.get(QAppUser.MEMBERSHIP.lowerUserName));
        userHistoryDTO.setUserKey(tuple.get(QAppUser.MEMBERSHIP.userKey));
        Long lastViewedDate = (Long)tuple.get(QUserHistory.MEMBERSHIP.lastViewed.max().as("lastViewedDate"));
        userHistoryDTO.setLastViewTime(lastViewedDate != null ? new Date(lastViewedDate) : null);
        return userHistoryDTO;
    }

    private List<String> convertTuplesToUsertMmebership(List<Tuple> tupleSQLQuery) {
        ArrayList<String> retVal = new ArrayList<String>();
        for (Tuple tuple : tupleSQLQuery) {
            retVal.add(this.convertTupleToMembershipModel(tuple));
        }
        return retVal;
    }

    private String convertTupleToMembershipModel(Tuple tuple) {
        ArrayList<Object> membership = new ArrayList<Object>();
        membership.add(String.valueOf(tuple.get(QMembership.MEMBERSHIP.id)));
        membership.add(tuple.get(QMembership.MEMBERSHIP.childName));
        membership.add(tuple.get(QMembership.MEMBERSHIP.lowerChildName));
        membership.add(tuple.get(QMembership.MEMBERSHIP.parentName));
        membership.add(tuple.get(QMembership.MEMBERSHIP.lowerParentName));
        membership.add(tuple.get(QMembership.MEMBERSHIP.groupType));
        membership.add(String.valueOf(tuple.get(QMembership.MEMBERSHIP.membershipType)));
        membership.add("Membership.directoryId-" + String.valueOf(tuple.get(QMembership.MEMBERSHIP.directoryId)));
        membership.add("Membership.userId=" + String.valueOf(tuple.get(QMembership.MEMBERSHIP.childId)));
        membership.add("Membership.groupId=" + String.valueOf(tuple.get(QMembership.MEMBERSHIP.parentId)));
        membership.add("User.id=" + String.valueOf(tuple.get(QUser.MEMBERSHIP.id)));
        membership.add("User.directoryId=" + String.valueOf(tuple.get(QUser.MEMBERSHIP.directoryId)));
        membership.add("User.userName=" + tuple.get(QUser.MEMBERSHIP.userName));
        membership.add("User.lowerUserName=" + tuple.get(QUser.MEMBERSHIP.lowerUserName));
        return membership.stream().collect(Collectors.joining(", "));
    }
}

