var IUMNotif = {
    bodyTemplate:function(data){

        let body = "<div id=iumalert" + data.id + " class='body'>";
        body +='IUM has automatically reduced the shared licenses to avoid exceeding the licenses - please check the shared licenses'
        body += data.message
            .split(";")
            .map(m=>'<br><span style="width: 100%; background-color: #fafbfc; color: #172b4d; font-size: 14px; font-family: inherit;"><b>'+m +'</b></span>')
            .join();
        body += '<br><br><a class="aui-button aui-button-link" onclick="IUMNotif.sendClose(\'' +  data.id + '\')"> Confirm </a>'
        body += "</div>";

        return body;
    },
    sendClose:function(id){
        AJS.$.ajax({
            type: 'POST',
            url: AJS.contextPath() + "/rest/IUM/latest/ljob/notification/"+id ,
            contentType: "application/json; charset=utf-8",
            success: function (data) {
                let elem  = document.querySelector("div.aui-message.aui-message-error > #iumalert"+id)
                elem && elem.parentElement && elem.parentElement.remove();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                IUMNotif.showErrorFlag("Filter create Error: " + jqXHR.status, jqXHR.responseText)
            },
            async: false
        });
    },

    showErrorFlag: function (title, message) {
        let myFlag = AJS.flag({
                type: 'error',
                body: message,
                close: "manual",
                title: title
            });
        },
}

AJS.$(document).ready(function () {

    AJS.$.getJSON(AJS.contextPath() + "/rest/IUM/latest/ljob/notification", function (data) {
        console.log(data);
        if (data && data.message && data.adminRead === 0) {
            let body= IUMNotif.bodyTemplate(data);
            IUMNotif.showErrorFlag("IUM4Jira", body)
        }
    })

});