/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.impl;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.cache.request.RequestCache;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.google.common.collect.ImmutableSet;
import de.accxia.jira.addon.IUM.analytical.CounterActionEventType;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.CurrentUser;
import de.accxia.jira.addon.IUM.impl.IUMHelperCacheService;
import de.accxia.jira.addon.IUM.impl.OldestUser;
import de.accxia.jira.addon.IUM.impl.PublisherHelper;
import de.accxia.jira.addon.IUM.impl.Quota;
import de.accxia.jira.addon.IUM.model.NavUserDTO;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import de.accxia.jira.addon.IUM.servlet.session.AccxiaUserSessionTracker;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntelligentUserManagerHelper {
    private static final Logger log = LoggerFactory.getLogger(IntelligentUserManagerHelper.class);
    private static UserUtil userUtil = ComponentAccessor.getUserUtil();
    private static UserManager userManagerJira = ComponentAccessor.getUserManager();
    private static final GroupManager groupManager = ComponentAccessor.getGroupManager();
    private static final UserIssueHistoryManager historyManager = (UserIssueHistoryManager)ComponentAccessor.getComponent(UserIssueHistoryManager.class);
    private static final UserSearchService userSearchService = (UserSearchService)ComponentAccessor.getComponent(UserSearchService.class);
    private static CrowdService crowdService = ComponentAccessor.getCrowdService();
    private static ApplicationRoleManager applicationRoleManager = (ApplicationRoleManager)ComponentAccessor.getComponent(ApplicationRoleManager.class);
    private static ApplicationAuthorizationService applicationAuthorizationService = (ApplicationAuthorizationService)ComponentAccessor.getComponent(ApplicationAuthorizationService.class);
    private static HashMap<String, Long> ourUsers = new HashMap();
    public static final boolean MOVE_USER = false;

    public static long getUserTS(String user) {
        return ourUsers.getOrDefault(user, 0L);
    }

    public static void setUserTS(String user, Long ts) {
        ourUsers.put(user, ts);
    }

    public static String listUsers() {
        StringBuffer res = new StringBuffer();
        for (String key : ourUsers.keySet()) {
            res.append("\n" + key + ":" + IntelligentUserManagerHelper.getUserTS(key));
        }
        return res.toString();
    }

    public static boolean isUserInGroups(ApplicationUser currentUser, String groups) {
        if (groups == null || "".equals(groups)) {
            return true;
        }
        for (String group : groups.split(",")) {
            if (!groupManager.isUserInGroup(currentUser, group)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUserInJiraAndSDGroups(ApplicationUser currentUser, String groups) {
        if (groups == null || "".equals(groups)) {
            return true;
        }
        String[] appGroups = groups.split(",");
        if (appGroups.length >= 1 && !groupManager.isUserInGroup(currentUser, appGroups[0])) {
            return false;
        }
        return appGroups.length < 2 || groupManager.isUserInGroup(currentUser, appGroups[1]);
    }

    public static boolean isUserInGroups(String username, String groups) {
        if (groups == null || "".equals(groups)) {
            return true;
        }
        for (String group : groups.split(",")) {
            if (!groupManager.isUserInGroup(username, group)) continue;
            return true;
        }
        return false;
    }

    public static long getLong(String str) {
        long d = 0L;
        try {
            d = Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
        return d;
    }

    public static String moveUserFromGroupToGroup(ApplicationUser user, String group, String toGroup, boolean move) {
        if (group.equals(toGroup)) {
            return "";
        }
        try {
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            Group theGroup = groupManager.getGroup(group);
            Group thetoGroup = groupManager.getGroup(toGroup);
            IntelligentUserManagerHelper.disableUserFromGroup(user, theGroup, thetoGroup, move, true);
            theLog.append(user.getUsername() + "=>" + thetoGroup.getName() + "</br>\n");
            return theLog.toString();
        }
        catch (Exception e) {
            log.error("Exception: " + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String moveUsersInListFromGroupToGroup(String[] selectedUsersList, String group, String toGroup, boolean move) {
        if (group == null || toGroup == null || group.equals(toGroup)) {
            return "";
        }
        try {
            int totalRemoved = 0;
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            for (String it : selectedUsersList) {
                ApplicationUser user = userManagerJira.getUserByName(it);
                if (user == null) continue;
                ++totalRemoved;
                theLog.append(IntelligentUserManagerHelper.moveUserFromGroupToGroup(user, group, toGroup, move));
            }
            String action = "Copied";
            if (move) {
                action = "Moved";
            }
            return "<b>" + action + " " + totalRemoved + " Users</b> form Group <b>" + group + "</b> to Group <b>" + toGroup + "</b></br></br>\n" + theLog.toString();
        }
        catch (Exception e) {
            log.error("Exception: " + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String moveAllUsersFromGroupToGroup(String group, String toGroup) {
        if (group == null || toGroup == null || group.equals(toGroup)) {
            return "";
        }
        try {
            int totalRemoved = 0;
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            for (ApplicationUser it : groupManager.getUsersInGroup(group)) {
                ++totalRemoved;
                theLog.append(IntelligentUserManagerHelper.moveUserFromGroupToGroup(it, group, toGroup, true));
            }
            return "<b>Moved " + totalRemoved + " Users</b> form Group <b>" + group + "</b> to Group <b>" + toGroup + "</b></br></br>\n" + theLog.toString();
        }
        catch (Exception e) {
            log.error("Exception: " + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String disableAllUsersFromTheEnabledGroups(String movegroup) {
        try {
            String group = DAO.getIUMGroups();
            String groupDisabled = DAO.getIUMGroupsDisabled();
            String[] groups = null;
            String[] groupsDisabled = null;
            if (group != null) {
                groups = group.split(",");
            }
            if (groupDisabled != null) {
                groupsDisabled = groupDisabled.split(",");
            }
            StringBuffer theLog = new StringBuffer();
            for (int i = 0; i < groups.length; ++i) {
                group = groups[i];
                if (!group.equals(movegroup)) continue;
                theLog.append(IntelligentUserManagerHelper.moveAllUsersFromGroupToGroup(group, groupsDisabled[i]));
            }
            return theLog.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static boolean disableUserFromGroup(ApplicationUser user, Group groupEnabled, Group groupDisabled, boolean move) {
        return IntelligentUserManagerHelper.disableUserFromGroup(user, groupEnabled, groupDisabled, move, false);
    }

    public static boolean disableUserFromGroup(ApplicationUser user, Group groupEnabled, Group groupDisabled, boolean move, boolean isWeb) {
        block10: {
            if (groupManager.isUserInGroup(user, groupEnabled)) {
                try {
                    block9: {
                        if (isWeb && !groupManager.isUserInGroup(user, groupDisabled)) {
                            try {
                                userUtil.addUserToGroup(groupDisabled, user);
                                log.info("Add user={} to group={}", new Object[]{user.getUsername(), groupDisabled.getName()});
                                if (log.isDebugEnabled()) {
                                    log.debug("Add user={} to group={}", new Object[]{user.getUsername(), groupDisabled.getName()});
                                }
                            }
                            catch (Exception e) {
                                if (e.getMessage() == null || e.getMessage().indexOf("uk_mem_dir_parent_child") != -1) break block9;
                                log.debug("Exception[addUserToGroup]: " + e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    if (!move) break block10;
                    try {
                        userUtil.removeUserFromGroup(groupEnabled, user);
                        log.warn("Remove user={} from group={}", new Object[]{user.getUsername(), groupEnabled.getName()});
                    }
                    catch (Exception e) {
                        log.debug("Exception[removeUserFromGroup]: " + e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
                catch (Exception e) {
                    log.error("Exception[disableUserFromGroup]: " + e.getMessage(), (Throwable)e);
                    return false;
                }
            }
        }
        return true;
    }

    public static synchronized CurrentUser enableUserFromGroup(String userName, HttpServletRequest request) {
        ApplicationUser user = userManagerJira.getUserByName(userName);
        return IntelligentUserManagerHelper.enableUserFromGroup(user, request);
    }

    public static CurrentUser enableUserFromGroup(ApplicationUser user, HttpServletRequest request) {
        String groupEnableFound = "";
        CurrentUser currentUser = new CurrentUser(null, 0);
        HashSet allowApplicationRoleSet = new HashSet();
        HashSet<ApplicationRole> unallowedApplicationRoleSet = new HashSet<ApplicationRole>();
        try {
            int queueSize;
            int i;
            String[] queueSizes;
            String group = DAO.getIUMGroups();
            String groupDisabled = DAO.getIUMGroupsDisabled();
            String queueSizeTxt = DAO.getQueueSize();
            String[] enableGroupNames = group != null ? group.split(",") : null;
            String[] disableGroupNames = groupDisabled != null ? groupDisabled.split(",") : null;
            String[] stringArray = queueSizes = queueSizeTxt != null ? queueSizeTxt.split(",") : null;
            if (enableGroupNames == null || disableGroupNames == null || queueSizes == null) {
                return new CurrentUser(null, 0);
            }
            Group[] enableGroups = new Group[enableGroupNames.length];
            Group[] disableGroups = new Group[enableGroupNames.length];
            for (i = 0; i < enableGroupNames.length; ++i) {
                enableGroups[i] = groupManager.getGroup(enableGroupNames[i]);
                disableGroups[i] = groupManager.getGroup(disableGroupNames[i]);
            }
            for (i = 0; i < enableGroupNames.length; ++i) {
                if (queueSizes[i] == null || queueSizes[i].length() == 0) continue;
                queueSize = Integer.parseInt(queueSizes[i]);
                OldestUser oldestUserFound = null;
                boolean isInsideDisableGroup = groupManager.isUserInGroup(user, disableGroups[i]);
                if (!isInsideDisableGroup) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("User {} not belong disableGroups={}  ", new Object[]{user.getName(), disableGroupNames[i]});
                    continue;
                }
                boolean isInsideEnableGroups = groupManager.isUserInGroup(user, enableGroups[i]);
                if (isInsideEnableGroups) {
                    if (currentUser.user == null) {
                        currentUser.user = user;
                        currentUser.noOfUsers = queueSize;
                    }
                    allowApplicationRoleSet.addAll(applicationRoleManager.getRolesForGroup(enableGroups[i]));
                    continue;
                }
                int noOfUsers = groupManager.getUsersInGroupCount(enableGroups[i]);
                if (log.isDebugEnabled()) {
                    log.debug("Group Analyse {} noOfUsers={}  ", new Object[]{enableGroups[i].getName(), noOfUsers});
                }
                if (queueSize != 0 && noOfUsers >= queueSize) {
                    OldestUser oldestUser = IntelligentUserManagerHelper.disableOldestUser(enableGroups[i], disableGroups[i], user);
                    oldestUserFound = IntelligentUserManagerHelper.isDifferentUser(oldestUser, user);
                }
                if (currentUser.noOfUsers == 0) {
                    currentUser.noOfUsers = queueSize;
                }
                if (oldestUserFound != null) {
                    PublisherHelper.emitCounterActionEvent(CounterActionEventType.ANALYTICAL_EVENT_LICENSE_REQ, oldestUserFound.user.getName(), disableGroupNames[i]);
                }
                if (queueSize != 0 && noOfUsers >= queueSize && (noOfUsers != queueSize || oldestUserFound == null)) continue;
                boolean guard = true;
                try {
                    block23: {
                        if (!groupManager.isUserInGroup(user, enableGroups[i])) {
                            try {
                                userUtil.addUserToGroup(enableGroups[i], user);
                                log.info("Add user={} to group={}  ", new Object[]{user.getUsername(), enableGroups[i].getName()});
                                PublisherHelper.emitCounterActionEvent(CounterActionEventType.ANALYTICAL_EVENT_IUM, user.getUsername(), enableGroupNames[i]);
                            }
                            catch (Exception e) {
                                if (e.getMessage() == null || e.getMessage().indexOf("uk_mem_dir_parent_child") != -1) break block23;
                                log.debug("Exception[addUserToGroup]: " + e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    groupEnableFound = enableGroupNames[i];
                    allowApplicationRoleSet.addAll(applicationRoleManager.getRolesForGroup(enableGroups[i]));
                }
                catch (Exception e) {
                    log.error("Exception[removeUserFromGroup]: " + e.getMessage(), (Throwable)e);
                    guard = false;
                }
                if (currentUser.user == null) {
                    currentUser.user = guard ? user : null;
                    currentUser.noOfUsers = queueSize;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Add user {} from group {} to group {} noOfUsers={} queueSize={}", new Object[]{user.getUsername(), disableGroups[i].getName(), enableGroups[i].getName(), noOfUsers, queueSize});
            }
            if (currentUser.user != null) {
                for (i = 0; i < enableGroups.length; ++i) {
                    if (queueSizes[i] == null || queueSizes[i].length() == 0 || !groupManager.isUserInGroup(user, disableGroups[i]) || groupManager.isUserInGroup(user, enableGroups[i])) continue;
                    queueSize = Integer.parseInt(queueSizes[i]);
                    if (groupManager.getUsersInGroupCount(enableGroups[i]) < queueSize) {
                        try {
                            userUtil.addUserToGroup(enableGroups[i], user);
                            if (!log.isDebugEnabled()) continue;
                            log.debug("AddEx user={} to group={}  ", new Object[]{user.getUsername(), enableGroups[i].getName()});
                        }
                        catch (Exception e) {
                            if (e.getMessage() == null || e.getMessage().indexOf("uk_mem_dir_parent_child") != -1) continue;
                            log.debug("Exception[addUserToGroup]: " + e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                    unallowedApplicationRoleSet.addAll(applicationRoleManager.getRolesForGroup(enableGroups[i]));
                }
                unallowedApplicationRoleSet.removeAll(allowApplicationRoleSet);
                currentUser.warningMessage = String.join((CharSequence)",", IntelligentUserManagerHelper.checkMissingRole(unallowedApplicationRoleSet));
            }
            return currentUser;
        }
        catch (Exception e) {
            log.error("Error on processing group: " + groupEnableFound + ":" + e.getMessage(), (Throwable)e);
            currentUser.user = null;
            return new CurrentUser(null, 0);
        }
    }

    private static void doRemoveOldestUserForAllGroups(ApplicationUser user, Group[] groups) {
        for (int i = 0; i < groups.length; ++i) {
            if (!groupManager.isUserInGroup(user, groups[i])) continue;
            try {
                userUtil.removeUserFromGroup(groups[i], user);
                if (!log.isDebugEnabled()) continue;
                log.debug("Remove user={} to group={}  ", new Object[]{user.getUsername(), groups[i].getName()});
                continue;
            }
            catch (Exception e) {
                log.error("Exception[removeUserFromGroup]: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static OldestUser isDifferentUser(OldestUser oldestUserFound, ApplicationUser user) {
        if (oldestUserFound == null || oldestUserFound.user == null || oldestUserFound.user.getKey().equalsIgnoreCase(user.getKey())) {
            return null;
        }
        return oldestUserFound;
    }

    private static List<String> checkMissingRole(Set<ApplicationRole> applicationRoleSet) {
        ArrayList<String> roles = new ArrayList<String>();
        long cnt = 0L;
        cnt = applicationRoleSet.stream().filter(applicationRole -> ApplicationKeys.SOFTWARE.equals((Object)applicationRole.getKey())).count();
        if (cnt > 0L) {
            roles.add(ApplicationKeys.SOFTWARE.value());
        }
        if ((cnt = applicationRoleSet.stream().filter(applicationRole -> ApplicationKeys.SERVICE_DESK.equals((Object)applicationRole.getKey())).count()) > 0L) {
            roles.add(ApplicationKeys.SERVICE_DESK.value());
        }
        return roles;
    }

    @Deprecated
    private static List<String> checkMissingRole(ApplicationUser user) {
        ArrayList<String> roles = new ArrayList<String>();
        if (applicationAuthorizationService.canUseApplication(user, ApplicationKeys.SOFTWARE)) {
            roles.add(ApplicationKeys.SOFTWARE.value());
        }
        if (applicationAuthorizationService.canUseApplication(user, ApplicationKeys.SERVICE_DESK)) {
            roles.add(ApplicationKeys.SERVICE_DESK.value());
        }
        if (applicationAuthorizationService.canUseApplication(user, ApplicationKeys.CORE)) {
            roles.add(ApplicationKeys.CORE.value());
        }
        return roles;
    }

    public static List<OldestUser> getOldestUser(Group group, ApplicationUser appUser, List<String> newestUsers, Timestamp refTime, int cnt) {
        ArrayList<OldestUser> oldestUserList = new ArrayList<OldestUser>();
        PocketRepository pocketRepository = (PocketRepository)ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
        if (pocketRepository != null) {
            List<NavUserDTO> navUsers = pocketRepository.getNavUserActiveForGroupLtTime(group.getName(), newestUsers, refTime, 0, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    oldestUserList.add(new OldestUser(userManagerJira.getUserByName(navUser.getUserName()), navUser.getLastAccessTime().getTime()));
                } else if (navUser.getUserNameEx() != null) {
                    oldestUserList.add(new OldestUser(userManagerJira.getUserByName(navUser.getUserNameEx()), 0L));
                }
                if (oldestUserList.size() <= cnt) continue;
                break;
            }
        }
        Collections.sort(oldestUserList, OldestUser.TIME_ASC_COMPARATOR);
        return oldestUserList;
    }

    public static List<OldestUser> getOldestUser(Group group, ApplicationUser appUser, int cnt) {
        ArrayList<OldestUser> oldestUserList = new ArrayList<OldestUser>();
        PocketRepository pocketRepository = (PocketRepository)ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
        if (pocketRepository != null) {
            List<NavUserDTO> navUsers = pocketRepository.getOldestUsers(group.getName(), 0, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    oldestUserList.add(new OldestUser(userManagerJira.getUserByName(navUser.getUserName()), navUser.getLastAccessTime().getTime()));
                } else if (navUser.getUserNameEx() != null) {
                    oldestUserList.add(new OldestUser(userManagerJira.getUserByName(navUser.getUserNameEx()), 0L));
                }
                if (oldestUserList.size() <= cnt) continue;
                break;
            }
        }
        Collections.sort(oldestUserList, OldestUser.TIME_ASC_COMPARATOR);
        return oldestUserList;
    }

    public static OldestUser disableOldestUser(Group groupEnabled, Group groupDisabled, ApplicationUser user) {
        long duration = Long.parseLong(DAO.getInactivityDuration()) * 1000L * 60L;
        Timestamp refTime = new Timestamp(System.currentTimeMillis() - duration);
        long now = new Timestamp(System.currentTimeMillis()).getTime();
        AccxiaUserSessionTracker accxiaUserSessionTracker = AccxiaUserSessionTracker.getInstance();
        List<OldestUser> oldestUserList = IntelligentUserManagerHelper.getOldestUser(groupEnabled, user, accxiaUserSessionTracker.getLatestUsersFromSession(), refTime, 10);
        if (oldestUserList.size() > 0) {
            for (OldestUser oldestUser : oldestUserList) {
                if (oldestUser == null || oldestUser.user == null) continue;
                long diff = now - oldestUser.ts;
                if (oldestUser.ts != 0L && duration != 0L && diff <= duration) continue;
                if (log.isDebugEnabled()) {
                    log.debug("disableOldestUser oldestUser={}  diff={} duration={}", new Object[]{oldestUser.user.getUsername(), diff, duration});
                }
                if (!IntelligentUserManagerHelper.disableUserFromGroup(oldestUser.user, groupEnabled, groupDisabled, true)) continue;
                return oldestUser;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("disableOldestUser NO oldest user that {} ", new Object[]{user.getUsername()});
        }
        return new OldestUser(user, 0L);
    }

    public static List<String> getInactiveUsers4EnabledGroups(String IUMEnables, String IUMDisables, long refTS, int offset, int ctx) {
        ArrayList<String> inactiveUsers = new ArrayList<String>();
        PocketRepository pocketRepository = (PocketRepository)ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
        if (pocketRepository != null) {
            try {
                List<NavUserDTO> navUserList = pocketRepository.getNavUserForGroupWithGroupLtTime(IUMEnables, IUMDisables, new Timestamp(refTS), offset, ctx);
                inactiveUsers.addAll(navUserList.stream().map(navUser -> {
                    if (navUser.getUserName() != null) {
                        return navUser.getUserName();
                    }
                    return navUser.getUserNameEx();
                }).collect(Collectors.toList()));
            }
            catch (Exception e) {
                log.error("EntityException: " + e.getMessage(), (Throwable)e);
            }
        }
        return inactiveUsers;
    }

    @Deprecated
    public static String getLastViewedForUsersInGroup() {
        List<String> group = Arrays.asList(DAO.getIUMGroups());
        SortedSet users = userUtil.getAllUsersInGroupNames(group);
        StringBuffer res = new StringBuffer();
        for (ApplicationUser user : users) {
            res.append("Login Test:" + user.getUsername() + ":" + IntelligentUserManagerHelper.getlastViewByUser(user) + "\n");
        }
        return res.toString();
    }

    private static Long getLongTimestampForIssueAndUser(ApplicationUser user, Long id) {
        List fullHistory = historyManager.getFullIssueHistoryWithoutPermissionChecks(user);
        for (UserHistoryItem historyItem : fullHistory) {
            if (!id.toString().equals(historyItem.getEntityId())) continue;
            return historyItem.getLastViewed();
        }
        return null;
    }

    public static long getLastLoginFromUser(ApplicationUser user) {
        UserWithAttributes theUser = crowdService.getUserWithAttributes(user.getName());
        String lastLoginMillisStr = theUser.getValue("login.lastLoginMillis");
        return IntelligentUserManagerHelper.getLong(lastLoginMillisStr);
    }

    public static long getlastViewByUser(ApplicationUser user) {
        Issue userCurrentIssue;
        List theHistory;
        Long lastViewed = 0L;
        long lastLogin = IntelligentUserManagerHelper.getUserTS(user.getName());
        if (lastLogin == 0L) {
            lastLogin = IntelligentUserManagerHelper.getLastLoginFromUser(user);
        }
        if ((lastViewed = (theHistory = historyManager.getShortIssueHistory(user)).size() == 0 ? Long.valueOf(0L) : ((userCurrentIssue = (Issue)historyManager.getShortIssueHistory(user).get(0)) == null ? Long.valueOf(0L) : IntelligentUserManagerHelper.getLongTimestampForIssueAndUser(user, userCurrentIssue.getId()))) > lastLogin) {
            return lastViewed;
        }
        return lastLogin;
    }

    public static long getlastViewByUserPld(ApplicationUser user) {
        List theHistory = historyManager.getShortIssueHistory(user);
        if (theHistory.size() == 0) {
            return 0L;
        }
        Issue userCurrentIssue = (Issue)historyManager.getShortIssueHistory(user).get(0);
        if (userCurrentIssue == null) {
            return 0L;
        }
        Long lastViewed = IntelligentUserManagerHelper.getLongTimestampForIssueAndUser(user, userCurrentIssue.getId());
        return lastViewed;
    }

    private static List<ApplicationUser> getAllUsers() {
        UserSearchParams userSearchParams = new UserSearchParams.Builder(100000).allowEmptyQuery(true).includeActive(true).includeInactive(true).maxResults(Integer.valueOf(100000)).build();
        return userSearchService.findUsers("", userSearchParams);
    }

    @Deprecated
    public static List<OldestUser> getSortedUserList(int max) {
        List<ApplicationUser> allUsers = IntelligentUserManagerHelper.getAllUsers();
        ArrayList<OldestUser> userList = new ArrayList<OldestUser>();
        for (ApplicationUser user : allUsers) {
            long ts = IntelligentUserManagerHelper.getlastViewByUser(user);
            OldestUser oUser = new OldestUser(user, ts);
            userList.add(oUser);
        }
        Collections.sort(userList, new Comparator<OldestUser>(){

            @Override
            public int compare(OldestUser o1, OldestUser o2) {
                return o1.ts.compareTo(o2.ts);
            }
        });
        int count = 0;
        for (OldestUser o : userList) {
            if (max > 0 && count >= max) {
                userList.remove(count);
            }
            ++count;
        }
        return userList;
    }

    @Deprecated
    public static List<OldestUser> getSortedUserListFromGroup(String group, int offset, int cnt, String filtergroup) {
        PocketRepository pocketRepository = (PocketRepository)ComponentAccessor.getOSGiComponentInstanceOfType(PocketRepository.class);
        List<NavUserDTO> navUserList = pocketRepository.getOldestUsers(group, filtergroup, offset, cnt);
        ArrayList<OldestUser> tmpUserList = new ArrayList<OldestUser>();
        for (NavUserDTO navUser : navUserList) {
            ApplicationUser user = userManagerJira.getUserByName(navUser.getUserNameEx() != null ? navUser.getUserNameEx() : navUser.getUserName());
            if (user != null && user.isActive()) {
                OldestUser oUser = new OldestUser(user, navUser.getLastAccessTime() == null ? 0L : navUser.getLastAccessTime().getTime());
                tmpUserList.add(oUser);
            }
            if (tmpUserList.size() <= cnt) continue;
            break;
        }
        return tmpUserList;
    }

    @Deprecated
    public static List<OldestUser> _getSortedUserListFromGroup(String group, int max, String filtergroup) {
        Collection theUsers;
        Collection allUsers = groupManager.getUserNamesInGroup(group);
        Collection filterUsers = groupManager.getUserNamesInGroup(filtergroup);
        ArrayList<OldestUser> userList = new ArrayList<OldestUser>();
        int numAll = 0;
        int numFilter = 0;
        if (allUsers == null) {
            return userList;
        }
        if ("".equals(filtergroup)) {
            theUsers = allUsers;
        } else {
            numAll = allUsers.size();
            if (filterUsers != null) {
                numFilter = filterUsers.size();
            }
            if (numFilter == 0 || numAll == 0) {
                return userList;
            }
            theUsers = numAll > 0 && numFilter > numAll ? groupManager.filterUsersInAllGroupsDirect(allUsers, Arrays.asList(filtergroup)) : groupManager.filterUsersInAllGroupsDirect(filterUsers, Arrays.asList(group));
        }
        ArrayList<OldestUser> tmpUserList = new ArrayList<OldestUser>();
        for (String userName : theUsers) {
            ApplicationUser user = userManagerJira.getUserByName(userName);
            if (!user.isActive()) continue;
            long ts = IntelligentUserManagerHelper.getlastViewByUser(user);
            OldestUser oUser = new OldestUser(user, ts);
            tmpUserList.add(oUser);
        }
        Collections.sort(tmpUserList, new Comparator<OldestUser>(){

            @Override
            public int compare(OldestUser o1, OldestUser o2) {
                return o1.ts.compareTo(o2.ts);
            }
        });
        int count = 0;
        for (OldestUser o : tmpUserList) {
            if (max == 0 || count < max) {
                userList.add(o);
            }
            ++count;
        }
        return userList;
    }

    public static List<String> moveUserToDisabled(ApplicationUser user) {
        ArrayList<String> groupNames = new ArrayList<String>();
        String group = DAO.getIUMGroups();
        String groupDisabled = DAO.getIUMGroupsDisabled();
        String[] groups = null;
        String[] groupsDisabled = null;
        if (group != null) {
            groups = group.split(",");
        }
        if (groupDisabled != null) {
            groupsDisabled = groupDisabled.split(",");
        }
        for (int i = 0; i < groups.length; ++i) {
            if (!groupManager.isUserInGroup(user, groups[i])) continue;
            Group theGroup = groupManager.getGroup(groups[i]);
            Group theGroupDisabled = groupManager.getGroup(groupsDisabled[i]);
            if (theGroup == null || theGroupDisabled == null) continue;
            groupNames.add(groups[i]);
            IntelligentUserManagerHelper.disableUserFromGroup(user, theGroup, theGroupDisabled, true);
            PublisherHelper.emitCounterActionEvent(CounterActionEventType.ANALYTICAL_EVENT_LICENSE_REQ, user.getUsername(), groups[i]);
        }
        return groupNames;
    }

    public static boolean simulateUserToEnabledGroup(ApplicationUser user) {
        String groupEnabled = DAO.getIUMGroups();
        String groupDisabled = DAO.getIUMGroupsDisabled();
        if (groupEnabled == null || groupDisabled == null) {
            return false;
        }
        boolean retVal = false;
        String[] groupsEnabled = groupEnabled.split(",");
        String[] groupsDisabled = groupDisabled.split(",");
        for (int i = 0; i < groupsDisabled.length; ++i) {
            if (StringUtils.isEmpty((CharSequence)groupsEnabled[i]) || StringUtils.isEmpty((CharSequence)groupsDisabled[i]) || !groupManager.isUserInGroup(user, groupsDisabled[i])) continue;
            Group theEnabledGroup = groupManager.getGroup(groupsEnabled[i]);
            Group theDisableGroup = groupManager.getGroup(groupsDisabled[i]);
            Field field = null;
            try {
                field = FieldUtils.getField(groupManager.getClass(), (String)"usernameToGroups", (boolean)true);
                field.setAccessible(true);
                RequestCache usernameToGroups = (RequestCache)field.get(groupManager);
                ImmutableSet grp1 = new ImmutableSet.Builder().addAll((Iterable)usernameToGroups.get((Object)user.getUsername())).add((Object)theEnabledGroup).build();
                usernameToGroups.remove((Object)user.getUsername());
                usernameToGroups.get((Object)user.getUsername(), () -> IntelligentUserManagerHelper.lambda$simulateUserToEnabledGroup$3((Set)grp1));
                field = FieldUtils.getField(groupManager.getClass(), (String)"usernameToGroupNames", (boolean)true);
                field.setAccessible(true);
                RequestCache usernameToGroupNames = (RequestCache)field.get(groupManager);
                ImmutableSet grp2 = new ImmutableSet.Builder().addAll((Iterable)usernameToGroupNames.get((Object)user.getUsername())).add((Object)theEnabledGroup.getName()).build();
                usernameToGroupNames.remove((Object)user.getUsername());
                usernameToGroupNames.get((Object)user.getUsername(), () -> IntelligentUserManagerHelper.lambda$simulateUserToEnabledGroup$4((Set)grp2));
                field = FieldUtils.getField(groupManager.getClass(), (String)"usernameToGroupNamesInLowerCase", (boolean)true);
                field.setAccessible(true);
                RequestCache usernameToGroupNamesInLowerCase = (RequestCache)field.get(groupManager);
                ImmutableSet grp3 = new ImmutableSet.Builder().addAll((Iterable)usernameToGroupNamesInLowerCase.get((Object)user.getUsername())).add((Object)theEnabledGroup.getName().toLowerCase()).build();
                usernameToGroupNamesInLowerCase.remove((Object)user.getUsername());
                usernameToGroupNamesInLowerCase.get((Object)user.getUsername(), () -> IntelligentUserManagerHelper.lambda$simulateUserToEnabledGroup$5((Set)grp3));
                retVal = true;
            }
            catch (IllegalAccessException e) {
                log.error("Exception " + e.getMessage(), (Throwable)e);
                return false;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Verify Move[simulate] {} isIumEnabled={}  isIumDisabled={} ", new Object[]{user.getUsername(), IntelligentUserManagerHelper.isUserInGroups(user, groupsEnabled[i]), IntelligentUserManagerHelper.isUserInGroups(user, groupsDisabled[i])});
        }
        return retVal;
    }

    public static boolean simulateUserToALLEnabledGroup(ApplicationUser user) {
        String groupEnabled = DAO.getIUMGroups();
        log.debug("Verify Move[simulate] groupsEnabled={} ", new Object[]{groupEnabled});
        if (groupEnabled == null) {
            return false;
        }
        boolean retVal = false;
        String[] groupsEnabled = groupEnabled.split(",");
        for (int i = 0; i < groupsEnabled.length; ++i) {
            if (StringUtils.isEmpty((CharSequence)groupsEnabled[i])) continue;
            Group theEnabledGroup = groupManager.getGroup(groupsEnabled[i]);
            if (log.isDebugEnabled()) {
                log.debug("simulateUser user={} groupsEnabled={} ", new Object[]{user.getUsername(), groupsEnabled[i]});
                log.debug("simulateUser user{} theEnabledGroup={} ", new Object[]{user.getUsername(), theEnabledGroup});
            }
            Field field = null;
            try {
                field = FieldUtils.getField(groupManager.getClass(), (String)"usernameToGroups", (boolean)true);
                field.setAccessible(true);
                RequestCache usernameToGroups = (RequestCache)field.get(groupManager);
                ImmutableSet grp1 = new ImmutableSet.Builder().addAll((Iterable)usernameToGroups.get((Object)user.getUsername())).add((Object)theEnabledGroup).build();
                usernameToGroups.remove((Object)user.getUsername());
                usernameToGroups.get((Object)user.getUsername(), () -> IntelligentUserManagerHelper.lambda$simulateUserToALLEnabledGroup$6((Set)grp1));
                field = FieldUtils.getField(groupManager.getClass(), (String)"usernameToGroupNames", (boolean)true);
                field.setAccessible(true);
                RequestCache usernameToGroupNames = (RequestCache)field.get(groupManager);
                ImmutableSet grp2 = new ImmutableSet.Builder().addAll((Iterable)usernameToGroupNames.get((Object)user.getUsername())).add((Object)theEnabledGroup.getName()).build();
                usernameToGroupNames.remove((Object)user.getUsername());
                usernameToGroupNames.get((Object)user.getUsername(), () -> IntelligentUserManagerHelper.lambda$simulateUserToALLEnabledGroup$7((Set)grp2));
                field = FieldUtils.getField(groupManager.getClass(), (String)"usernameToGroupNamesInLowerCase", (boolean)true);
                field.setAccessible(true);
                RequestCache usernameToGroupNamesInLowerCase = (RequestCache)field.get(groupManager);
                ImmutableSet grp3 = new ImmutableSet.Builder().addAll((Iterable)usernameToGroupNamesInLowerCase.get((Object)user.getUsername())).add((Object)theEnabledGroup.getName().toLowerCase()).build();
                usernameToGroupNamesInLowerCase.remove((Object)user.getUsername());
                usernameToGroupNamesInLowerCase.get((Object)user.getUsername(), () -> IntelligentUserManagerHelper.lambda$simulateUserToALLEnabledGroup$8((Set)grp3));
                retVal = true;
            }
            catch (IllegalAccessException e) {
                log.error("Exception " + e.getMessage(), (Throwable)e);
                return false;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Verify Move[simulate] {} isIumEnabled={} ", new Object[]{user.getUsername(), IntelligentUserManagerHelper.isUserInGroups(user, groupsEnabled[i])});
        }
        return retVal;
    }

    public static Quota getQuotaForGroupOfUsername(String username) {
        boolean quota = false;
        String groupDisabled = DAO.getIUMGroupsDisabled();
        String queueSizeTxt = DAO.getQueueSize();
        String groupEnabled = DAO.getIUMGroups();
        if (groupEnabled == null || groupDisabled == null || queueSizeTxt == null) {
            return Quota.Empty;
        }
        String[] groupsDisabled = groupDisabled.split(",");
        String[] groupsEnabled = groupEnabled.split(",");
        String[] queueSizes = queueSizeTxt.split(",");
        for (int i = 0; i < groupsDisabled.length; ++i) {
            if (queueSizes[i] == null || queueSizes[i].length() == 0 || !groupManager.isUserInGroup(username, groupsDisabled[i])) continue;
            return new Quota(Integer.parseInt(queueSizes[i]), groupManager.getUsersInGroupCount(groupsEnabled[i]), IUMHelperCacheService.getInstance().hasUserAutomaticRemovalStatus(username));
        }
        return Quota.Empty;
    }

    public static Quota checkCanGetFreeSlots(String username) {
        String groupDisabled = DAO.getIUMGroupsDisabled();
        String queueSizeTxt = DAO.getQueueSize();
        String groupEnabled = DAO.getIUMGroups();
        if (groupEnabled == null || groupDisabled == null || queueSizeTxt == null) {
            return Quota.Empty;
        }
        String[] groupsDisabled = groupDisabled.split(",");
        String[] groupsEnabled = groupEnabled.split(",");
        String[] queueSizes = queueSizeTxt.split(",");
        for (int i = 0; i < groupsDisabled.length; ++i) {
            if (queueSizes[i] == null || queueSizes[i].length() == 0) continue;
            int qs = Integer.parseInt(queueSizes[i]);
            int queue = 0;
            if (groupManager.isUserInGroup(username, groupsDisabled[i]) && (queue = groupManager.getUsersInGroupCount(groupsEnabled[i])) < qs) {
                return new Quota(qs, qs - queue, IUMHelperCacheService.getInstance().hasUserAutomaticRemovalStatus(username));
            }
            if (!groupManager.isUserInGroup(username, groupsEnabled[i])) continue;
            return new Quota(qs, 1, false);
        }
        return Quota.Empty;
    }

    private static /* synthetic */ Set lambda$simulateUserToALLEnabledGroup$8(Set grp3) {
        return grp3;
    }

    private static /* synthetic */ Set lambda$simulateUserToALLEnabledGroup$7(Set grp2) {
        return grp2;
    }

    private static /* synthetic */ Set lambda$simulateUserToALLEnabledGroup$6(Set grp1) {
        return grp1;
    }

    private static /* synthetic */ Set lambda$simulateUserToEnabledGroup$5(Set grp3) {
        return grp3;
    }

    private static /* synthetic */ Set lambda$simulateUserToEnabledGroup$4(Set grp2) {
        return grp2;
    }

    private static /* synthetic */ Set lambda$simulateUserToEnabledGroup$3(Set grp1) {
        return grp1;
    }
}

