/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.saml;

import de.accxia.jira.addon.IUM.config.DAO;
import java.io.IOException;
import java.io.StringReader;
import java.util.Base64;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SAMLHelper {
    private static final Logger log = LoggerFactory.getLogger(SAMLHelper.class);

    public static String decodeBase64b(String b64Data) {
        if (b64Data == null) {
            return "<Error></Error>";
        }
        b64Data = b64Data.replaceAll("\r\n", "");
        byte[] dmessage = Base64.getDecoder().decode(b64Data.getBytes());
        return new String(dmessage);
    }

    public static String getUserFromSAMLResponse(String response) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(response)));
            NodeList resUser = document.getElementsByTagName(DAO.getSamlMapping());
            if (resUser.getLength() > 0 && resUser.item(0) != null) {
                return resUser.item(0).getTextContent();
            }
        }
        catch (ParserConfigurationException e) {
            log.error("AccxiaError:" + e.getMessage(), (Throwable)e);
        }
        catch (IOException | SAXException e) {
            log.error("AccxiaError:" + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static String getSAMLUserFromSAMLResponse(String samlPar) {
        if (samlPar == null) {
            return null;
        }
        String samlXML = SAMLHelper.decodeBase64b(samlPar);
        if (log.isDebugEnabled()) {
            log.debug("SAML XML: {}", (Object)samlXML);
        }
        String user = SAMLHelper.getUserFromSAMLResponse(samlXML);
        return user;
    }
}

