/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.session;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.util.http.HttpRequestType;
import com.atlassian.jira.web.filters.accesslog.AccessLogIPAddressUtil;
import com.atlassian.jira.web.session.currentusers.JiraUserSession;
import de.accxia.jira.addon.IUM.model.NavUser;
import de.accxia.jira.addon.IUM.model.NavUserDTO;
import de.accxia.jira.addon.IUM.repository.NavUserRepository;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
class AccxiaMutableJiraUserSession
implements JiraUserSession {
    private static final Logger log = LoggerFactory.getLogger(AccxiaMutableJiraUserSession.class);
    private final AtomicLong ID = new AtomicLong(0L);
    private final AtomicLong requestCount;
    private final AtomicReference<String> userName;
    private final AtomicReference<String> ipAddress;
    private final AtomicReference<Date> lastAccessTime;
    private final AtomicReference<Date> creationTime;
    private final AtomicBoolean invalidateSessionFlag;
    private final HttpRequestType type;
    private final String asessionId;
    private final String sessionId;

    public AccxiaMutableJiraUserSession(HttpRequestType type, String sessionId, String asessionId) {
        this(type, sessionId, asessionId, null);
    }

    public AccxiaMutableJiraUserSession(HttpRequestType type, String sessionId, String asessionId, String userName) {
        this.type = type;
        this.sessionId = sessionId;
        this.asessionId = asessionId;
        this.requestCount = new AtomicLong(0L);
        this.userName = new AtomicReference<String>(userName);
        this.ipAddress = new AtomicReference();
        this.lastAccessTime = new AtomicReference<Date>(new Date());
        this.creationTime = new AtomicReference<Date>(new Date());
        this.invalidateSessionFlag = new AtomicBoolean(false);
    }

    public String getId() {
        return this.sessionId;
    }

    public String getASessionId() {
        return this.asessionId;
    }

    public long getRequestCount() {
        return this.requestCount.get();
    }

    public String getUserName() {
        return this.userName.get();
    }

    public HttpRequestType getType() {
        return this.type;
    }

    public String getIpAddress() {
        return this.ipAddress.get();
    }

    public Date getCreationTime() {
        return this.creationTime.get();
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime.get();
    }

    public Boolean getInvalidateSessionFlag() {
        return this.invalidateSessionFlag.get();
    }

    void recordInteraction(HttpServletRequest httpServletRequest, String userName) {
        this.requestCount.incrementAndGet();
        if (this.lastAccessTime.get() == null || this.lastAccessTime.get().getTime() < 100L) {
            this.lastAccessTime.set(new Date());
        }
        this.ipAddress.set(AccessLogIPAddressUtil.getRemoteAddr((HttpServletRequest)httpServletRequest));
        this.userName.set(userName);
    }

    void recordLastActivity() {
        this.lastAccessTime.set(new Date());
    }

    void recordInteractionDB() {
        NavUserRepository navUserRepository = (NavUserRepository)ComponentAccessor.getOSGiComponentInstanceOfType(NavUserRepository.class);
        if (navUserRepository != null) {
            NavUser[] navUsers;
            NavUserDTO navUserDTO = this.buildNavUserDTO();
            if (this.ID.get() == 0L && (navUsers = navUserRepository.getByUserName(navUserDTO.getUserName())).length > 0) {
                NavUser refNavUser = navUsers[navUsers.length - 1];
                this.ID.set(refNavUser.getID());
                if (navUsers.length > 1) {
                    navUserRepository.deleteOldestExceptUsers(navUserDTO.getUserName(), refNavUser);
                }
            }
            if (this.ID.get() == 0L) {
                NavUser navUser = navUserRepository.save(navUserDTO);
                this.ID.set(navUser.getID());
            } else {
                navUserRepository.update(this.ID.get(), this.asessionId, this.sessionId, this.requestCount.get(), this.userName.get());
            }
        }
    }

    void removeDB() {
        NavUserRepository navUserRepository = (NavUserRepository)ComponentAccessor.getOSGiComponentInstanceOfType(NavUserRepository.class);
        if (navUserRepository != null) {
            navUserRepository.deleteBySession(this.asessionId, this.sessionId);
        }
    }

    private NavUserDTO buildNavUserDTO() {
        NavUserDTO navUserDTO = new NavUserDTO();
        navUserDTO.setID((int)this.ID.get());
        navUserDTO.setRequestCount(this.requestCount.get());
        navUserDTO.setUserName(this.userName.get());
        navUserDTO.setLastAccessTime(this.lastAccessTime.get());
        navUserDTO.setCreationTime(this.creationTime.get());
        navUserDTO.setInvalidateSessionFlag(this.invalidateSessionFlag.get());
        navUserDTO.setASessionId(this.asessionId);
        navUserDTO.setSessionId(this.sessionId);
        return navUserDTO;
    }

    void setInvalidateSessionFlag(boolean invalidateSessionFlag) {
        this.invalidateSessionFlag.set(invalidateSessionFlag);
    }
}

