/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.analytical;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.jira.addon.IUM.analytical.PermissionMarkerType;
import de.accxia.jira.addon.IUM.analytical.UserAnalytical;
import de.accxia.jira.addon.IUM.analytical.UserAnalyticalDTO;
import de.accxia.jira.addon.IUM.repository.UtilRepository;
import de.accxia.jira.addon.IUM.utils.DateUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={UserAnalyticalRepository.class})
@Named(value="UserAnalyticalRepository")
public class UserAnalyticalRepository {
    private static final Logger LOG = LoggerFactory.getLogger(UserAnalyticalRepository.class);
    @ComponentImport
    private final ActiveObjects ao;
    private BiPredicate<Date, Date> sameDatePredicate = (date1, date2) -> DateUtil.isSameDay(date1, date2);

    @Inject
    public UserAnalyticalRepository(ActiveObjects ao) {
        this.ao = ao;
    }

    public UserAnalytical save(UserAnalyticalDTO userAnalyticalDTO) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Called save for date {}", (Object)userAnalyticalDTO.getActionDate());
        }
        if (!UtilRepository.checkAO(this.ao)) {
            return null;
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("USERNAME", userAnalyticalDTO.getUsername());
        values.put("IUM_JIRA", userAnalyticalDTO.getPermIumJira().getValue());
        values.put("IUM_JSM", userAnalyticalDTO.getPermIumJsm().getValue());
        values.put("ADMIN", userAnalyticalDTO.getPermAdmin().getValue());
        values.put("JIRA", userAnalyticalDTO.getPermJira().getValue());
        values.put("JSM", userAnalyticalDTO.getPermJsm().getValue());
        values.put("BANNED", userAnalyticalDTO.getBanned());
        values.put("JOB_BANNED", userAnalyticalDTO.getJobBanned());
        values.put("ACTION_HOUR", userAnalyticalDTO.getActionHour());
        values.put("ACTION_DATE", userAnalyticalDTO.getActionDate());
        UserAnalytical response = (UserAnalytical)this.ao.create(UserAnalytical.class, values);
        return response;
    }

    public UserAnalytical update(UserAnalytical ua, UserAnalyticalDTO userAnalyticalDTO) {
        if (ua == null) {
            return this.save(userAnalyticalDTO);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Called save for date {}", (Object)userAnalyticalDTO.getActionDate());
        }
        ua.setUsername(userAnalyticalDTO.getUsername());
        ua.setIumJira(this.getMax(ua.getIumJira(), userAnalyticalDTO.getPermIumJira()));
        ua.setIumJsm(this.getMax(ua.getIumJsm(), userAnalyticalDTO.getPermIumJsm()));
        ua.setAdmin(this.getMax(ua.getAdmin(), userAnalyticalDTO.getPermAdmin()));
        ua.setJira(this.getMax(ua.getJira(), userAnalyticalDTO.getPermJira()));
        ua.setJsm(this.getMax(ua.getJsm(), userAnalyticalDTO.getPermJsm()));
        ua.setBanned(this.getSum(ua.getBanned(), userAnalyticalDTO.getBanned()));
        ua.setJobBanned(this.getSum(ua.getJobBanned(), userAnalyticalDTO.getJobBanned()));
        ua.setActionHour(userAnalyticalDTO.getActionHour());
        ua.setActionDate(userAnalyticalDTO.getActionDate());
        ua.save();
        return ua;
    }

    private Integer getSum(int b1, int b2) {
        return b1 + b2;
    }

    private Integer getMax(int baseValue, PermissionMarkerType permMarker) {
        int maxValue = baseValue > permMarker.getValue() ? baseValue : permMarker.getValue();
        return maxValue;
    }

    public void saveOrUpdateBatch(List<UserAnalyticalDTO> userAnalyticalList) {
        if (userAnalyticalList == null || userAnalyticalList.isEmpty()) {
            return;
        }
        Date currentDate = userAnalyticalList.get(0).getActionDate();
        Map<Integer, List<UserAnalyticalDTO>> userPerHours = userAnalyticalList.stream().filter(ua -> this.sameDatePredicate.test(ua.getActionDate(), currentDate)).collect(Collectors.groupingBy(UserAnalyticalDTO::getActionHour));
        this.ao.executeInTransaction(() -> {
            userPerHours.forEach((hour, uaList) -> {
                Object[] keys = (String[])uaList.stream().map(UserAnalyticalDTO::getUsername).toArray(String[]::new);
                UserAnalytical[] existing = (UserAnalytical[])this.ao.find(UserAnalytical.class, Query.select().where("ACTION_DATE=  ?  AND ACTION_HOUR=  ? AND USERNAME IN (" + this.preparePlaceholders(keys.length) + ")", UserAnalyticalRepository.prepend(keys, currentDate, hour)));
                for (UserAnalytical ua : existing) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found existing user {} for hour {}", (Object)ua.getUsername(), hour);
                    }
                    UserAnalyticalDTO tmp = UserAnalyticalDTO.fromAO(ua);
                    UserAnalyticalDTO currentTmp = uaList.stream().filter(uaDTO -> uaDTO.equals(tmp)).findFirst().orElse(null);
                    if (currentTmp == null) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("User {} already exists for hour {}", (Object)ua.getUsername(), hour);
                    }
                    this.update(ua, currentTmp);
                    uaList.remove(currentTmp);
                }
                for (UserAnalyticalDTO analytical : uaList) {
                    this.save(analytical);
                }
            });
            return null;
        });
    }

    public List<UserAnalyticalDTO> getByDay(Date date) {
        ArrayList<UserAnalyticalDTO> result = new ArrayList<UserAnalyticalDTO>();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Called getByDay ");
        }
        UserAnalytical[] queryResult = (UserAnalytical[])this.ao.find(UserAnalytical.class, Query.select().where("ACTION_DATE = ?", new Object[]{date}));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully fetch result for getByDay");
        }
        if (queryResult != null && queryResult.length > 0) {
            for (UserAnalytical userAnalytical : queryResult) {
                result.add(UserAnalyticalDTO.fromAO(userAnalytical));
            }
        }
        return result;
    }

    public UserAnalytical[] getByPeriod(Date startDate, Date endDate) {
        ArrayList result = new ArrayList();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Called getByPeriod ");
        }
        UserAnalytical[] queryResult = (UserAnalytical[])this.ao.find(UserAnalytical.class, Query.select().where("ACTION_DATE BETWEEN ? AND ?", new Object[]{startDate, endDate}));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully fetch result for getByPeriod");
        }
        return queryResult;
    }

    private String preparePlaceholders(int count) {
        return String.join((CharSequence)",", Collections.nCopies(count, "?"));
    }

    private static Object[] prepend(Object[] arr, Object el1, Object el2) {
        int N = arr.length;
        Object[] newArgs = new Object[N + 2];
        System.arraycopy(arr, 0, newArgs, 2, arr.length);
        newArgs[0] = el1;
        newArgs[1] = el2;
        return newArgs;
    }

    public int deleteAll() {
        try {
            int recs = this.ao.deleteWithSQL(UserAnalytical.class, "1=1", new Object[0]);
            return recs;
        }
        catch (Exception e) {
            LOG.error("Error while deleting all records", (Throwable)e);
            return -1;
        }
    }
}

