/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AccxiaCacheComponent {
    private static final Logger LOG = LoggerFactory.getLogger(AccxiaCacheComponent.class);
    private static final String PLUGIN_STORAGE_KEY = "de.accxia.jira.addons.usermanager";
    private CacheManager cacheManager;
    private CacheFactory cacheFactory;
    private Cache<String, String> cache;
    private PluginSettingsFactory pluginSettingsFactory;
    private PluginSettings pluginSettings;

    @Inject
    public AccxiaCacheComponent(@ComponentImport CacheFactory cacheFactory, @ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.cacheFactory = cacheFactory;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.cache = this.cacheFactory.getCache(AccxiaCacheComponent.class.getName() + ".configurations", field -> {
            Object value = this.pluginSettings.get("de.accxia.jira.addons.usermanager." + field);
            if (value == null || "null".equals(value)) {
                return "";
            }
            String res = String.valueOf(value);
            if (LOG.isDebugEnabled()) {
                LOG.debug("cacheFactory.getCache field={} value={}", new Object[]{field, res});
            }
            return res;
        });
    }

    public Cache<String, String> getCache() {
        return this.cache;
    }

    public String getValue(String field) {
        String value = (String)this.cache.get((Object)field);
        if (LOG.isDebugEnabled()) {
            LOG.debug("AccxiaCacheComponent.getValue is value " + (value == null ? "NULL" : value.toString()));
        }
        return value;
    }

    public void setValue(String field, String value) {
        String olderValue = this.getValue(field);
        if (!(value == null && olderValue == null || value != null && value.equals(olderValue))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("DAO.getValue field={} value={}", new Object[]{field, value});
            }
            this.pluginSettings.put("de.accxia.jira.addons.usermanager." + field, (Object)value);
            this.cache.put((Object)field, (Object)value);
        }
    }
}

