/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.config;

import de.accxia.jira.addon.IUM.config.DAO;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestRoute {
    private static final Logger LOG = LoggerFactory.getLogger(RestRoute.class);
    private static RestRoute instance = null;
    private static final String REGEX = "\\R";
    public static final String[] REST_ROUTE_DEFAULT = new String[]{"/rest/api", "/rest/ical", "/rest/greenhopper", "/rest/gadget", "/rest/capabilities/navigation", "/sr/jira.issueviews:searchrequest-xml", "/servicedesk/customer/portals"};
    public static final String[] REST_ROUTE = new String[]{"/rest/greenhopper", "/rest/restresource", "/rest/capabilities"};
    private String[] restRoutes;

    private RestRoute() {
        String tmp = DAO.getValue("urlRest");
        String init = DAO.getValue("initRest");
        if (!(init != null && init.length() != 0 || tmp != null && tmp.length() != 0)) {
            tmp = String.join((CharSequence)", ", REST_ROUTE);
            DAO.setValue("initRest", "true");
        }
        this.updateRestRoute(tmp);
    }

    public static String removeDefaultRoute(String urlRest) {
        if (!urlRest.isEmpty()) {
            urlRest = Arrays.stream(urlRest.split(REGEX)).filter(route -> !RestRoute.isDefaultRestRoute(route)).collect(Collectors.joining("\r\n"));
        }
        return urlRest;
    }

    private static boolean isDefaultRestRoute(String route) {
        boolean found = false;
        for (int i = 0; i < REST_ROUTE_DEFAULT.length; ++i) {
            if (!REST_ROUTE_DEFAULT[i].equalsIgnoreCase(route)) continue;
            found = true;
            break;
        }
        return found;
    }

    public void updateRestRoute(String tmpRestRoutes) {
        String[] newRestRoutes = StringUtils.isEmpty((CharSequence)tmpRestRoutes) ? new String[]{} : tmpRestRoutes.split(REGEX);
        HashSet<String> unionSet = new HashSet<String>();
        unionSet.addAll(Arrays.asList(REST_ROUTE_DEFAULT));
        for (String newRestRoute : newRestRoutes) {
            if (StringUtils.isEmpty((CharSequence)(newRestRoute = newRestRoute.trim()))) continue;
            unionSet.add(newRestRoute);
        }
        unionSet.addAll(Arrays.asList(newRestRoutes));
        this.restRoutes = unionSet.toArray(new String[0]);
        if (LOG.isDebugEnabled()) {
            for (String route : this.restRoutes) {
                LOG.debug("restRoutes |{}|", (Object)route);
            }
        }
    }

    public String[] getRestRoutes() {
        return this.restRoutes;
    }

    public String[] getAllRestRoutes() {
        if (this.isEmpty()) {
            return REST_ROUTE_DEFAULT;
        }
        this.restRoutes = DAO.getUrlRestAsArray(REGEX);
        return RestRoute.concatWithArrayCopy(REST_ROUTE_DEFAULT, this.restRoutes);
    }

    public boolean isEmpty() {
        return this.restRoutes == null || this.restRoutes.length == 0;
    }

    public static RestRoute getInstance() {
        if (instance == null) {
            instance = new RestRoute();
        }
        return instance;
    }

    private static <T> T[] concatWithArrayCopy(T[] array1, T[] array2) {
        T[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }
}

